/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Base;
import com.wb.common.Dictionary;
import com.wb.common.KVBuffer;
import com.wb.common.Var;
import com.wb.tool.DictRecord;
import com.wb.tool.Query;
import com.wb.tool.Updater;
import com.wb.util.DateUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DbUtil {
    public static final Object[][] sqlTypes = new Object[][]{{"BIT", -7}, {"TINYINT", -6}, {"SMALLINT", 5}, {"INTEGER", 4}, {"BIGINT", -5}, {"FLOAT", 6}, {"REAL", 7}, {"DOUBLE", 8}, {"NUMERIC", 2}, {"DECIMAL", 3}, {"CHAR", 1}, {"VARCHAR", 12}, {"LONGVARCHAR", -1}, {"DATE", 91}, {"TIME", 92}, {"TIMESTAMP", 93}, {"BINARY", -2}, {"VARBINARY", -3}, {"LONGVARBINARY", -4}, {"NULL", 0}, {"OTHER", 1111}, {"JAVA_OBJECT", 2000}, {"DISTINCT", 2001}, {"STRUCT", 2002}, {"ARRAY", 2003}, {"BLOB", 2004}, {"CLOB", 2005}, {"REF", 2006}, {"DATALINK", 70}, {"BOOLEAN", 16}, {"ROWID", -8}, {"NCHAR", -15}, {"NVARCHAR", -9}, {"LONGNVARCHAR", -16}, {"NCLOB", 2011}, {"SQLXML", 2009}};

    public static Integer getFieldType(String name) {
        if (StringUtil.isEmpty(name)) {
            return 12;
        }
        int j = sqlTypes.length;
        int i = 0;
        while (i < j) {
            if (name.equalsIgnoreCase((String)sqlTypes[i][0])) {
                return (Integer)sqlTypes[i][1];
            }
            ++i;
        }
        if (StringUtil.isNumeric(name, false)) {
            return Integer.parseInt(name);
        }
        return null;
    }

    public static String getTypeName(int type) {
        int j = sqlTypes.length;
        int i = 0;
        while (i < j) {
            if (type == (Integer)sqlTypes[i][1]) {
                return ((String)sqlTypes[i][0]).toLowerCase();
            }
            ++i;
        }
        return Integer.toString(type);
    }

    public static void importData(Connection connection, String tableName, BufferedReader reader) throws Exception {
        DbUtil.importData(connection, tableName, reader, null, ' ');
    }

    public static void importData(Connection connection, String tableName, BufferedReader reader, String[] fieldList, char fieldSeparator) throws Exception {
        ResultSet rs = null;
        PreparedStatement st = null;
        boolean jsonFormat = fieldList == null;
        try {
            String line;
            st = connection.prepareStatement(StringUtil.concat("select * from ", tableName, " where 1=0"));
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount();
            int[] indexList = jsonFormat ? (int[])null : new int[j];
            int[] types = new int[j];
            String[] fieldNames = new String[j];
            String[] quoteNames = new String[j];
            int i = 0;
            while (i < j) {
                int k = i + 1;
                types[i] = meta.getColumnType(k);
                fieldNames[i] = meta.getColumnLabel(k);
                quoteNames[i] = StringUtil.quoteIf(fieldNames[i]);
                if (!jsonFormat) {
                    indexList[i] = StringUtil.indexOf(fieldList, fieldNames[i]);
                }
                ++i;
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            st = connection.prepareStatement(StringUtil.concat("insert into ", tableName, "(", StringUtil.join(quoteNames, ','), ") values (?", StringUtil.repeat(",?", j - 1), ")"));
            while ((line = reader.readLine()) != null) {
                if (jsonFormat) {
                    JSONObject record = new JSONObject(line);
                    i = 0;
                    while (i < j) {
                        DbUtil.setObject(st, i + 1, types[i], JsonUtil.opt(record, fieldNames[i]));
                        ++i;
                    }
                } else {
                    String[] values = StringUtil.split(line, fieldSeparator);
                    i = 0;
                    while (i < j) {
                        String value;
                        String string = value = indexList[i] == -1 ? null : values[indexList[i]];
                        if (types[i] == 93) {
                            value = DateUtil.fix(value);
                        }
                        DbUtil.setObject(st, i + 1, types[i], value);
                        ++i;
                    }
                }
                DbUtil.addBatch(st);
            }
            DbUtil.executeBatch(st);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            reader.close();
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        reader.close();
    }

    public static void exportData(ResultSet rs, Writer writer) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        boolean newLine = false;
        int j = meta.getColumnCount();
        int[] types = new int[j];
        String[] names = new String[j];
        int i = 0;
        while (i < j) {
            types[i] = meta.getColumnType(i + 1);
            names[i] = meta.getColumnLabel(i + 1);
            ++i;
        }
        while (rs.next()) {
            if (newLine) {
                writer.write(10);
            } else {
                newLine = true;
            }
            writer.write(123);
            i = 0;
            while (i < j) {
                int k = i + 1;
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(StringUtil.quote(names[i]));
                writer.write(58);
                if (DbUtil.isBlobField(types[i])) {
                    InputStream stream = rs.getBinaryStream(k);
                    try {
                        writer.write(StringUtil.encode(stream));
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                } else {
                    writer.write(StringUtil.encode(DbUtil.getObject(rs, k, types[i])));
                }
                ++i;
            }
            writer.write(125);
        }
        writer.flush();
    }

    public static void addBatch(PreparedStatement statement) throws SQLException {
        if (Var.batchUpdate) {
            statement.addBatch();
        } else {
            statement.executeUpdate();
        }
    }

    public static int[] executeBatch(PreparedStatement statement) throws SQLException {
        if (Var.batchUpdate) {
            return statement.executeBatch();
        }
        return null;
    }

    public static Connection getConnection() throws Exception {
        return DbUtil.getConnection("");
    }

    public static Connection getConnection(HttpServletRequest request) throws Exception {
        return DbUtil.getConnection(request, null);
    }

    public static Connection getConnection(String jndi) throws Exception {
        if (StringUtil.isEmpty(jndi)) {
            jndi = Var.jndi;
        } else if (jndi.startsWith("sys.jndi.")) {
            jndi = Var.getString(jndi);
        }
        InitialContext context = new InitialContext();
        DataSource ds = (DataSource)context.lookup(jndi);
        return ds.getConnection();
    }

    public static Connection getConnection(HttpServletRequest request, String jndi) throws Exception {
        Connection conn;
        if (StringUtil.isEmpty(jndi)) {
            jndi = Var.jndi;
        } else if (jndi.startsWith("sys.jndi.")) {
            jndi = Var.getString(jndi);
        }
        String storeName = "conn@@" + jndi;
        Object obj = WebUtil.getObject(request, storeName);
        if (obj == null) {
            conn = DbUtil.getConnection(jndi);
            WebUtil.setObject(request, storeName, conn);
        } else {
            conn = (Connection)obj;
        }
        return conn;
    }

    public static void startTransaction(Connection connection, String isolation) throws Exception {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        connection.setAutoCommit(false);
        if (!StringUtil.isEmpty(isolation)) {
            if (isolation.equals("readUncommitted")) {
                connection.setTransactionIsolation(1);
            } else if (isolation.equals("readCommitted")) {
                connection.setTransactionIsolation(2);
            } else if (isolation.equals("repeatableRead")) {
                connection.setTransactionIsolation(4);
            } else if (isolation.equals("serializable")) {
                connection.setTransactionIsolation(8);
            }
        }
    }

    public static void close(Connection connection) {
        DbUtil.close(connection, true);
    }

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
            resultSet = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
            statement = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(Connection connection, boolean rollback) {
        block11: {
            if (connection == null) {
                return;
            }
            try {
                if (connection.isClosed()) {
                    return;
                }
                try {
                    try {
                        if (connection.getAutoCommit()) break block11;
                        if (rollback) {
                            connection.rollback();
                            break block11;
                        }
                        connection.commit();
                    }
                    catch (Throwable e) {
                        if (!rollback) {
                            connection.rollback();
                        }
                        connection.close();
                        connection = null;
                    }
                }
                finally {
                    connection.close();
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isBlobField(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTextField(int type) {
        switch (type) {
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringField(int type) {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean maybeFloatField(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void loadFirstRow(HttpServletRequest request, ResultSet resultSet, String prefix) throws Exception {
        if (!resultSet.next()) {
            return;
        }
        ResultSetMetaData meta = resultSet.getMetaData();
        int j = meta.getColumnCount();
        boolean hasPrefix = !StringUtil.isEmpty(prefix);
        int i = 1;
        while (i <= j) {
            Object object;
            String name = meta.getColumnLabel(i);
            if (hasPrefix) {
                name = StringUtil.concat(prefix, ".", name);
            }
            if ((object = DbUtil.getObject(resultSet, i, meta.getColumnType(i))) instanceof ResultSet || object instanceof InputStream) {
                WebUtil.setObject(request, SysUtil.getId(), object);
            }
            request.setAttribute(name, object);
            ++i;
        }
    }

    public static String getTypeCategory(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                return "int";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "string";
    }

    public static String getText(ResultSet rs, int index) throws Exception {
        return (String)DbUtil.getObject(rs, index, -1);
    }

    public static String getText(ResultSet rs, String fieldName) throws Exception {
        return (String)DbUtil.getObject(rs, fieldName, -1);
    }

    public static void setText(PreparedStatement statement, int index, String value) throws Exception {
        DbUtil.setObject(statement, index, -1, value);
    }

    public static Object getObject(CallableStatement statement, int index, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = statement.getString(index);
                break;
            }
            case 4: {
                obj = statement.getInt(index);
                break;
            }
            case -6: {
                obj = statement.getByte(index);
                break;
            }
            case 5: {
                obj = statement.getShort(index);
                break;
            }
            case -5: {
                obj = statement.getLong(index);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(statement.getFloat(index));
                break;
            }
            case 8: {
                obj = statement.getDouble(index);
                break;
            }
            case 2: 
            case 3: {
                obj = statement.getBigDecimal(index);
                break;
            }
            case 93: {
                obj = statement.getTimestamp(index);
                break;
            }
            case 91: {
                obj = statement.getDate(index);
                break;
            }
            case 92: {
                obj = statement.getTime(index);
                break;
            }
            case -7: 
            case 16: {
                obj = statement.getBoolean(index) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = statement.getCharacterStream(index);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString(rd);
                break;
            }
            default: {
                obj = statement.getObject(index);
            }
        }
        if (statement.wasNull()) {
            return null;
        }
        return obj;
    }

    public static Object getObject(ResultSet rs, int index, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = rs.getString(index);
                break;
            }
            case 4: {
                obj = rs.getInt(index);
                break;
            }
            case -6: {
                obj = rs.getByte(index);
                break;
            }
            case 5: {
                obj = rs.getShort(index);
                break;
            }
            case -5: {
                obj = rs.getLong(index);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(rs.getFloat(index));
                break;
            }
            case 8: {
                obj = rs.getDouble(index);
                break;
            }
            case 2: 
            case 3: {
                obj = rs.getBigDecimal(index);
                break;
            }
            case 93: {
                obj = rs.getTimestamp(index);
                break;
            }
            case 91: {
                obj = rs.getDate(index);
                break;
            }
            case 92: {
                obj = rs.getTime(index);
                break;
            }
            case -7: 
            case 16: {
                obj = rs.getBoolean(index) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = rs.getCharacterStream(index);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString(rd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream is = rs.getBinaryStream(index);
                if (is != null) {
                    is.close();
                }
                obj = "(blob)";
                break;
            }
            default: {
                obj = rs.getObject(index);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return obj;
    }

    public static Object getObject(ResultSet rs, String fieldName, int type) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = rs.getString(fieldName);
                break;
            }
            case 4: {
                obj = rs.getInt(fieldName);
                break;
            }
            case -6: {
                obj = rs.getByte(fieldName);
                break;
            }
            case 5: {
                obj = rs.getShort(fieldName);
                break;
            }
            case -5: {
                obj = rs.getLong(fieldName);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(rs.getFloat(fieldName));
                break;
            }
            case 8: {
                obj = rs.getDouble(fieldName);
                break;
            }
            case 2: 
            case 3: {
                obj = rs.getBigDecimal(fieldName);
                break;
            }
            case 93: {
                obj = rs.getTimestamp(fieldName);
                break;
            }
            case 91: {
                obj = rs.getDate(fieldName);
                break;
            }
            case 92: {
                obj = rs.getTime(fieldName);
                break;
            }
            case -7: 
            case 16: {
                obj = rs.getBoolean(fieldName) ? 1 : 0;
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = rs.getCharacterStream(fieldName);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString(rd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream is = rs.getBinaryStream(fieldName);
                if (is != null) {
                    is.close();
                }
                obj = "(blob)";
                break;
            }
            default: {
                obj = rs.getObject(fieldName);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return obj;
    }

    public static void setObject(PreparedStatement statement, int index, int type, Object object) throws Exception {
        if (object == null || object instanceof String) {
            String value = object == null ? null : (String)object;
            if (StringUtil.isEmpty(value)) {
                statement.setNull(index, type);
            } else {
                switch (type) {
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        statement.setString(index, value);
                        break;
                    }
                    case 4: {
                        statement.setInt(index, Integer.parseInt(value));
                        break;
                    }
                    case -6: {
                        statement.setByte(index, Byte.parseByte(value));
                        break;
                    }
                    case 5: {
                        statement.setShort(index, Short.parseShort(value));
                        break;
                    }
                    case -5: {
                        statement.setLong(index, Long.parseLong(value));
                        break;
                    }
                    case 6: 
                    case 7: {
                        statement.setFloat(index, Float.parseFloat(value));
                        break;
                    }
                    case 8: {
                        statement.setDouble(index, Double.parseDouble(value));
                        break;
                    }
                    case 2: 
                    case 3: {
                        statement.setBigDecimal(index, new BigDecimal(value));
                        break;
                    }
                    case 93: {
                        statement.setTimestamp(index, Timestamp.valueOf(value));
                        break;
                    }
                    case 91: {
                        if (value.indexOf(32) != -1) {
                            statement.setTimestamp(index, Timestamp.valueOf(value));
                            break;
                        }
                        statement.setDate(index, Date.valueOf(value));
                        break;
                    }
                    case 92: {
                        if (value.indexOf(32) != -1 || value.indexOf(45) != -1) {
                            statement.setTimestamp(index, Timestamp.valueOf(value));
                            break;
                        }
                        statement.setTime(index, Time.valueOf(value));
                        break;
                    }
                    case -7: 
                    case 16: {
                        statement.setBoolean(index, StringUtil.getBool(value));
                        break;
                    }
                    case -16: 
                    case -1: 
                    case 2005: 
                    case 2011: {
                        statement.setCharacterStream(index, (Reader)new StringReader(value), value.length());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.decodeBase64(value));
                        statement.setBinaryStream(index, (InputStream)is, ((InputStream)is).available());
                        break;
                    }
                    default: {
                        statement.setObject(index, (Object)value, type);
                        break;
                    }
                }
            }
        } else if (object instanceof InputStream) {
            statement.setBinaryStream(index, (InputStream)object, ((InputStream)object).available());
        } else if (object instanceof java.util.Date) {
            statement.setTimestamp(index, new Timestamp(((java.util.Date)object).getTime()));
        } else {
            statement.setObject(index, object, type);
        }
    }

    public static Object run(HttpServletRequest request, String sql, String jndi) throws Exception {
        Query query = new Query();
        query.request = request;
        query.sql = sql;
        query.jndi = jndi;
        return query.run();
    }

    public static Object run(HttpServletRequest request, String sql) throws Exception {
        return DbUtil.run(request, sql, null);
    }

    public static void update(HttpServletRequest request, String tableName, String mode) throws Exception {
        Updater updater = new Updater();
        updater.request = request;
        updater.tableName = tableName;
        updater.mode = mode;
        updater.run();
    }

    public static JSONArray getFields(ResultSetMetaData meta, String[] dictTableNames) throws Exception {
        int j = meta.getColumnCount();
        JSONArray ja = new JSONArray();
        boolean hasDict = dictTableNames != null;
        int i = 0;
        while (i < j) {
            String format;
            int k = i + 1;
            JSONObject jo = new JSONObject();
            String name = meta.getColumnLabel(k);
            if (StringUtil.isEmpty(name)) {
                name = "FIELD" + Integer.toString(k);
            }
            int type = meta.getColumnType(k);
            String category = DbUtil.getTypeCategory(type);
            switch (type) {
                case 93: {
                    format = "Y-m-d H:i:s.u";
                    break;
                }
                case 91: {
                    format = "Y-m-d";
                    break;
                }
                case 92: {
                    format = "H:i:s";
                    break;
                }
                default: {
                    format = null;
                }
            }
            jo.put("name", (Object)name);
            jo.put("type", (Object)category);
            if (format != null) {
                jo.put("dateFormat", (Object)format);
            }
            if (category.equals("string")) {
                jo.put("useNull", false);
            }
            ja.put((Object)jo);
            if (hasDict) {
                DictRecord dictRecord = Dictionary.find(dictTableNames, name);
                if (dictRecord.keyName != null) {
                    jo = new JSONObject();
                    jo.put("name", (Object)(String.valueOf(name) + "__V"));
                    jo.put("type", (Object)"string");
                    jo.put("useNull", false);
                    ja.put((Object)jo);
                }
            }
            ++i;
        }
        return ja;
    }

    public static String getColumns(ResultSetMetaData meta, String[] dictTableNames, String dictFieldsMap) throws Exception {
        int j = meta.getColumnCount();
        String[] mapTable = new String[1];
        String keyItems = null;
        StringBuilder buf = new StringBuilder();
        DictRecord fieldDict = null;
        JSONObject dictFieldsObj = null;
        if (!StringUtil.isEmpty(dictFieldsMap)) {
            dictFieldsObj = new JSONObject(dictFieldsMap);
        }
        buf.append('[');
        buf.append("{\"xtype\":\"rownumberer\"}");
        int i = 0;
        while (i < j) {
            String category;
            int index = i + 1;
            String fieldName = meta.getColumnLabel(index);
            if (StringUtil.isEmpty(fieldName)) {
                fieldName = "FIELD" + Integer.toString(index);
            }
            fieldDict = null;
            if (dictFieldsObj != null) {
                mapTable[0] = dictFieldsObj.optString(fieldName);
                if (!StringUtil.isEmpty(mapTable[0])) {
                    fieldDict = Dictionary.find(mapTable, fieldName);
                }
            }
            if (fieldDict == null && dictTableNames != null) {
                fieldDict = Dictionary.find(dictTableNames, fieldName);
            }
            boolean hasFieldDict = fieldDict != null;
            boolean hasKeyName = hasFieldDict && fieldDict.keyName != null;
            int len = hasKeyName ? 10 : meta.getPrecision(index);
            String precision = Integer.toString(len);
            String scale = Integer.toString(meta.getScale(index));
            int type = meta.getColumnType(index);
            int fieldNameLen = fieldName.length();
            fieldName = StringUtil.quote(fieldName);
            buf.append(',');
            buf.append("{\"dataIndex\":");
            buf.append(fieldName);
            buf.append(",\"text\":");
            buf.append(hasFieldDict && fieldDict.dispText != null ? StringUtil.quote(fieldDict.dispText) : fieldName);
            String editor = null;
            boolean isDateTime = false;
            boolean hasRenderer = hasFieldDict && (fieldDict.renderer != null || hasKeyName);
            switch (type) {
                case 93: {
                    category = "timestamp";
                    editor = "\"datetimefield\"";
                    isDateTime = true;
                    len = 18;
                    break;
                }
                case 91: {
                    category = "date";
                    editor = "\"datefield\"";
                    isDateTime = true;
                    len = 12;
                    break;
                }
                case 92: {
                    category = "time";
                    editor = "\"timefield\"";
                    isDateTime = true;
                    len = 10;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.timeRenderer");
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    if (hasFieldDict) {
                        String dictSize = fieldDict.fieldSize == -1 ? precision : Integer.toString(fieldDict.fieldSize);
                        String dictScale = fieldDict.decimalPrecision == -1 ? scale : Integer.toString(fieldDict.decimalPrecision);
                        editor = StringUtil.concat("\"numberfield\",\"decimalPrecision\":", dictScale);
                        if (fieldDict.validator != null) break;
                        editor = StringUtil.concat(editor, ",\"validator\":Wb.numValidator(", dictSize, ",", dictScale, ")");
                        break;
                    }
                    editor = StringUtil.concat("\"numberfield\",\"decimalPrecision\":", scale, ",\"validator\":Wb.numValidator(", precision, ",", scale, ")");
                    break;
                }
                case -16: 
                case -1: 
                case 2005: 
                case 2011: {
                    category = "text";
                    editor = "\"textarea\",\"height\":120";
                    len = 18;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    category = "blob";
                    editor = "\"filefield\"";
                    len = 17;
                    if (hasRenderer) break;
                    buf.append(",\"renderer\":Wb.blobRenderer");
                    break;
                }
                case -7: 
                case 16: {
                    category = "number";
                    if (!hasKeyName) {
                        buf.append(",\"align\":\"right\"");
                    }
                    editor = "\"numberfield\",\"maxValue\":1,\"minValue\":0";
                    break;
                }
                default: {
                    category = "string";
                    editor = "\"textfield\",\"maxLength\":" + (hasFieldDict && fieldDict.fieldSize != -1 ? Integer.toString(fieldDict.fieldSize) : precision);
                }
            }
            if (hasFieldDict) {
                if (isDateTime && fieldDict.fieldSize != -1) {
                    switch (fieldDict.fieldSize) {
                        case 1: {
                            editor = "\"datefield\"";
                            len = 12;
                            break;
                        }
                        case 2: {
                            editor = "\"timefield\"";
                            len = 10;
                            break;
                        }
                        case 3: {
                            category = "timestamp";
                            editor = "\"datetimefield\"";
                            len = 18;
                        }
                    }
                }
                if (!fieldDict.listable) {
                    buf.append(",\"hidden\":true,\"showInMenu\":false");
                }
                if (fieldDict.dispFormat != null) {
                    buf.append(",\"format\":");
                    buf.append(StringUtil.quote(fieldDict.dispFormat));
                }
                if (hasRenderer) {
                    if (fieldDict.renderer != null) {
                        buf.append(",\"renderer\":function(value,metaData,record,rowIndex,colIndex,store,view){");
                        buf.append(fieldDict.renderer);
                        buf.append('}');
                    } else {
                        buf.append(",\"renderer\":Wb.kvRenderer");
                    }
                }
                if (fieldDict.autoWrap) {
                    buf.append(",\"autoWrap\":true");
                }
            }
            buf.append(",\"category\":\"");
            buf.append(category);
            if (hasFieldDict && fieldDict.dispWidth != -1) {
                if (fieldDict.dispWidth < 10) {
                    buf.append("\",\"flex\":");
                    buf.append(fieldDict.dispWidth);
                } else {
                    buf.append("\",\"width\":");
                    buf.append(fieldDict.dispWidth);
                }
            } else {
                buf.append("\",\"width\":");
                len = Math.max(len, fieldNameLen + 3);
                if (len < 5) {
                    len = 5;
                }
                if (len > 18) {
                    len = 18;
                }
                buf.append(len * 10);
            }
            if (hasKeyName) {
                keyItems = KVBuffer.getList(fieldDict.keyName);
                buf.append(",\"keyName\":");
                buf.append(StringUtil.quote(fieldDict.keyName));
                buf.append(",\"keyItems\":");
                buf.append(keyItems);
            }
            if ((!hasFieldDict || fieldDict.editable) && editor != null) {
                if ("blob".equals(category)) {
                    buf.append(",\"blobEditor\":{\"xtype\":");
                } else {
                    buf.append(",\"editor\":{\"xtype\":");
                }
                if (hasKeyName) {
                    buf.append("\"combo\",displayField:'V',valueField:'K',\"forceSelection\":true,\"store\":{fields:[\"K\",\"V\"],sorters:\"K\",data:");
                    buf.append(keyItems);
                    buf.append('}');
                } else {
                    buf.append(editor);
                }
                if (hasFieldDict) {
                    if (fieldDict.allowBlank == null) {
                        if (meta.isNullable(index) == 0) {
                            buf.append(",\"allowBlank\":false,\"required\":true");
                        }
                    } else if (!fieldDict.allowBlank.booleanValue()) {
                        buf.append(",\"allowBlank\":false,\"required\":true");
                    }
                    if (fieldDict.readOnly == null) {
                        if (meta.isReadOnly(index)) {
                            buf.append(",\"readOnly\":true");
                        }
                    } else if (fieldDict.readOnly.booleanValue()) {
                        buf.append(",\"readOnly\":true");
                    }
                    if (fieldDict.validator != null) {
                        buf.append(",\"validator\":function(value){");
                        buf.append(fieldDict.validator);
                        buf.append('}');
                    }
                } else {
                    if (meta.isNullable(index) == 0) {
                        buf.append(",\"allowBlank\":false,\"required\":true");
                    }
                    if (meta.isReadOnly(index)) {
                        buf.append(",\"readOnly\":true");
                    }
                }
                buf.append("},editable:true");
            }
            buf.append(",\"metaType\":\"");
            buf.append(meta.getColumnTypeName(index));
            buf.append("\",\"metaRequired\":");
            buf.append(meta.isNullable(index) == 0 ? "true" : "false");
            buf.append(",\"metaSize\":");
            buf.append(precision);
            buf.append(",\"metaScale\":");
            buf.append(scale);
            buf.append('}');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static void outputBlob(ResultSet resultSet, HttpServletRequest request, HttpServletResponse response, String contentType) throws Exception {
        InputStream inputStream = null;
        try {
            ResultSetMetaData meta = resultSet.getMetaData();
            int rowCount = meta.getColumnCount();
            String name = meta.getColumnLabel(1);
            String size = null;
            if (StringUtil.isEmpty(name)) {
                name = "blob";
            }
            response.reset();
            if (resultSet.next()) {
                switch (rowCount) {
                    case 1: {
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 2: {
                        name = resultSet.getString(2);
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 3: {
                        name = resultSet.getString(2);
                        size = resultSet.getString(3);
                        inputStream = resultSet.getBinaryStream(1);
                    }
                }
            } else {
                throw new Exception("Empty ResultSet.");
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if ("download".equals(contentType)) {
                contentType = "application/force-download";
            } else if ("stream".equals(contentType)) {
                contentType = "application/octet-stream";
            } else if ("image".equals(contentType)) {
                if (inputStream == null) {
                    File nullGif = new File(Base.path, "wb/images/null.gif");
                    inputStream = new FileInputStream(nullGif);
                    size = Long.toString(nullGif.length());
                    contentType = "image/gif";
                } else {
                    String extName = FileUtil.getFileExt(name);
                    contentType = extName.isEmpty() ? "image/jpg" : "image/" + extName;
                }
            }
            response.setHeader("content-type", contentType);
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, name));
            if (size != null) {
                response.setHeader("content-length", size);
            }
            if (inputStream != null) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            response.flushBuffer();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public static String getString(String sql, String param) {
        byte[] bytes;
        block3: {
            try {
                bytes = DbUtil.getBytes(sql, param);
                if (bytes != null) break block3;
                return null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return new String(bytes, "utf-8");
    }

    public static byte[] getBytes(String sql, String param) {
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block7: {
            byte[] byArray;
            conn = null;
            st = null;
            rs = null;
            try {
                conn = DbUtil.getConnection();
                st = conn.prepareStatement(sql);
                st.setString(1, param);
                rs = st.executeQuery();
                if (!rs.next()) break block7;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                if (is == null) break block7;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    is.close();
                }
                byArray = os.toByteArray();
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(st);
                    DbUtil.close(conn);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            return byArray;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return null;
    }

    public static String[] buildSQLs(String jndi, String tableName, boolean ignoreBlob, int scriptType, HttpServletRequest request, JSONObject fields, JSONObject whereFields, JSONObject fieldsMap) throws Exception {
        String[] sqls = new String[4];
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        StringBuilder selectFields = new StringBuilder();
        StringBuilder insertFields = new StringBuilder();
        StringBuilder insertParams = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        StringBuilder updateParams = new StringBuilder();
        boolean isFirstSelect = true;
        boolean isFirstUpdate = true;
        boolean isFirstCondi = true;
        boolean hasRequest = request != null;
        try {
            conn = request == null ? DbUtil.getConnection(jndi) : DbUtil.getConnection(request, jndi);
            st = conn.prepareStatement("select * from " + tableName + " where 1=0");
            rs = st.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount() + 1;
            int i = 1;
            while (i < j) {
                String mapName;
                String fieldName;
                int type = meta.getColumnType(i);
                String typeName = DbUtil.getTypeName(type);
                boolean isText = DbUtil.isTextField(type);
                boolean isBlob = DbUtil.isBlobField(type);
                boolean isFloat = DbUtil.maybeFloatField(type) && meta.getScale(i) > 0;
                boolean required = meta.isNullable(i) == 0;
                boolean readOnly = meta.isReadOnly(i);
                String fieldValueName = fieldName = meta.getColumnLabel(i);
                fieldName = StringUtil.quoteIf(fieldName);
                if (fieldsMap != null && (mapName = fieldsMap.optString(fieldValueName, null)) != null) {
                    fieldValueName = mapName;
                }
                if (!isBlob || !hasRequest || !StringUtil.isEmpty(WebUtil.fetch(request, fieldValueName)) || "1".equals(WebUtil.fetch(request, "$" + fieldValueName))) {
                    if (fields == null && (!ignoreBlob || !isBlob) || fields != null && (fields.has(fieldValueName) || fields.has("$" + fieldValueName))) {
                        if (isFirstSelect) {
                            isFirstSelect = false;
                        } else {
                            selectFields.append(',');
                        }
                        selectFields.append(fieldName);
                        if (!readOnly) {
                            String param;
                            if (isFirstUpdate) {
                                isFirstUpdate = false;
                            } else {
                                insertFields.append(',');
                                insertParams.append(',');
                                updateParams.append(',');
                            }
                            switch (scriptType) {
                                case 1: {
                                    param = StringUtil.concat("{?", typeName, ".", fieldValueName, "?}");
                                    break;
                                }
                                case 2: {
                                    param = StringUtil.concat("{#", fieldValueName, "#}");
                                    break;
                                }
                                default: {
                                    param = fieldValueName;
                                }
                            }
                            insertFields.append(fieldName);
                            insertParams.append(param);
                            updateParams.append(fieldName);
                            updateParams.append('=');
                            updateParams.append(param);
                        }
                    }
                    if (!(isText || isBlob || isFloat || whereFields != null && !whereFields.has(fieldValueName))) {
                        if (isFirstCondi) {
                            isFirstCondi = false;
                        } else {
                            condition.append(" and ");
                        }
                        condition.append(DbUtil.getCondition(fieldName, fieldValueName, DbUtil.isStringField(type), typeName, required, scriptType));
                    }
                }
                ++i;
            }
            sqls[0] = StringUtil.concat("insert into ", tableName, " (", insertFields.toString(), ") values (", insertParams.toString(), ")");
            sqls[1] = StringUtil.concat("update ", tableName, " set ", updateParams.toString(), " where ", condition.toString());
            sqls[2] = StringUtil.concat("delete from ", tableName, " where ", condition.toString());
            sqls[3] = StringUtil.concat("select ", selectFields.toString(), " from ", tableName, " where ", condition.toString());
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            if (request == null) {
                DbUtil.close(conn);
            }
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        if (request == null) {
            DbUtil.close(conn);
        }
        return sqls;
    }

    private static String getCondition(String fieldName, String fieldValueName, boolean isStringField, String typeName, boolean required, int scriptType) {
        StringBuilder buf = new StringBuilder();
        switch (scriptType) {
            case 1: {
                if (isStringField) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and (");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                    buf.append(fieldName);
                    buf.append("='') or ");
                    buf.append(fieldName);
                    buf.append("={?");
                    buf.append(typeName);
                    buf.append(".#");
                    buf.append(fieldValueName);
                    buf.append("?})");
                    break;
                }
                if (!required) {
                    buf.append("({?#");
                    buf.append(fieldValueName);
                    buf.append("?} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("={?");
                buf.append(typeName);
                buf.append(".#");
                buf.append(fieldValueName);
                if (required) {
                    buf.append("?}");
                    break;
                }
                buf.append("?})");
                break;
            }
            case 2: {
                if (!required) {
                    buf.append("({##");
                    buf.append(fieldValueName);
                    buf.append("#} is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("={##");
                buf.append(fieldValueName);
                if (required) {
                    buf.append("#}");
                    break;
                }
                buf.append("#})");
                break;
            }
            default: {
                if (!required) {
                    buf.append("(#");
                    buf.append(fieldValueName);
                    buf.append(" is null and ");
                    buf.append(fieldName);
                    buf.append(" is null or ");
                }
                buf.append(fieldName);
                buf.append("=#");
                buf.append(fieldValueName);
                if (required) break;
                buf.append(')');
            }
        }
        return buf.toString();
    }
}

