/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Base;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileUtil {
    public static File getUniqueFile(File file) {
        if (file.exists()) {
            File parent = file.getParentFile();
            String fullName = file.getName();
            String namePart = FileUtil.removeExtension(fullName);
            String extPart = FileUtil.getFileExt(fullName);
            boolean emptyExt = extPart.isEmpty();
            int i = 1;
            if (!emptyExt) {
                extPart = String.valueOf('.') + extPart;
            }
            do {
                file = emptyExt ? new File(parent, StringUtil.concat(namePart, Integer.toString(i))) : new File(parent, StringUtil.concat(namePart, Integer.toString(i), extPart));
                ++i;
            } while (file.exists());
        }
        return file;
    }

    public static String readString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"utf-8");
    }

    public static void writeString(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content, (String)"utf-8");
    }

    public static void saveStream(InputStream inputStream, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public static String getFileExt(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(i + 1);
        }
        return "";
    }

    public static String getFileType(File file) {
        String type;
        try {
            type = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
        }
        catch (Throwable e) {
            type = null;
        }
        if (StringUtil.isEmpty(type)) {
            return FileUtil.getFileExt(file.getName());
        }
        return type;
    }

    public static String getFilename(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        int p = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static String removeExtension(String fileName) {
        String s = FileUtil.getFilename(fileName);
        int i = s.lastIndexOf(46);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    public static String getPath(String path) {
        return StringUtil.replaceAll(path, "\\", "/");
    }

    public static String getPath(File file) {
        return FileUtil.getPath(file.getAbsolutePath());
    }

    public static String getRelativePath(File parent, File child) {
        String parentPath;
        if (parent == null) {
            throw new NullPointerException("Parent file is null.");
        }
        if (child == null) {
            throw new NullPointerException("Child file is null.");
        }
        String originChildPath = child.getAbsolutePath();
        String childPath = String.valueOf(originChildPath) + File.separatorChar;
        if (childPath.equals(parentPath = String.valueOf(parent.getAbsolutePath()) + File.separatorChar)) {
            return "";
        }
        if (childPath.startsWith(parentPath)) {
            return FileUtil.getPath(originChildPath.substring(parentPath.length()));
        }
        return null;
    }

    public static boolean isAncestor(File parent, File child) throws IOException {
        return FileUtil.isAncestor(parent, child, true);
    }

    public static boolean isAncestor(File parent, File child, boolean includeSelf) throws IOException {
        String parentPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        if (!parentPath.endsWith(String.valueOf(File.separatorChar))) {
            parentPath = String.valueOf(parentPath) + File.separatorChar;
        }
        if (!childPath.endsWith(String.valueOf(File.separatorChar))) {
            childPath = String.valueOf(childPath) + File.separatorChar;
        }
        return childPath.startsWith(parentPath) && (includeSelf || childPath.length() > parentPath.length());
    }

    public static boolean isEmpty(File folder) {
        String[] fs;
        return folder == null || (fs = folder.list()) == null || fs.length == 0;
    }

    public static File[] listFiles(File file) {
        if (!file.exists()) {
            throw new RuntimeException("\"" + file.getName() + "\" does not exist.");
        }
        File[] fs = file.listFiles();
        if (fs == null) {
            return new File[0];
        }
        return fs;
    }

    public static Object[] syncCopy(File src, File dst) throws IOException {
        String name = src.getName();
        dst = new File(dst, name);
        File syncDst = FileUtil.getSyncPath(dst);
        boolean isDir = src.isDirectory();
        boolean sameParent = src.getParentFile().equals(dst.getParentFile());
        if (sameParent) {
            dst = FileUtil.getUniqueFile(dst);
        }
        boolean dstExists = dst.exists();
        if (isDir) {
            FileUtils.copyDirectory((File)src, (File)dst);
        } else {
            FileUtils.copyFile((File)src, (File)dst);
        }
        if (syncDst != null) {
            if (sameParent) {
                syncDst = FileUtil.getUniqueFile(syncDst);
            }
            if (isDir) {
                FileUtils.copyDirectory((File)src, (File)syncDst);
            } else {
                FileUtils.copyFile((File)src, (File)syncDst);
            }
        }
        Object[] result = new Object[]{FileUtil.getPath(dst), dstExists};
        return result;
    }

    public static void syncCopyA(File src, File dst) throws IOException {
        boolean isDir = src.isDirectory();
        if (isDir) {
            FileUtils.copyDirectory((File)src, (File)dst);
        } else {
            FileUtils.copyFile((File)src, (File)dst);
        }
        File syncPath = FileUtil.getSyncPath(dst);
        if (syncPath != null) {
            if (isDir) {
                FileUtils.copyDirectory((File)src, (File)syncPath);
            } else {
                FileUtils.copyFile((File)src, (File)syncPath);
            }
        }
    }

    public static void syncCreate(File file, boolean isDir) throws IOException {
        String name = file.getName();
        File syncPath = FileUtil.getSyncPath(file);
        if (file.exists()) {
            throw new IllegalArgumentException("\"" + name + "\" already exists.");
        }
        if (syncPath != null && syncPath.exists()) {
            throw new IllegalArgumentException("\"" + syncPath.getAbsolutePath() + "\" already exists.");
        }
        if (isDir) {
            if (!file.mkdir()) {
                throw new IOException("Create \"" + name + "\" failure.");
            }
            if (syncPath != null && !syncPath.mkdir()) {
                throw new IOException("Create \"" + syncPath.getAbsolutePath() + "\" failure.");
            }
        } else {
            if (!file.createNewFile()) {
                throw new IOException("Create \"" + name + "\" failure.");
            }
            if (syncPath != null && !syncPath.createNewFile()) {
                throw new IOException("Create \"" + syncPath.getAbsolutePath() + "\" failure.");
            }
        }
        if (syncPath != null) {
            syncPath.setLastModified(file.lastModified());
        }
    }

    public static void syncDelete(File file, boolean clearUrl) throws Exception {
        if (!FileUtils.deleteQuietly((File)file)) {
            throw new IOException("Cannot delete \"" + file.getName() + "\".");
        }
        File syncPath = FileUtil.getSyncPath(file);
        if (syncPath != null && !FileUtils.deleteQuietly((File)syncPath)) {
            throw new IOException("Cannot delete \"" + syncPath.toString() + "\".");
        }
        FileUtil.clearFiles(file, clearUrl);
    }

    public static void syncMove(File src, File dst) throws Exception {
        File syncDst = FileUtil.getSyncPath(dst);
        FileUtils.moveToDirectory((File)src, (File)dst, (boolean)true);
        if (syncDst != null) {
            try {
                File syncSrc = FileUtil.getSyncPath(src);
                if (syncSrc == null) {
                    if (syncDst.isDirectory()) {
                        FileUtils.copyDirectory((File)dst, (File)syncDst);
                    } else {
                        FileUtils.copyFile((File)dst, (File)syncDst);
                    }
                } else {
                    FileUtils.moveToDirectory((File)syncSrc, (File)syncDst, (boolean)true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        FileUtil.clearFiles(src, false);
    }

    public static void syncRename(File file, File newFile) throws IOException {
        File syncPath = FileUtil.getSyncPath(file);
        if (!file.renameTo(newFile)) {
            throw new IOException("Cannot rename \"" + file.getName() + "\".");
        }
        if (syncPath != null && !syncPath.renameTo(FileUtil.getSyncPath(newFile))) {
            throw new IOException("Cannot rename \"" + syncPath.toString() + "\".");
        }
    }

    public static void syncSave(File file, byte[] content) throws Exception {
        FileUtils.writeByteArrayToFile((File)file, (byte[])content);
        File syncPath = FileUtil.getSyncPath(file);
        if (syncPath != null) {
            FileUtils.copyFile((File)file, (File)syncPath);
        }
    }

    public static void syncSave(File file, String content) throws Exception {
        FileUtil.syncSave(file, content, "utf-8", false);
    }

    public static void syncSave(File file, String content, String charset) throws Exception {
        FileUtil.syncSave(file, content, charset, false);
    }

    public static void syncSave(File file, String content, String charset, boolean keepLastModified) throws Exception {
        String relPath;
        File syncPath;
        long lastModified;
        long l = lastModified = keepLastModified ? file.lastModified() : 0L;
        if (StringUtil.isEmpty(charset)) {
            FileUtils.writeStringToFile((File)file, (String)content);
        } else {
            FileUtils.writeStringToFile((File)file, (String)content, (String)charset);
        }
        if (keepLastModified) {
            file.setLastModified(lastModified);
        }
        if ((syncPath = FileUtil.getSyncPath(file)) != null) {
            FileUtils.copyFile((File)file, (File)syncPath);
            if (keepLastModified) {
                syncPath.setLastModified(lastModified);
            }
        }
        if ((relPath = FileUtil.getModulePath(file)) != null) {
            XwlBuffer.clear(relPath);
        }
    }

    public static File getSyncPath(File path) throws IOException {
        if (!Var.syncPath.isEmpty() && FileUtil.isAncestor(Base.path, path)) {
            File base = new File(Var.syncPath);
            return new File(base, FileUtil.getPath(path).substring(Base.pathLen));
        }
        return null;
    }

    private static void clearFiles(File file, boolean clearUrl) throws Exception {
        String relPath;
        JSONObject object;
        JSONArray index;
        File folder = file.getParentFile();
        File configFile = new File(folder, "folder.json");
        if (configFile.exists() && (index = (object = JsonUtil.readObject(configFile)).optJSONArray("index")) != null) {
            int j = index.length();
            int i = j - 1;
            while (i >= 0) {
                File indexFile = new File(folder, index.getString(i));
                if (!indexFile.exists()) {
                    index.remove(i);
                }
                --i;
            }
            FileUtil.syncSave(configFile, object.toString());
        }
        if ((relPath = FileUtil.getModulePath(file)) != null) {
            XwlBuffer.clear(relPath);
            if (clearUrl && UrlBuffer.remove(relPath)) {
                UrlBuffer.save();
            }
        }
    }

    public static String getModulePath(File file) {
        String path = FileUtil.getPath(file);
        if (path.startsWith(Base.modulePathText)) {
            return path.substring(Base.modulePathLen);
        }
        return null;
    }

    public static String getModuleFile(String url) {
        return FileUtil.getModuleFile(url, false);
    }

    public static String getModuleFile(String url, boolean silent) {
        if (url == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("The requested url is not specified.");
        }
        if (url.startsWith("m?xwl=")) {
            return String.valueOf(url.substring(6)) + ".xwl";
        }
        if (url.endsWith(".xwl")) {
            return url;
        }
        String shortcut = url;
        if ((url = UrlBuffer.get("/" + shortcut)) == null) {
            if (silent) {
                return null;
            }
            throw new NullPointerException("The requested url shortcut \"" + shortcut + "\" is not found.");
        }
        return url;
    }
}

