/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Var;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;

public class LogUtil {
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;

    private static void record(String userName, String ip, int type, String msg) {
        block9: {
            long milliSec = System.currentTimeMillis();
            Connection conn = null;
            PreparedStatement st = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    st = conn.prepareStatement("insert into WB_LOG values(?,?,?,?,?)");
                    if (StringUtil.isEmpty(ip)) {
                        ip = "-";
                    }
                    if (StringUtil.isEmpty(userName)) {
                        userName = "-";
                    }
                    if (StringUtil.isEmpty(msg)) {
                        msg = "-";
                    }
                    st.setTimestamp(1, new Timestamp(milliSec));
                    st.setString(2, userName);
                    st.setString(3, ip);
                    st.setInt(4, type);
                    int len = Math.min(msg.length(), 256);
                    while (msg.getBytes().length > 255) {
                        msg = msg.substring(0, --len);
                    }
                    st.setString(5, msg);
                    st.executeUpdate();
                }
                catch (Throwable throwable) {
                    DbUtil.close(st);
                    DbUtil.close(conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(st);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(st);
            DbUtil.close(conn);
        }
    }

    private static void recordMsg(int type, String msg) {
        if (Var.log) {
            LogUtil.record(null, null, type, msg);
        }
    }

    private static void recordUserMsg(HttpServletRequest request, int type, String msg) {
        if (Var.log) {
            LogUtil.record(WebUtil.fetch(request, "sys.username"), request.getRemoteAddr(), type, msg);
        }
    }

    public static void log(String userName, String ip, int type, String msg) {
        if (Var.log) {
            LogUtil.record(userName, ip, type, msg);
        }
    }

    public static void info(HttpServletRequest request, String msg) {
        LogUtil.recordUserMsg(request, 1, msg);
    }

    public static void info(String msg) {
        LogUtil.recordMsg(1, msg);
    }

    public static void warn(HttpServletRequest request, String s) {
        LogUtil.recordUserMsg(request, 2, s);
    }

    public static void warn(String s) {
        LogUtil.recordMsg(2, s);
    }

    public static void error(HttpServletRequest request, String s) {
        LogUtil.recordUserMsg(request, 3, s);
    }

    public static void error(String s) {
        LogUtil.recordMsg(3, s);
    }
}

