/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Parser;
import com.wb.common.Str;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.tool.Console;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebUtil {
    public static String submit(String url, JSONObject params) throws IOException {
        return WebUtil.submit(url, "POST", params);
    }

    public static String submit(String url, String method, JSONObject params) throws IOException {
        return new String(WebUtil.submitBytes(url, method, params), "utf-8");
    }

    public static byte[] submitBytes(String url, JSONObject params) throws IOException {
        return WebUtil.submitBytes(url, "POST", params);
    }

    public static byte[] submitBytes(String url, String method, JSONObject params) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            byte[] data = WebUtil.getParamsText(params).getBytes("utf-8");
            int timeout = Var.getInt("sys.session.submitTimeout");
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(data.length));
            OutputStream os = conn.getOutputStream();
            try {
                os.write(data);
                os.flush();
            }
            finally {
                os.close();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = conn.getInputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
            }
            finally {
                is.close();
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String getParamsText(JSONObject jo) throws IOException {
        if (jo == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Set es = jo.entrySet();
        boolean isFirst = true;
        for (Map.Entry e : es) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append((String)e.getKey());
            sb.append("=");
            sb.append(URLEncoder.encode(e.getValue().toString(), "utf-8"));
        }
        return sb.toString();
    }

    public static String[] getSortInfo(HttpServletRequest request) {
        String sort = request.getParameter("sort");
        if (StringUtil.isEmpty(sort)) {
            return null;
        }
        JSONObject jo = new JSONArray(sort).getJSONObject(0);
        String[] result = new String[]{jo.getString("property"), jo.optString("direction")};
        return result;
    }

    public static String encodeFilename(HttpServletRequest request, String filename) throws IOException {
        String agent = StringUtil.opt(request.getHeader("user-agent")).toLowerCase();
        if (agent.indexOf("opera") != -1) {
            return StringUtil.concat("filename*=\"utf-8''", WebUtil.encode(filename), "\"");
        }
        if (agent.indexOf("trident") != -1 || agent.indexOf("msie") != -1) {
            return StringUtil.concat("filename=\"", WebUtil.encode(filename), "\"");
        }
        return StringUtil.concat("filename=\"", new String(filename.getBytes("utf-8"), "ISO-8859-1"), "\"");
    }

    public static String encode(String string) throws IOException {
        return StringUtil.replaceAll(URLEncoder.encode(string, "utf-8"), "+", "%20");
    }

    public static String decode(String string) throws IOException {
        if (Var.urlEncoding.isEmpty() || StringUtil.isEmpty(string)) {
            return string;
        }
        return new String(string.getBytes(Var.urlEncoding), "utf-8");
    }

    public static void clearUpload(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (!item.isFormField()) {
                IOUtils.closeQuietly((InputStream)((InputStream)request.getAttribute(item.getFieldName())));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static String getIdWithUser(HttpServletRequest request, String id) {
        String user = WebUtil.fetch(request, "sys.user");
        return StringUtil.concat(id, "@", StringUtil.opt(user));
    }

    public static void setSessionValue(HttpServletRequest request, String name, Object value) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("Session does not exist.");
        }
        session.setAttribute(name, value);
    }

    public static Object fetchObject(HttpServletRequest request, String name) {
        Object value;
        HttpSession session = request.getSession(false);
        if (session == null || (value = session.getAttribute(name)) == null) {
            value = request.getAttribute(name);
            if (value == null) {
                return request.getParameter(name);
            }
            return value;
        }
        return value;
    }

    public static String fetch(HttpServletRequest request, String name) {
        Object object = WebUtil.fetchObject(request, name);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static JSONObject fetch(HttpServletRequest request) {
        String name;
        JSONObject json = new JSONObject();
        Iterator requestParams = request.getParameterMap().entrySet().iterator();
        Enumeration requestAttrs = request.getAttributeNames();
        while (requestParams.hasNext()) {
            Map.Entry entry = requestParams.next();
            json.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
        }
        while (requestAttrs.hasMoreElements()) {
            name = requestAttrs.nextElement().toString();
            json.put(name, request.getAttribute(name));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            Enumeration sessionAttrs = session.getAttributeNames();
            while (sessionAttrs.hasMoreElements()) {
                name = sessionAttrs.nextElement().toString();
                json.put(name, session.getAttribute(name));
            }
        }
        return json;
    }

    public static String replaceParams(HttpServletRequest request, String text) {
        if (request == null) {
            return text;
        }
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder(text.length());
            while (startPos != -1 && endPos != -1) {
                String paramName = text.substring(startPos + 2, endPos);
                String paramValue = paramName.startsWith("Var.") ? Var.getString(paramName.substring(4)) : (paramName.startsWith("Str.") ? Str.format(request, paramName.substring(4), new Object[0]) : WebUtil.fetch(request, paramName));
                buf.append(text.substring(start, startPos));
                if (paramValue != null) {
                    buf.append(paramValue);
                }
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static void send(HttpServletResponse response, Object object) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        ServletOutputStream outputStream = response.getOutputStream();
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                if (Var.sendStreamGzip) {
                    response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)gos);
                    }
                    finally {
                        gos.close();
                    }
                }
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                inputStream.close();
            }
        } else {
            byte[] bytes;
            if (object instanceof byte[]) {
                bytes = (byte[])object;
            } else {
                String text = object == null ? "" : object.toString();
                bytes = text.getBytes("utf-8");
                if (StringUtil.isEmpty(response.getContentType())) {
                    response.setContentType("text/html;charset=utf-8");
                }
            }
            int len = bytes.length;
            if (len >= Var.sendGzipMinSize && Var.sendGzipMinSize != -1) {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gos = new GZIPOutputStream((OutputStream)outputStream);
                try {
                    gos.write(bytes);
                }
                finally {
                    gos.close();
                }
            } else {
                response.setContentLength(len);
                outputStream.write(bytes);
            }
        }
        response.flushBuffer();
    }

    public static void send(HttpServletResponse response, String text, boolean successful) throws IOException {
        WebUtil.send(response, StringUtil.textareaQuote(StringUtil.concat("{success:", Boolean.toString(successful), ",value:", StringUtil.quote(text), "}")));
    }

    public static boolean fromAjax(HttpServletRequest request) {
        try {
            return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void showException(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean isAjax = WebUtil.fromAjax(request);
        boolean jsonResp = WebUtil.jsonResponse(request);
        boolean directOutput = isAjax || jsonResp;
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter((Writer)writer, true);
        exception.printStackTrace(pwriter);
        pwriter.close();
        String errorMessage = writer.toString();
        Console.error(request, errorMessage);
        if (Var.printError && !directOutput) {
            Throwable rootExcept = SysUtil.getRootExcept(exception);
            if (rootExcept instanceof ServletException) {
                throw (ServletException)rootExcept;
            }
            throw new ServletException(rootExcept);
        }
        try {
            if (Var.printError) {
                System.err.println(errorMessage);
            }
            if (!response.isCommitted()) {
                String rootError = SysUtil.getRootError(exception);
                response.reset();
                if (directOutput) {
                    if (jsonResp) {
                        WebUtil.send(response, rootError, false);
                    } else {
                        response.setStatus(500);
                        WebUtil.send(response, rootError);
                    }
                } else {
                    response.sendError(500, rootError);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("sys.logined") == null) {
            boolean directOutput;
            boolean isAjax = WebUtil.fromAjax(request);
            boolean jsonResp = WebUtil.jsonResponse(request);
            boolean bl = directOutput = isAjax || jsonResp;
            if (directOutput) {
                if (jsonResp) {
                    if (Var.getBool("sys.session.verifyImage.enabled")) {
                        WebUtil.send(response, "$WBE202: Login required with verify", false);
                    } else {
                        WebUtil.send(response, "$WBE201: Login required", false);
                    }
                } else {
                    response.setStatus(401);
                    if (Var.getBool("sys.session.verifyImage.enabled")) {
                        WebUtil.send(response, "Login required with verify");
                    } else {
                        WebUtil.send(response, "Login required");
                    }
                }
            } else {
                Parser parser = new Parser(request, response);
                if (WebUtil.isTouchModule(request)) {
                    parser.parse("sys/session/tlogin.xwl");
                } else {
                    parser.parse("sys/session/login.xwl");
                }
            }
            return false;
        }
        return true;
    }

    private static boolean isTouchModule(HttpServletRequest request) throws IOException {
        JSONObject module;
        String xwl = UrlBuffer.get(request.getServletPath());
        if (xwl.isEmpty()) {
            xwl = request.getParameter("xwl");
            if (StringUtil.isEmpty(xwl)) {
                return false;
            }
            xwl = StringUtil.concat(xwl, ".xwl");
        }
        if ((module = XwlBuffer.get(xwl, true)) == null) {
            return false;
        }
        return module.has("hasTouch");
    }

    public static boolean hasRole(HttpServletRequest request, String roleName) {
        String[] roles = (String[])WebUtil.fetchObject(request, "sys.roles");
        return StringUtil.indexOf(roles, roleName) != -1;
    }

    public static List<FileItem> setUploadFile(HttpServletRequest request) throws Exception {
        List list;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        final String uploadId = request.getParameter("uploadId");
        int maxKbSize = Var.getInt("sys.service.upload.maxSize");
        HashMap<String, Integer> multiFilesMap = null;
        if (maxKbSize != -1) {
            upload.setSizeMax((long)(1024 * maxKbSize));
        }
        factory.setSizeThreshold(Var.getInt("sys.service.upload.bufferSize"));
        if (uploadId != null && uploadId.indexOf(46) == -1) {
            request.setAttribute("sys.uploadId", (Object)uploadId);
            final HttpSession session = request.getSession(true);
            if (session != null) {
                upload.setProgressListener(new ProgressListener(){

                    public void update(long read, long length, int id) {
                        session.setAttribute("sys.upread." + uploadId, (Object)read);
                        session.setAttribute("sys.uplen." + uploadId, (Object)length);
                    }
                });
            }
        }
        if ((list = upload.parseRequest(request)) == null || list.size() == 0) {
            return null;
        }
        try {
            for (FileItem item : list) {
                String fieldName = item.getFieldName();
                if (fieldName.indexOf(46) != -1) continue;
                if (request.getAttribute(fieldName) != null) {
                    throw new RuntimeException("Duplicate parameters \"" + fieldName + "\" found.");
                }
                if (item.isFormField()) {
                    request.setAttribute(fieldName, (Object)item.getString("utf-8"));
                    continue;
                }
                String fileName = FileUtil.getFilename(item.getName());
                long fileSize = item.getSize();
                if (fieldName.endsWith("[]")) {
                    Integer fileIndex;
                    fieldName = fieldName.substring(0, fieldName.length() - 2);
                    if (multiFilesMap == null) {
                        multiFilesMap = new HashMap<String, Integer>();
                    }
                    if ((fileIndex = (Integer)multiFilesMap.get(fieldName)) == null) {
                        fileIndex = 0;
                    }
                    fileIndex = fileIndex + 1;
                    multiFilesMap.put(fieldName, fileIndex);
                    String fileIndexText = "@" + Integer.toString(fileIndex);
                    if (StringUtil.isEmpty(fileName) && fileSize == 0L) {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)"");
                    } else {
                        request.setAttribute(String.valueOf(fieldName) + fileIndexText, (Object)item.getInputStream());
                    }
                    request.setAttribute(StringUtil.concat(fieldName, fileIndexText, "__name"), (Object)fileName);
                    request.setAttribute(StringUtil.concat(fieldName, fileIndexText, "__size"), (Object)fileSize);
                    continue;
                }
                if (StringUtil.isEmpty(fileName) && fileSize == 0L) {
                    request.setAttribute(fieldName, (Object)"");
                } else {
                    request.setAttribute(fieldName, (Object)item.getInputStream());
                }
                request.setAttribute(String.valueOf(fieldName) + "__name", (Object)fileName);
                request.setAttribute(String.valueOf(fieldName) + "__size", (Object)fileSize);
            }
        }
        catch (Throwable e) {
            WebUtil.clearUploadFile(request, list);
            throw new Exception(e);
        }
        return list;
    }

    public static boolean hasFile(HttpServletRequest request, String name) {
        return request.getAttribute(name) instanceof InputStream;
    }

    public static void clearUploadFile(HttpServletRequest request, List<FileItem> list) {
        for (FileItem item : list) {
            if (item.isFormField() || item.isInMemory()) continue;
            Object object = request.getAttribute(item.getFieldName());
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static void setLanguage(HttpServletRequest request) {
        String sessionLan;
        HttpSession session = request.getSession(false);
        String setLan = Var.language;
        if (session != null && (sessionLan = (String)session.getAttribute("sys.lang")) != null) {
            setLan = sessionLan;
        }
        if (setLan.equals("auto")) {
            setLan = Var.defaultLanguage;
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang != null) {
                String language;
                String mappedLang;
                int pos = acceptLang.indexOf(44);
                if (pos != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                if ((pos = acceptLang.indexOf(59)) != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                setLan = (pos = acceptLang.indexOf(45)) == -1 ? acceptLang.toLowerCase() : ((mappedLang = Str.getMappedLang(language = StringUtil.concat(acceptLang.substring(0, pos).toLowerCase(), "_", acceptLang.substring(pos + 1).toUpperCase()))) == null ? language : mappedLang);
            }
        }
        request.setAttribute("sys.useLang", (Object)setLan);
    }

    public static boolean jsonResponse(HttpServletRequest request) {
        return WebUtil.exists(request, "_jsonresp");
    }

    public static boolean exists(HttpServletRequest request, String name) {
        Object value = name.startsWith("sys.") ? request.getAttribute(name) : WebUtil.fetch(request, name);
        if (value == null) {
            return false;
        }
        return "1".equals(value.toString());
    }

    public static Object getObject(HttpServletRequest request, String name) {
        Object object = request.getAttribute("sys.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            return map.get(name);
        }
        return null;
    }

    public static void include(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude(request, response, path, false);
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response, String path) throws Exception {
        WebUtil.doInclude(request, response, path, true);
    }

    private static void doInclude(HttpServletRequest request, HttpServletResponse response, String path, boolean isForward) throws Exception {
        String xwl = path.endsWith(".xwl") ? path : UrlBuffer.get("/" + path);
        if (xwl == null) {
            if (isForward) {
                request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.getRequestDispatcher(path).include((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            if (isForward) {
                response.resetBuffer();
            }
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    response.sendError(400, "null xwl");
                    return;
                }
                xwl = StringUtil.concat(xwl, ".xwl");
            }
            Parser parser = new Parser(request, response);
            parser.parse(xwl);
        }
    }

    public static void setObject(HttpServletRequest request, String name, Object value) {
        Object object = request.getAttribute("sys.varMap");
        if (object != null) {
            ConcurrentHashMap map = JSONObject.toConHashMap((Object)object);
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("Key \"" + name + "\" already exists.");
            }
            map.put(name, value);
        }
    }
}

