/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.syspatch.zip.ZipEntry;
import com.syspatch.zip.ZipInputStream;
import com.syspatch.zip.ZipOutputStream;
import com.wb.common.Var;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ZipUtil {
    public static void zip(File[] source, OutputStream outputStream) throws IOException {
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
        try {
            File[] fileArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, file.getName());
                ++n2;
            }
        }
        finally {
            zipStream.close();
        }
    }

    public static void zip(File[] source, File zipFile) throws Exception {
        ZipUtil.zip(source, new FileOutputStream(zipFile));
    }

    private static void zip(File source, ZipOutputStream zipStream, String base) throws IOException {
        if (source.isDirectory()) {
            File[] fileList;
            ZipEntry entry = new ZipEntry(String.valueOf(base) + '/');
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            if (!StringUtil.isEmpty(base)) {
                base = String.valueOf(base) + '/';
            }
            File[] fileArray = fileList = FileUtil.listFiles(source);
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, String.valueOf(base) + file.getName());
                ++n2;
            }
        } else {
            ZipEntry entry = new ZipEntry(base);
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            FileInputStream in = new FileInputStream(source);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)zipStream);
            }
            finally {
                in.close();
            }
        }
    }

    public static void unzip(InputStream inputStream, File dest) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
        try {
            ZipEntry z;
            while ((z = zipStream.getNextEntry()) != null) {
                File f;
                String name = z.getName();
                if (z.isDirectory()) {
                    f = new File(dest, name = name.substring(0, name.length() - 1));
                    if (!f.exists()) {
                        f.mkdir();
                    }
                } else {
                    f = new File(dest, name);
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    FileOutputStream out = new FileOutputStream(f);
                    try {
                        IOUtils.copy((InputStream)zipStream, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                f.setLastModified(z.getTime());
            }
        }
        finally {
            zipStream.close();
        }
    }

    public static void unzip(File zipFile, File dest) throws IOException {
        ZipUtil.unzip(new FileInputStream(zipFile), dest);
    }
}

