-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- This file has been developed exclusively for the mod "Jão the Great Summoner" --
--(http://steamcommunity.com/sharedfiles/filedetails/?id=572470943). 		 --
-- Any unauthorized use will be reported to the DMCA. 				 --
-- To use any file or sprite ask my permission.					 --
--										 --
-- Author: Paulo Victor de Oliveira Leal					 --
-- Contact: ciclopiano@gmail.com						 --
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


-- Esta funcao de biblioteca nos permite usar um arquivo em um local especificado. 
-- Permite usar para chamar variaveis globais de ambiente sem inicializa-los em nossos arquivos.
modimport("libs/env.lua")

-- Acao de inicializacao.
use "data/actions/init"

-- Componente de inicializacao.
use "data/components/init"

-- Scripts necessarios
PrefabFiles = {
    "jao", "jaostaff", "summonskip", "summonrhino", "summonchop", "sourceofmagic",
}

-- Arquivos de importacao de imagens e animacao
Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/jao.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/jao.xml" ),
    
    Asset( "IMAGE", "images/selectscreen_portraits/jao.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/jao.xml" ),
    
    Asset( "IMAGE", "images/selectscreen_portraits/jao_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/jao_silho.xml" ),
    
    Asset( "IMAGE", "bigportraits/jao.tex" ),
    Asset( "ATLAS", "bigportraits/jao.xml" ),
    
    Asset( "IMAGE", "images/map_icons/jao.tex" ),
    Asset( "ATLAS", "images/map_icons/jao.xml" ),
    
    Asset( "IMAGE", "images/avatars/avatar_jao.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_jao.xml" ),
    
    Asset( "IMAGE", "images/avatars/avatar_ghost_jao.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_jao.xml" ),
    
    Asset("ATLAS",  "images/hud/magictab.xml"),
    Asset("IMAGE",  "images/hud/magictab.tex"),
    
    Asset( "IMAGE", "images/inventoryimages/sourceofmagic.tex" ),
    Asset( "ATLAS", "images/inventoryimages/sourceofmagic.xml" ),
    
}

-- Variaveis globais
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local SITCOMMAND = GLOBAL.Action(4, true, true, 10,	false, false, nil)
local SITCOMMAND_CANCEL = GLOBAL.Action(4, true, true, 10, false, false, nil)

-- Codigo da aba de receitas
local recipe_tab = AddRecipeTab(
"Invocations and Spells", -- Nome da aba
999, -- Posicao na lista de abas (999 e a ultima)
"images/hud/magictab.xml", -- Imagem da aba
"magictab.tex", -- (.tex) da imagem
"jaobuilder" -- Tag necessaria no personagem para visualizar essa aba
)

-- Receita da gema roxa
local purplegem_recipe = AddRecipe("purplegem", 
{Ingredient("goldnugget",5), Ingredient("tentaclespots", 3)}, 
recipe_tab, TECH.NONE, 
nil, nil, nil, 3)

-- Receita da gema 
local redgem_recipe = AddRecipe("redgem",
{Ingredient("goldnugget",5), Ingredient("mosquitosack", 3)},
recipe_tab, TECH.NONE,
nil, nil, nil, 3)

-- Receita da gema 
local bluegem_recipe = AddRecipe("bluegem",        
{Ingredient("goldnugget",5), Ingredient("ice", 3)},    
recipe_tab, TECH.NONE,
nil, nil, nil, 3)

-- Receitas dos tomos de feiticos
AddRecipe("book_birds",     {Ingredient("papyrus", 2),      Ingredient("bird_egg", 2)},                          recipe_tab, TECH.NONE)
AddRecipe("book_gardening", {Ingredient("papyrus", 2),      Ingredient("seeds", 1),      Ingredient("poop", 1)}, recipe_tab, TECH.NONE)
AddRecipe("book_sleep",     {Ingredient("papyrus", 2),      Ingredient("nightmarefuel", 2)},                     recipe_tab, TECH.NONE)
AddRecipe("book_brimstone", {Ingredient("papyrus", 2),      Ingredient("redgem", 1)},                            recipe_tab, TECH.NONE)
AddRecipe("book_tentacles", {Ingredient("papyrus", 2),      Ingredient("tentaclespots", 1)},                     recipe_tab, TECH.NONE)							

-- Receita para invoca o Chop
local summonchop_recipe = AddRecipe("summonchop",
{GLOBAL.Ingredient("sourceofmagic", 1, "images/inventoryimages/sourceofmagic.xml"), GLOBAL.Ingredient("livinglog", 1)},
recipe_tab, TECH.NONE,
nil, nil, nil, nil, nil,
"images/inventoryimages/summonchop.xml", "summonchop.tex")
summonchop_recipe.tagneeded = false
summonchop_recipe.builder_tag ="jaobuilder"
summonchop_recipe.atlas = resolvefilepath("images/inventoryimages/summonchop.xml")

-- Receita para invoca o Skip
local summonskip_recipe = AddRecipe("summonskip",
{GLOBAL.Ingredient("sourceofmagic", 1, "images/inventoryimages/sourceofmagic.xml")},
recipe_tab, TECH.NONE,
nil, nil, nil, nil, nil,
"images/inventoryimages/summonskip.xml", "summonskip.tex")
summonskip_recipe.tagneeded = false
summonskip_recipe.builder_tag ="jaobuilder"
summonskip_recipe.atlas = resolvefilepath("images/inventoryimages/summonskip.xml")

-- Receita para invocar o Rhino
local summonrhino_recipe = AddRecipe("summonrhino",
{GLOBAL.Ingredient("sourceofmagic", 1, "images/inventoryimages/sourceofmagic.xml"), GLOBAL.Ingredient("goldnugget", 1)},
recipe_tab, TECH.NONE,
nil, nil, nil, nil, nil,
"images/inventoryimages/summonrhino.xml", "summonrhino.tex")
summonrhino_recipe.tagneeded = false
summonrhino_recipe.builder_tag = "jaobuilder"
summonrhino_recipe.atlas = resolvefilepath("images/inventoryimages/summonrhino.xml")

-- Dados do persongem
STRINGS.CHARACTER_TITLES.jao = "伟大的召唤师"
STRINGS.CHARACTER_NAMES.jao = "饶先生"
STRINGS.CHARACTER_DESCRIPTIONS.jao = "*传送术\n*远程攻击\n*召唤"
STRINGS.CHARACTER_QUOTES.jao = "\"死混蛋!\""

-- Dados das gemas
GLOBAL.STRINGS.RECIPE_DESC.PURPLEGEM = "神奇物品的紫色宝石."
GLOBAL.STRINGS.RECIPE_DESC.REDGEM = "魔法物品的红色宝石."
GLOBAL.STRINGS.RECIPE_DESC.BLUEGEM = "蓝色宝石魔术项目."

-- Dados do cajado
GLOBAL.STRINGS.NAMES.JAOSTAFF = "饶先生的员工"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.JAOSTAFF = "量子隐形传态的来源，光与火"

-- Dados do item
GLOBAL.STRINGS.NAMES.SOURCEOFMAGIC = "魔法的来源"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SOURCEOFMAGIC = "授予的权力!"

-- Dados do Skip
GLOBAL.STRINGS.NAMES.SUMMONCHOP = "树精"
GLOBAL.STRINGS.RECIPE_DESC.SUMMONCHOP = "非常缓慢."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONCHOP = "甚至比那块石头还快！让我们砍来加速!..."

-- Dados do Skip
GLOBAL.STRINGS.NAMES.SUMMONSKIP = "石虾"
GLOBAL.STRINGS.RECIPE_DESC.SUMMONSKIP = "防御和精神光环."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONSKIP = "那只是一堆岩石..."

--Dados do Rhino
GLOBAL.STRINGS.NAMES.SUMMONRHINO = "犀牛"
GLOBAL.STRINGS.RECIPE_DESC.SUMMONRHINO = "失去控制."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONRHINO = "他很聪明?!"

-- Icones do mapa de cada objeto
AddMinimapAtlas("images/inventoryimages/chop.xml")
AddMinimapAtlas("images/inventoryimages/rocky.xml")
AddMinimapAtlas("images/inventoryimages/rhino.xml")
AddMinimapAtlas("images/inventoryimages/sourceofmagic_atlas.xml")

-- Funcoes de comando dos pets
AddReplicableComponent("followersitcommand")

-- Esperar
SITCOMMAND.id = "SITCOMMAND"
SITCOMMAND.str = "等待"
SITCOMMAND.fn = function(act)
    local targ = act.target
    if targ and targ.components.followersitcommand then
        act.doer.components.locomotor:Stop()
        act.doer.components.talker:Say("Hold on")
        targ.components.followersitcommand:SetStaying(true)
        targ.components.followersitcommand:RememberSitPos("currentstaylocation", GLOBAL.Point(targ.Transform:GetWorldPosition())) 
        return true
    end
end
AddAction(SITCOMMAND)

-- Chamar
SITCOMMAND_CANCEL.id = "SITCOMMAND_CANCEL"
SITCOMMAND_CANCEL.str = "召唤"
SITCOMMAND_CANCEL.fn = function(act)
    local targ = act.target
    if targ and targ.components.followersitcommand then
        act.doer.components.locomotor:Stop()
        act.doer.components.talker:Say("Hey, I need help!")
        targ.components.followersitcommand:SetStaying(false)
        return true
    end
end
AddAction(SITCOMMAND_CANCEL)

-- Animacao
AddComponentAction("SCENE", "followersitcommand", function(inst, doer, actions, rightclick)
    if rightclick and inst.replica.followersitcommand then
        if not inst.replica.followersitcommand:IsCurrentlyStaying() then
            table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND)
        else
            table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND_CANCEL)
        end
    end
end)

-- Animacao
AddComponentAction("SCENE", "followersitcommand", function(inst, doer, actions, rightclick)
    if rightclick and inst.replica.followersitcommand then
        if not inst.replica.followersitcommand:IsCurrentlyStaying() then
            table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND)
        else
            table.insert(actions, GLOBAL.ACTIONS.SITCOMMAND_CANCEL)
        end
    end
end)

-- Habilitar troca com os pets
function HF_addtradablecomponenttoprefab(inst)
    if not inst.components.tradable then
        inst:AddComponent("tradable")
    end
end

-- Itens trocaveis
AddPrefabPostInit("umbrella", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("torch", HF_addtradablecomponenttoprefab)


-- Interpretacao da chuva para os pets
AddComponentPostInit("moisture", function(self)
    local old = self.GetMoistureRate
    self.GetMoistureRate = function(self)
        local oldvalue = old(self)
        local x, y, z = self.inst.Transform:GetWorldPosition()
        local ents = GLOBAL.TheSim:FindEntities(x, y, z, 4, {'sheltercarrier'})
        for k, v in pairs(ents) do 
            if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
                v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "umbrella" then
                return 0
            end
            if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
                v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "grass_umbrella" then
                return oldvalue * 0.5
            end
        end
        return oldvalue
    end
end)

-- Arquivo de falas do personagem
STRINGS.CHARACTERS.JAO = require "speech_jao"

-- Nome no jogo
STRINGS.NAMES.JAO = "饶先生"

-- Falas genericas
STRINGS.CHARACTERS.GENERIC.DESCRIBE.JAO = 
{
    GENERIC = "这是饶先生!",
    ATTACKER = "这饶先生似乎很聪明....",
    MURDERER = "凶手!",
    REVIVER = "饶先生,失落的灵魂的朋友.",
    GHOST = "饶先生可以使用心脏.",
}

-- Genero do personagem (male, female, or robot)
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "jao")

AddMinimapAtlas("images/map_icons/jao.xml")

-- Inicio
AddModCharacter("jao")