-----------------------------------------------------------------------------------
-- This file has been developed exclusively for the mod "Jão the Great Summoner" --
--(http://steamcommunity.com/sharedfiles/filedetails/?id=572470943). 		 --
-- Any unauthorized use will be reported to the DMCA. 				 --
-- To use any file or sprite ask my permission.					 --
--										 --
-- Author: Paulo Victor de Oliveira Leal					 --
-- Contact: ciclopiano@gmail.com						 --
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


-- Animacoes e imagens necessarias
local assets=
{
    Asset("ANIM", "anim/jaostaff.zip"),
    Asset("ANIM", "anim/swap_jaostaff.zip"),
    
    Asset("SOUND", "sound/common.fsb"),
    
    Asset("ATLAS", "images/inventoryimages/jaostaff.xml"),
    Asset("IMAGE", "images/inventoryimages/jaostaff.tex"),
}

-- Scripts necessarios
local prefabs =
{
    "torchfire",
}

-- Consumir 1 de fome por ataque
local function onattack_jaostaff(inst, attacker, target)
    
    if attacker and attacker.components.hunger then
        attacker.components.hunger:DoDelta(-1)
    end
    
end

local function fn()
    -- Instanciar o cajado
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    --inst.entity:AddTransform()
    --inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    
    -- Gerar estrutura
    MakeInventoryPhysics(inst)
    
    -- Ligar animacoes ao cajado
    inst.AnimState:SetBank("jaostaff")
    inst.AnimState:SetBuild("jaostaff")
    inst.AnimState:PlayAnimation("idle")
    
    if not TheWorld.ismastersim then
        return inst
    end
    
    -- Fazer troca de animacoes do cajado ao equipar
    local function OnEquip(inst, owner)
        inst.components.burnable:Ignite()
        owner.AnimState:OverrideSymbol("swap_object", "swap_jaostaff", "swap_orbstaff")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
        inst.SoundEmitter:SetParameter("torch", "intensity", 1)
        
        if inst.fire == nil then
            inst.fire = SpawnPrefab("torchfire")
            local follower = inst.fire.entity:AddFollower()
            follower:FollowSymbol(owner.GUID, "swap_object", 0, -220, 1)
        end
    end
    
    -- Fazer troca de animacoes do cajado ao desequipar
    local function OnUnequip(inst, owner)
        inst.components.burnable:Extinguish()
        owner.AnimState:OverrideSymbol("swap_object", "swap_jaostaff", "swap_orbstaff")
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
        
        if inst.fire ~= nil then
            inst.fire:Remove()
            inst.fire = nil
        end
	
        inst.SoundEmitter:KillSound("torch")
        inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")
        
        owner.components.combat.damage = owner.components.combat.defaultdamage 
    end
    
    -- Ao guardar
    local function onpocket(inst, owner)
        inst.components.burnable:Extinguish()
    end
    
    -- Pegar local do mouse para teleportar
    local function blinkstaff_reticuletargetfn()
        local player = ThePlayer
        local rotation = player.Transform:GetRotation() * DEGREES
        local pos = player:GetPosition()
        for r = 13, 1, -1 do
            local numtries = 2 * PI * r
            local pt = FindWalkableOffset(pos, rotation, r, numtries)
            if pt ~= nil then
                return pt + pos
            end
        end
    end
    
    -- Teleportar
    local function onblink(staff, pos, caster)
        if caster.components.sanity ~= nil then
            caster.components.sanity:DoDelta(-1)
        end
    end 
    
    inst.entity:SetPristine()
    
    -- Lista de componentes:
    inst:AddComponent("lighter")
    
    inst:AddComponent("burnable")
    inst.components.burnable.canlight = false
    inst.components.burnable.fxprefab = nil
    
    inst:AddComponent("blinkstaff")
    inst.components.blinkstaff.onblinkfn = onblink
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "jaostaff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/jaostaff.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
    inst.components.inventoryitem.keepondeath = true
    
    inst:AddComponent("inspectable")
    
    inst:AddTag("shadow")
    inst:AddComponent("weapon")
    inst.components.weapon:SetOnAttack(onattack_jaostaff)
    inst.components.weapon:SetDamage(40)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetProjectile("fire_projectile")
    
    return inst
    
end

return  Prefab("common/inventory/jaostaff", fn, assets)