local require = GLOBAL.require
local FRAMES = GLOBAL.FRAMES
local TimeEvent = GLOBAL.TimeEvent
local State = GLOBAL.State
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
--
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS

STRINGS.NAMES.WINONA = "Winona"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WINONA = "Will update with their quotes for Winona for you console-spawners."

PrefabFiles = {
	"winona",
	"sewing_tape",
}

Assets = { 
    Asset( "IMAGE", "images/saveslot_portraits/winona.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/winona.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/winona_silho.tex" ),
    Asset( "IMAGE", "bigportraits/winona.tex" ),
	Asset( "IMAGE", "images/winona.tex" ),
	Asset( "IMAGE", "minimap/winona.tex" ),
	Asset( "IMAGE", "images/inventoryimages/sewing_tape.tex" ),
	Asset( "ATLAS", "images/inventoryimages/sewing_tape.xml" ),
    Asset( "ATLAS", "images/saveslot_portraits/winona.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winona.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winona_silho.xml" ),
    Asset( "ATLAS", "bigportraits/winona.xml" ),
	Asset( "ATLAS", "images/winona.xml" ),
	Asset( "ATLAS", "minimap/winona.xml" ),
	Asset("SOUNDPACKAGE", "sound/winona.fev"),	
	Asset("SOUND", "sound/winona.fsb"),
}

AddMinimapAtlas("minimap/winona.xml")
AddMinimapAtlas("images/winona.xml")

RemapSoundEvent( "dontstarve/characters/winona/death_voice", "winona/characters/winona/death_voice" )
RemapSoundEvent( "dontstarve/characters/winona/hurt", "winona/characters/winona/hurt" )
RemapSoundEvent( "dontstarve/characters/winona/talk_LP", "winona/characters/winona/talk_LP" )

local med_action = State({
    name = "domediumaction",
    tags = {"doing", "busy"},

    timeline=
    {
        TimeEvent(4*FRAMES, function( inst )
            inst.sg:RemoveStateTag("busy")
        end),
    },

    onenter = function(inst, timeout)
    
        inst.sg:SetTimeout(0.5)
        inst.components.locomotor:Stop()
        inst.SoundEmitter:PlaySound("dontstarve/wilson/make_trap", "make")
    
        inst.AnimState:PlayAnimation("build_pre")
        inst.AnimState:PushAnimation("build_loop", true)
    end,

    ontimeout = function(inst)
        inst.AnimState:PlayAnimation("build_pst")
        inst.sg:GoToState("idle", false)
        inst:PerformBufferedAction()
    end,

    onexit = function(inst)
        inst.SoundEmitter:KillSound("make")
    end,
})

AddStategraphState("wilson", med_action)
AddStategraphState("wilsonboating", med_action)

AddStategraphActionHandler("wilson", ActionHandler(ACTIONS.BUILD, function(inst)
	return inst:HasTag("fastbuilder") and "domediumaction" or "dolongaction"
end))
AddStategraphActionHandler("wilsonboating", ActionHandler(ACTIONS.BUILD, function(inst)
	return inst:HasTag("fastbuilder") and "domediumaction" or "dolongaction"
end))

local sewing_taperecipe = GLOBAL.Recipe( "sewing_tape", { Ingredient("silk", 1), Ingredient("cutgrass", 3)}, RECIPETABS.DRESS, nil, nil, nil, nil, "voxolaworker")
sewing_taperecipe.sortkey = -600
sewing_taperecipe.atlas = "images/inventoryimages/sewing_tape.xml"

ACTIONS.SEW.strfn = function(act)
    return act.invobject ~= nil and (act.invobject.prefab == "sewing_tape" and "PATCH")
end

--------------------------------------------------------------------
STRINGS.ACTIONS.SEW = 
{
	GENERIC = "Sew",
	PATCH = "Patch",
}
--------------------------------------------------------------------
STRINGS.NAMES.SEWING_TAPE = "Trusty Tape"
STRINGS.RECIPE_DESC.SEWING_TAPE = "Patch up degraded clothing items."
--------------------------------------------------------------------
STRINGS.CHARACTER_TITLES.winona = "The Handywoman"
STRINGS.CHARACTER_NAMES.winona = "Winona"
STRINGS.CHARACTER_DESCRIPTIONS.winona = "*Is a skilled builder\n*Gets one free hit from the dark\n*Brings her own tools"
STRINGS.CHARACTER_QUOTES.winona = "Anything can be fixed with hard work and elbow grease."
--------------------------------------------------------------------
STRINGS.CHARACTERS.WINONA = require "speech_winona"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "winona")

AddModCharacter("winona")