scriptName SmileToCamera extends Quest

;-- Properties --------------------------------------
actor property PlayerRef auto
static property HeadTrackDummyTarget auto
float property HeadTrack_Loop_Delay = 0.1 auto hidden
bool property HeadTrack_ON = true auto hidden
int property ExpressionMood = 10 auto hidden
int property ExpressionStrength = 25 auto hidden

;-- Variables ---------------------------------------
Bool firstpersonsuspend = false
bool bHeadtrackLast = true
ObjectReference Target
ObjectReference TempObj
Bool reg3 = false

;-- Functions ---------------------------------------

function OnInit()

	self.RegisterforCameraState()
	reg3 = true
	Target = none
	TempObj = none
	PlayerRef.SetAnimationVariableBool("IsNPC", true)
	PlayerRef.SetHeadTracking(true)
	self.RegisterForSingleUpdate(HeadTrack_Loop_Delay)
endFunction

function OnUpdate()

	;if skse.GetVersionRelease() <= 0 && skse.GetPluginVersion("BeinzCameraPlugin") <= 0
	;	debug.Notification("Error- could not find SKSE version or Head Track plugin.  Terminating loop.")
	;	return 
	;endIf
	if Target == none
		Utility.wait(3)	;for save loading
		TrackingObject_ON()
	elseif Target.GetParentCell() != PlayerRef.GetParentCell()
		TrackingObject_OFF()
		Utility.wait(3)	;for cell loading
		TrackingObject_ON()
	endIf
	if reg3 == false
		self.RegisterforCameraState()
		reg3 = true
	endIf
	if firstpersonsuspend == false && !PlayerRef.IsInCombat() && !PlayerRef.IsWeaponDrawn()
		float px = PlayerRef.GetPositionX()
		float py = PlayerRef.GetPositionY()
		float pz = PlayerRef.GetPositionZ()
		float x1 = BeinzCameraPlugin.CamPosX()
		float y1 = BeinzCameraPlugin.CamPosY()
		float z1 = BeinzCameraPlugin.CamPosZ()
		TempObj.SetPosition(x1,y1,z1)
		float dist = TempObj.GetDistance(PlayerRef)
		float zNew = z1 - (dist/100 * 12)
		TempObj.SetPosition(x1,y1,pz)
		float fAngle = PlayerRef.GetHeadingAngle(TempObj)
		;Debug.Trace("Beinz SmileToCamera Player [" + px + "," + py + "," + pz + "] / CamPlugin [" + x1 + "," + y1 + "," + z1 + "] / distance : " + dist + " / zNew : " + zNew + " / fAngle : " + fAngle)
		if (Math.Abs(fAngle) < 90)
			Target.SetPosition(x1,y1,zNew)
		else
			float offsetX = 100 * Math.Cos(0)
			float offsetY = 100 * Math.Sin(0)
			Target.MoveTo(PlayerRef,offsetX,offsetY,PlayerRef.GetHeight())
		endIf
		PlayerRef.SetAnimationVariableBool("IsNPC", true)
		PlayerRef.SetHeadTracking(true)
		PlayerRef.SetLookAt(Target, false)
		PlayerRef.SetExpressionOverride(ExpressionMood, ExpressionStrength)
		bHeadtrackLast = true
	elseif bHeadtrackLast
		PlayerRef.SetAnimationVariableBool("IsNPC", false)
		PlayerRef.SetHeadTracking(false)
		PlayerRef.SetLookAt(PlayerRef as ObjectReference, false)
		PlayerRef.SetExpressionOverride(8, 0)	;8: Mood Anger
		bHeadtrackLast = false
	endIf
	if HeadTrack_ON == true ;&& skse.GetPluginVersion("BeinzCameraPlugin") > 0
		self.RegisterForSingleUpdate(HeadTrack_Loop_Delay)
	else
		HeadTrack_OFF()
		TrackingObject_OFF()
	endIf
endFunction

Function TrackingObject_ON()
	Target = PlayerRef.PlaceAtMe(HeadTrackDummyTarget as form, 1, false, false)
	TempObj = PlayerRef.PlaceAtMe(HeadTrackDummyTarget as form, 1, false, false)
EndFunction

Function TrackingObject_OFF()
	TempObj.DisableNoWait(false)
	TempObj.Delete()
	TempObj = none
	Target.DisableNoWait(false)
	Target.Delete()
	Target = none
EndFunction

function HeadTrack_OFF()
	HeadTrack_ON = false
	PlayerRef.SetAnimationVariableBool("IsNPC", false)
	PlayerRef.SetHeadTracking(false)
	PlayerRef.SetLookAt(PlayerRef as ObjectReference, false)
	PlayerRef.SetExpressionOverride(8, 0)	;8: Mood Anger
endFunction

function HeadTrack_ON()
	HeadTrack_ON = true
	PlayerRef.SetAnimationVariableBool("IsNPC", true)
	PlayerRef.SetHeadTracking(true)
	self.RegisterForSingleUpdate(HeadTrack_Loop_Delay)
endFunction

function ToggleOnOff()
	if HeadTrack_ON == true
		HeadTrack_OFF()
	else
		HeadTrack_ON()
	endIf
endFunction

;valid States for Camera:
;0 - first person	= 1st
;1 - auto vanity
;2 - VATS
;3 - free			= TFC
;4 - iron sights
;5 - furniture
;6 - transition
;7 - tweenmenu
;8 - third person 1
;9 - third person 2	= 3rd
;10 - horse
;11 - bleedout
;12 - dragon
function OnPlayerCameraState(Int oldState, Int newState)

	if newState == 0
		firstpersonsuspend = true
	else
		firstpersonsuspend = false
		;Debug.Notification("SmileToCamera CameraState : " + newState)
	endIf
endFunction
