scriptName SmileToCamera_MCM extends SKI_ConfigBase

;-- Properties --------------------------------------
SmileToCamera property theQuest auto

;-- Variables ---------------------------------------
int id_On = 0
int id_delaySlider = 0
int id_ExpressionMood = 10
int id_ExpressionStrength = 25

; SCRIPT VERSION ----------------------------------------------------------------------------------

int function GetVersion()
	return 1
endFunction

; INITIALIZATION ----------------------------------------------------------------------------------

; @implements SKI_ConfigBase
event OnConfigInit()
	ModName = "Smile To Camera"
	
endEvent

; @implements SKI_QuestBase
;this event called from PlayerAlias!!! so we must attach SKI_PlayerLoadGameAlias to quest
event OnVersionUpdate(int newVersion)
	Debug.Trace(self + ": Updating Version [" + CurrentVersion + "] -> [" + newVersion + "]")
	OnConfigInit()
endEvent

Function VersionCheck()
	;Mcm not call OnVersionUpdate() !! so force call OnVersionUpdate()
	debug.trace(self+" : VersionCheck()")
	Parent.CheckVersion()
EndFunction

;this event called from PlayerAlias!!! so we must attach SKI_PlayerLoadGameAlias to quest
Event OnGameReload()
	Parent.OnGameReload()
	
	Debug.Trace(self + " OnGameReload() : Check Version [" + CurrentVersion + "] / [" + GetVersion() + "]")
	VersionCheck()
	
EndEvent

;-- Events ---------------------------------------

event OnPageReset(string pagename)
	SetCursorFillMode(TOP_TO_BOTTOM)

	self.AddHeaderOption("ON/OFF", 0)
	id_On = self.AddToggleOption("ON/OFF", theQuest.HeadTrack_ON, 0)
	self.AddHeaderOption("Delay", 0)
	id_delaySlider = self.AddSliderOption("Loop Run Interval (s)", theQuest.HeadTrack_Loop_Delay, "{2}", 0)
	
	SetCursorPosition(1)
	
	self.AddHeaderOption("Facial Expression", 0)
	id_ExpressionMood = self.AddSliderOption("Mood", theQuest.ExpressionMood, "{0}", 0)
	id_ExpressionStrength = self.AddSliderOption("Strength", theQuest.ExpressionStrength, "{0}", 0)
	
endEvent

function OnOptionDefault(Int option)

	if option == id_On
		theQuest.HeadTrack_ON()
		self.SetToggleOptionValue(option, theQuest.HeadTrack_ON, false)
	elseif option == id_delaySlider
		theQuest.HeadTrack_Loop_Delay = 0.1
		self.SetSliderOptionValue(option, theQuest.HeadTrack_Loop_Delay, "{2}", false)
	elseif option == id_ExpressionMood
		theQuest.ExpressionMood = 10
		self.SetSliderOptionValue(option, theQuest.ExpressionMood, "{0}", false)
	elseif option == id_ExpressionStrength
		theQuest.ExpressionStrength = 25
		self.SetSliderOptionValue(option, theQuest.ExpressionStrength, "{0}", false)
	endIf
endFunction

function OnOptionSelect(Int option)

	if option == id_On
		theQuest.ToggleOnOff()
		self.SetToggleOptionValue(id_On, theQuest.HeadTrack_ON, false)
	endIf
endFunction

function OnOptionSliderOpen(Int option)

	if option == id_delaySlider
		self.SetSliderDialogRange(0.000000, 1.00000)
		self.SetSliderDialogInterval(0.0100000)
		self.SetSliderDialogStartValue(theQuest.HeadTrack_Loop_Delay)
	elseif option == id_ExpressionMood
		self.SetSliderDialogRange(0.0, 16.0)
		self.SetSliderDialogInterval(1)
		self.SetSliderDialogStartValue(theQuest.ExpressionMood)
	elseif option == id_ExpressionStrength
		self.SetSliderDialogRange(0.0, 100.0)
		self.SetSliderDialogInterval(1)
		self.SetSliderDialogStartValue(theQuest.ExpressionStrength)
	endIf
endFunction

function OnOptionSliderAccept(Int option, Float value)

	if option == id_delaySlider
		self.SetSliderOptionValue(option, value, "{2}", false)
		theQuest.HeadTrack_Loop_Delay = value
	elseif option == id_ExpressionMood
		self.SetSliderOptionValue(option, value, "{0}", false)
		theQuest.ExpressionMood = value as int
	elseif option == id_ExpressionStrength
		self.SetSliderOptionValue(option, value, "{0}", false)
		theQuest.ExpressionStrength = value as int
	endIf
endFunction

;-- Functions ---------------------------------------

;-- State -------------------------------------------
