local assets=
{
	Asset("ANIM", "anim/cactus_cocktail.zip"),
	Asset("ATLAS", "images/inventoryimages/cactus_cocktail.xml"),	-- Atlas for inventory TEX
    Asset("IMAGE", "images/inventoryimages/cactus_cocktail.tex")
}

local prefabs = 
{
	"spoiled_food",
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("cactus_cocktail")
    inst.AnimState:SetBuild("cactus_cocktail")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "cactus_cocktail"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/cactus_cocktail.xml"
	
--[[	inst:AddComponent("harvestable")
	inst.components.stewer.product.imagename = "butter"
	inst.components.stewer.product.atlasname = "images/inventoryimages/butter.xml"
	]]
	inst:AddComponent("tradable")
	
    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_MEDSMALL
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = TUNING.SANITY_MEDLARGE
	inst.components.edible.temperatureduration = -30
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    
    return inst
end

STRINGS.NAMES.CACTUS_COCKTAIL = "Cactus Cocktail"

-- Randomizes the inspection line upon inspection.
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CACTUS_COCKTAIL = {	
	"After cooking - stimulates.",
	"Refreshing",
}

return Prefab( "common/inventory/cactus_cocktail", fn, assets, prefabs) 
