require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/extractor.zip"),
    Asset("ATLAS", "images/inventoryimages/extractor.xml"),
    Asset("IMAGE", "images/inventoryimages/extractor.tex"),
--	Asset("ATLAS", "images/inventoryimages/ui_extractor_1x1.xml"),
}

local prefabs = 

{
 "campfirefire",
 "smokeex",
}

-- Extractor potraktowany motem
local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle")
end

local function onbuilt(inst)
	inst.components.fueled:InitializeFuelLevel(0)
	inst.AnimState:PlayAnimation("build")
	inst.AnimState:PushAnimation("idle", false)
end

local function onignite(inst)
    if not inst.components.streamer then
        inst:AddComponent("streamer")
    end
	inst.AnimState:PlayAnimation("working", true)
end

local function onextinguish(inst)
    if inst.components.streamer then
        inst:RemoveComponent("streamer")
    end
    if inst.components.fueled then
        inst.components.fueled:InitializeFuelLevel(0)
    end
	inst.AnimState:PushAnimation("idle", true)
end


-- 	Define the positions of the slots
--local slotpos = {Vector3(5,34,0)}




--local function onopen(inst)
	--inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open", "open")
	
--	inst.AnimState:PlayAnimation("open")
--end 

--local function onclose(inst)
	--inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close", "close")

	--inst.AnimState:PlayAnimation("closed")
--end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "extractor.tex" )
    
    inst:AddTag("structure")
    MakeObstaclePhysics(inst, .5)
    
    inst.AnimState:SetBank("extractor")
    inst.AnimState:SetBuild("extractor")
	inst.AnimState:PlayAnimation("idle")
	

	--inst:AddComponent("container")
    --inst.components.container:SetNumSlots(1)
    --inst.components.container.widgetslotpos = slotpos
    --inst.components.container.widgetanimbank = nil
	--inst.components.container.widgetanimbuild = nil
	--inst.components.container.widgetbgatlas = "images/inventoryimages/ui_extractor_1x1.xml"
	--inst.components.container.widgetbgimage = "ui_extractor_1x1.tex"	
    --inst.components.container.widgetpos = Vector3(200,0,0)
	--inst.components.container.side_align_tip = 100
    --inst.components.container.acceptsstacks = false

    --inst.components.container.onopenfn = onopen
    --inst.components.container.onclosefn = onclose
	
    inst:AddComponent("inspectable")
	
	
	inst:AddComponent("burnable")
    inst.components.burnable:AddBurnFX("smokeex", Vector3(-185,-245,0), "fire_marker")
	inst:ListenForEvent("onextinguish", onextinguish)
    inst:ListenForEvent("onignite", onignite)
	
	
	inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.NIGHTLIGHT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled.fueltype = "NIGHTMARE"
    inst.components.fueled:SetSections(1)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel") end
    
    inst.components.fueled:SetUpdateFn( function()
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(TUNING.NIGHTLIGHT_FUEL_START)
	
	
	inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
	
	inst:ListenForEvent( "onbuilt", onbuilt)
	
    return inst
end


STRINGS.NAMES.EXTRACTOR = "Alchemy Table"
STRINGS.RECIPE_DESC.EXTRACTOR = "Change items to new forms."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.EXTRACTOR = {	
	"Strange gadget of the strange purpose...",
	 
}

-- Add recipe for extractor
local crafting_recipe = Recipe("extractor", {Ingredient("boards", 8),Ingredient("ash", 2), Ingredient("redgem", 1)}, RECIPETABS.MAGIC,  TECH.MAGIC_TWO, "extractor_placer")
crafting_recipe.atlas = "images/inventoryimages/extractor.xml"


return Prefab( "common/extractor", fn, assets, prefabs),
	MakePlacer( "common/extractor_placer", "extractor", "extractor", "idle" ) 
