local assets=
{
    Asset("ANIM", "anim/salt.zip"),						-- Animation Zip
    Asset("ATLAS", "images/inventoryimages/salt.xml"),	-- Atlas for inventory TEX
    Asset("IMAGE", "images/inventoryimages/salt.tex"),	-- TEX for inventory
}

local function fn(Sim)
	-- Create a new entity
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	-- Set animation info
	inst.AnimState:SetBuild("salt")
	inst.AnimState:SetBank("salt")
	inst.AnimState:PlayAnimation("idle")
	
	-- Make it edible
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = -TUNING.HEALING_SMALL	-- Amount to heal
	inst.components.edible.hungervalue =  0	-- Amount to fill belly
	inst.components.edible.sanityvalue =  0	-- Amount to help Sanity
	
	-- Make it perishable
	--inst:AddComponent("perishable")
	--inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	--inst.components.perishable:StartPerishing()
	--inst.components.perishable.onperishreplacement = "spoiled_food"
	
	-- Make it stackable
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	-- Make it inspectable
	inst:AddComponent("inspectable")
	
	--inst:AddComponent("tradable")
	
	-- Make it an inventory item
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "salt"	-- Use our TEX sprite
    inst.components.inventoryitem.atlasname = "images/inventoryimages/salt.xml"	-- here's the atlas for our tex
	
	
	return inst
end

STRINGS.NAMES.SALT = "Salt"

-- Randomizes the inspection line upon inspection.
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SALT = {	
	"Salty ... what a surprise",
	"Cooking finally makes sense",
}

AddIngredientValues({"salt"}, {salt=1})

-- Return our prefab
return Prefab( "common/inventory/salt", fn, assets)