## wekan-cfs-file Public API ##

CollectionFS, FS.File object

_API documentation automatically generated by [docmeteor](https://github.com/raix/docmeteor)._

-

### <a name="FS.File"></a>new *fs*.File([ref])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __File__ is defined in `FS`*

__Arguments__

* __ref__ *{object|[FS.File](#FS.File)|[data to attach](#data to attach)}*  (Optional)

 Another FS.File instance, a filerecord, or some data to pass to attachData



> ```FS.File = function(ref, createdByTransform) { ...``` [fsFile-common.js:8](fsFile-common.js#L8)


-

### <a name="FS.File.prototype.attachData"></a>*fsFile*.attachData(data, [options], [callback])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __attachData__ is defined in `prototype` of `FS.File`*

__Arguments__

* __data__ *{[File](#File)|[Blob](#Blob)|Buffer|ArrayBuffer|Uint8Array|String}*  

 The data that you want to attach to the file.

* __options__ *{Object}*  (Optional)

 Options

    * __type__ *{String}*  (Optional)

    The data content (MIME) type, if known.

    * __headers__ *{String}*  (Optional)

    When attaching a URL, headers to be used for the GET request (currently server only)

    * __auth__ *{String}*  (Optional)

    When attaching a URL, "username:password" to be used for the GET request (currently server only)

* __callback__ *{Function}*  (Optional)

 Callback function, callback(error). On the client, a callback is required if data is a URL.


__Returns__  *{FS.File}*
This FS.File instance.



> ```FS.File.prototype.attachData = function fsFileAttachData(data, options, callback) { ...``` [fsFile-common.js:36](fsFile-common.js#L36)


-

### <a name="FS.File.prototype.uploadProgress"></a>*fsFile*.uploadProgress()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __uploadProgress__ is defined in `prototype` of `FS.File`*

__Returns__  *{number}*
The server confirmed upload progress


> ```FS.File.prototype.uploadProgress = function() { ...``` [fsFile-common.js:154](fsFile-common.js#L154)


-

### <a name="FS.File.prototype.controlledByDeps"></a>*fsFile*.controlledByDeps()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __controlledByDeps__ is defined in `prototype` of `FS.File`*

__Returns__  *{FS.Collection}*
Returns true if this FS.File is reactive


> Note: Returns true if this FS.File object was created by a FS.Collection
> and we are in a reactive computations. What does this mean? Well it should
> mean that our fileRecord is fully updated by Meteor and we are mounted on
> a collection

> ```FS.File.prototype.controlledByDeps = function() { ...``` [fsFile-common.js:179](fsFile-common.js#L179)


-

### <a name="FS.File.prototype.getCollection"></a>*fsFile*.getCollection()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __getCollection__ is defined in `prototype` of `FS.File`*

__Returns__  *{FS.Collection}*
Returns attached collection or undefined if not mounted


> ```FS.File.prototype.getCollection = function() { ...``` [fsFile-common.js:189](fsFile-common.js#L189)


-

### <a name="FS.File.prototype.isMounted"></a>*fsFile*.isMounted()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __isMounted__ is defined in `prototype` of `FS.File`*

__Returns__  *{FS.Collection}*
Returns attached collection or undefined if not mounted


> ```FS.File.prototype.isMounted = FS.File.prototype.getCollection;``` [fsFile-common.js:217](fsFile-common.js#L217)


-

### <a name="FS.File.prototype.getFileRecord"></a>*fsFile*.getFileRecord()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __getFileRecord__ is defined in `prototype` of `FS.File`*

__Returns__  *{object}*
The filerecord


> ```FS.File.prototype.getFileRecord = function() { ...``` [fsFile-common.js:224](fsFile-common.js#L224)


-

### <a name="FS.File.prototype.update"></a>*fsFile*.update(modifier, [options], [callback])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __update__ is defined in `prototype` of `FS.File`*

__Arguments__

* __modifier__ *{[modifier](#modifier)}*  
* __options__ *{object}*  (Optional)
* __callback__ *{function}*  (Optional)


Updates the fileRecord.

> ```FS.File.prototype.update = function(modifier, options, callback) { ...``` [fsFile-common.js:255](fsFile-common.js#L255)


-

### <a name="FS.File.prototype.remove"></a>*fsFile*.remove([callback])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __remove__ is defined in `prototype` of `FS.File`*

__Arguments__

* __callback__ *{Function}*  (Optional)

__Returns__  *{number}*
Count


Remove the current file from its FS.Collection

> ```FS.File.prototype.remove = function(callback) { ...``` [fsFile-common.js:323](fsFile-common.js#L323)


-

### <a name="FS.File.prototype.getExtension"></a>*fsFile*.getExtension([options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

> __Warning!__
> This method "FS.File.prototype.getExtension" has deprecated from the API
> Use the `extension` getter/setter method instead.

*This method __getExtension__ is defined in `prototype` of `FS.File`*

__Arguments__

* __options__ *{Object}*  (Optional)
    * __store__ *{String}*  (Optional)

     Store name. Default is the original extension.


__Returns__  *{string}*
The extension eg.: `jpg` or if not found then an empty string ''


> ```FS.File.prototype.getExtension = function(options) { ...``` [fsFile-common.js:364](fsFile-common.js#L364)


-

### <a name="FS.File.prototype.isImage"></a>*fsFile*.isImage([options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __isImage__ is defined in `prototype` of `FS.File`*

__Arguments__

* __options__ *{object}*  (Optional)
    * __store__ *{string}*  (Optional)

    The store we're interested in



Returns true if the copy of this file in the specified store has an image
content type. If the file object is unmounted or doesn't have a copy for
the specified store, or if you don't specify a store, this method checks
the content type of the original file.

> ```FS.File.prototype.isImage = function(options) { ...``` [fsFile-common.js:393](fsFile-common.js#L393)


-

### <a name="FS.File.prototype.isVideo"></a>*fsFile*.isVideo([options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __isVideo__ is defined in `prototype` of `FS.File`*

__Arguments__

* __options__ *{object}*  (Optional)
    * __store__ *{string}*  (Optional)

    The store we're interested in



Returns true if the copy of this file in the specified store has a video
content type. If the file object is unmounted or doesn't have a copy for
the specified store, or if you don't specify a store, this method checks
the content type of the original file.

> ```FS.File.prototype.isVideo = function(options) { ...``` [fsFile-common.js:408](fsFile-common.js#L408)


-

### <a name="FS.File.prototype.isAudio"></a>*fsFile*.isAudio([options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __isAudio__ is defined in `prototype` of `FS.File`*

__Arguments__

* __options__ *{object}*  (Optional)
    * __store__ *{string}*  (Optional)

    The store we're interested in



Returns true if the copy of this file in the specified store has an audio
content type. If the file object is unmounted or doesn't have a copy for
the specified store, or if you don't specify a store, this method checks
the content type of the original file.

> ```FS.File.prototype.isAudio = function(options) { ...``` [fsFile-common.js:423](fsFile-common.js#L423)


-

### <a name="FS.File.prototype.formattedSize"></a>*fsFile*.formattedSize({Object}, {String}, {String})&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __formattedSize__ is defined in `prototype` of `FS.File`*

__Arguments__

* __{Object}__ *{any}*  

 options

* __{String}__ *{any}*  

 [options.store=none,display original file size] Which file do you want to get the size of?

* __{String}__ *{any}*  

 [options.formatString='0.00 b'] The `numeral` format string to use.


__Returns__  *{String}*
The file size formatted as a human readable string and reactively updated.


You must add the `numeral` package to your app before you can use this method.
If info is not found or a size can't be determined, it will show 0.

> ```FS.File.prototype.formattedSize = function fsFileFormattedSize(options) { ...``` [fsFile-common.js:438](fsFile-common.js#L438)


-

### <a name="FS.File.prototype.isUploaded"></a>*fsFile*.isUploaded()&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __isUploaded__ is defined in `prototype` of `FS.File`*

__Returns__  *{boolean}*
True if the number of uploaded bytes is equal to the file size.


> ```FS.File.prototype.isUploaded = function() { ...``` [fsFile-common.js:456](fsFile-common.js#L456)


-

### <a name="FS.File.prototype.hasStored"></a>*fsFile*.hasStored(storeName, [optimistic])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __hasStored__ is defined in `prototype` of `FS.File`*

__Arguments__

* __storeName__ *{string}*  

 Name of the store

* __optimistic__ *{boolean}*  (Optional, Default = false)

 In case that the file record is not found, read below


__Returns__  *{boolean}*
Is a version of this file stored in the given store?


> Note: If the file is not published to the client or simply not found:
this method cannot know for sure if it exists or not. The `optimistic`
param is the boolean value to return. Are we `optimistic` that the copy
could exist. This is the case in `FS.File.url` we are optimistic that the
copy supplied by the user exists.

> ```FS.File.prototype.hasStored = function(storeName, optimistic) { ...``` [fsFile-common.js:478](fsFile-common.js#L478)


-

### <a name="FS.File.prototype.getCopyInfo"></a>*fsFile*.getCopyInfo(storeName)&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

> __Warning!__
> This method "FS.File.prototype.getCopyInfo" has deprecated from the API
> Use individual methods with `store` option instead.

*This method __getCopyInfo__ is defined in `prototype` of `FS.File`*

__Arguments__

* __storeName__ *{string}*  

 Name of the store for which to get copy info.


__Returns__  *{Object}*
The file details, e.g., name, size, key, etc., specific to the copy saved in this store.


> ```FS.File.prototype.getCopyInfo = function(storeName) { ...``` [fsFile-common.js:504](fsFile-common.js#L504)


-

### <a name="FS.File.prototype.name"></a>*fsFile*.name([value], [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __name__ is defined in `prototype` of `FS.File`*

__Arguments__

* __value__ *{String|null}*  (Optional)

 If setting the name, specify the new name as the first argument. Otherwise the options argument should be first.

* __options__ *{Object}*  (Optional)
    * __store__ *{Object}*  (Optional, Default = none,original)

     Get or set the name of the version of the file that was saved in this store. Default is the original file name.

    * __updateFileRecordFirst__ *{Boolean}*  (Optional, Default = false)

    Update this instance with data from the DB first? Applies to getter usage only.

    * __save__ *{Boolean}*  (Optional, Default = true)

    Save change to database? Applies to setter usage only.


__Returns__  *{String|undefined}*
If setting, returns `undefined`. If getting, returns the file name.


> ```FS.File.prototype.name = function(value, options) { ...``` [fsFile-common.js:568](fsFile-common.js#L568)


-

### <a name="FS.File.prototype.extension"></a>*fsFile*.extension([value], [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __extension__ is defined in `prototype` of `FS.File`*

__Arguments__

* __value__ *{String|null}*  (Optional)

 If setting the extension, specify the new extension (without period) as the first argument. Otherwise the options argument should be first.

* __options__ *{Object}*  (Optional)
    * __store__ *{Object}*  (Optional, Default = none,original)

     Get or set the extension of the version of the file that was saved in this store. Default is the original file extension.

    * __updateFileRecordFirst__ *{Boolean}*  (Optional, Default = false)

    Update this instance with data from the DB first? Applies to getter usage only.

    * __save__ *{Boolean}*  (Optional, Default = true)

    Save change to database? Applies to setter usage only.


__Returns__  *{String|undefined}*
If setting, returns `undefined`. If getting, returns the file extension or an empty string if there isn't one.


> ```FS.File.prototype.extension = function(value, options) { ...``` [fsFile-common.js:593](fsFile-common.js#L593)


-

### <a name="FS.File.prototype.size"></a>*fsFile*.size([value], [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __size__ is defined in `prototype` of `FS.File`*

__Arguments__

* __value__ *{Number}*  (Optional)

 If setting the size, specify the new size in bytes as the first argument. Otherwise the options argument should be first.

* __options__ *{Object}*  (Optional)
    * __store__ *{Object}*  (Optional, Default = none,original)

     Get or set the size of the version of the file that was saved in this store. Default is the original file size.

    * __updateFileRecordFirst__ *{Boolean}*  (Optional, Default = false)

    Update this instance with data from the DB first? Applies to getter usage only.

    * __save__ *{Boolean}*  (Optional, Default = true)

    Save change to database? Applies to setter usage only.


__Returns__  *{Number|undefined}*
If setting, returns `undefined`. If getting, returns the file size.


> ```FS.File.prototype.size = function(value, options) { ...``` [fsFile-common.js:618](fsFile-common.js#L618)


-

### <a name="FS.File.prototype.type"></a>*fsFile*.type([value], [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __type__ is defined in `prototype` of `FS.File`*

__Arguments__

* __value__ *{String}*  (Optional)

 If setting the type, specify the new type as the first argument. Otherwise the options argument should be first.

* __options__ *{Object}*  (Optional)
    * __store__ *{Object}*  (Optional, Default = none,original)

     Get or set the type of the version of the file that was saved in this store. Default is the original file type.

    * __updateFileRecordFirst__ *{Boolean}*  (Optional, Default = false)

    Update this instance with data from the DB first? Applies to getter usage only.

    * __save__ *{Boolean}*  (Optional, Default = true)

    Save change to database? Applies to setter usage only.


__Returns__  *{String|undefined}*
If setting, returns `undefined`. If getting, returns the file type.


> ```FS.File.prototype.type = function(value, options) { ...``` [fsFile-common.js:643](fsFile-common.js#L643)


-

### <a name="FS.File.prototype.updatedAt"></a>*fsFile*.updatedAt([value], [options])&nbsp;&nbsp;<sub><i>Anywhere</i></sub> ###

*This method __updatedAt__ is defined in `prototype` of `FS.File`*

__Arguments__

* __value__ *{String}*  (Optional)

 If setting updatedAt, specify the new date as the first argument. Otherwise the options argument should be first.

* __options__ *{Object}*  (Optional)
    * __store__ *{Object}*  (Optional, Default = none,original)

     Get or set the last updated date for the version of the file that was saved in this store. Default is the original last updated date.

    * __updateFileRecordFirst__ *{Boolean}*  (Optional, Default = false)

    Update this instance with data from the DB first? Applies to getter usage only.

    * __save__ *{Boolean}*  (Optional, Default = true)

    Save change to database? Applies to setter usage only.


__Returns__  *{String|undefined}*
If setting, returns `undefined`. If getting, returns the file's last updated date.


> ```FS.File.prototype.updatedAt = function(value, options) { ...``` [fsFile-common.js:668](fsFile-common.js#L668)


-

### <a name="FS.File.prototype.createReadStream"></a>*fsFile*.createReadStream([storeName])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __createReadStream__ is defined in `prototype` of `FS.File`*

__Arguments__

* __storeName__ *{String}*  (Optional)

__Returns__  *{stream.Readable}*
Readable NodeJS stream


Returns a readable stream. Where the stream reads from depends on the FS.File instance and whether you pass a store name.

If you pass a `storeName`, a readable stream for the file data saved in that store is returned.
If you don't pass a `storeName` and data is attached to the FS.File instance (on `data` property, which must be a DataMan instance), then a readable stream for the attached data is returned.
If you don't pass a `storeName` and there is no data attached to the FS.File instance, a readable stream for the file data currently in the temporary store (`FS.TempStore`) is returned.


> ```FS.File.prototype.createReadStream = function(storeName) { ...``` [fsFile-server.js:62](fsFile-server.js#L62)


-

### <a name="FS.File.prototype.createWriteStream"></a>*fsFile*.createWriteStream([storeName])&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __createWriteStream__ is defined in `prototype` of `FS.File`*

__Arguments__

* __storeName__ *{String}*  (Optional)

__Returns__  *{stream.Writeable}*
Writeable NodeJS stream


Returns a writeable stream. Where the stream writes to depends on whether you pass in a store name.

If you pass a `storeName`, a writeable stream for (over)writing the file data in that store is returned.
If you don't pass a `storeName`, a writeable stream for writing to the temp store for this file is returned.


> ```FS.File.prototype.createWriteStream = function(storeName) { ...``` [fsFile-server.js:100](fsFile-server.js#L100)


-

### <a name="FS.File.prototype.copy"></a>*fsFile*.copy()&nbsp;&nbsp;<sub><i>Server</i></sub> ###

*This method __copy__ is defined in `prototype` of `FS.File`*

__Returns__  *{FS.File}*
The new FS.File instance


> ```FS.File.prototype.copy = function() { ...``` [fsFile-server.js:126](fsFile-server.js#L126)


