/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class TableColumnHeader
extends StackPane {
    private static final double DEFAULT_WIDTH = 80.0;
    private boolean autoSizeComplete = false;
    private final InvalidationListener sceneListener = new InvalidationListener(){
        final int n = 30;

        @Override
        public void invalidated(Observable observable) {
            if (!TableColumnHeader.this.autoSizeComplete) {
                if (TableColumnHeader.this.getTableColumn() == null || TableColumnHeader.this.getTableColumn().getPrefWidth() != 80.0 || TableColumnHeader.this.getScene() == null) {
                    return;
                }
                TableColumnHeader.this.resizeToFit(TableColumnHeader.this.getTableColumn(), 30);
                TableColumnHeader.this.autoSizeComplete = true;
            }
        }
    };
    private final InvalidationListener visibleListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableColumnHeader.this.setVisible(TableColumnHeader.this.getTableColumn().isVisible());
        }
    };
    private ListChangeListener<TableColumn<?, ?>> sortOrderListener = new ListChangeListener<TableColumn<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<?, ?>> change) {
            TableColumnHeader.this.setSortPos(!TableColumnHeader.this.getTableColumn().isSortable() ? -1 : TableColumnHeader.this.getTableView().getSortOrder().indexOf(TableColumnHeader.this.getTableColumn()));
        }
    };
    private InvalidationListener widthListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableColumnHeader.this.isSizeDirty = true;
            TableColumnHeader.this.requestLayout();
        }
    };
    private InvalidationListener sortTypeListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableColumnHeader.this.arrow.setRotate(TableColumnHeader.this.column.getSortType() == TableColumn.SortType.ASCENDING ? 180.0 : 0.0);
            TableColumnHeader.this.updateSortGrid();
        }
    };
    private ListChangeListener<TableColumn<?, ?>> visibleLeafColumnsListener = new ListChangeListener<TableColumn<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<?, ?>> change) {
            TableColumnHeader.this.updateColumnIndex();
        }
    };
    private WeakInvalidationListener weakVisibleListener = new WeakInvalidationListener(this.visibleListener);
    private WeakListChangeListener<TableColumn<?, ?>> weakSortOrderListener = new WeakListChangeListener(this.sortOrderListener);
    private WeakInvalidationListener weakWidthListener = new WeakInvalidationListener(this.widthListener);
    private WeakInvalidationListener weakSortTypeListener = new WeakInvalidationListener(this.sortTypeListener);
    private final WeakListChangeListener weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private double dragOffset;
    private final TableView table;
    private DoubleProperty size;
    private NestedTableColumnHeader nestedColumnHeader;
    private final TableColumn column;
    private TableHeaderRow tableHeaderRow;
    private NestedTableColumnHeader parentHeader;
    private Label label;
    private int sortPos = -1;
    private StackPane arrow;
    private Label sortOrderLabel;
    private HBox sortOrderDots;
    private Node sortArrow;
    private boolean isSortColumn;
    private boolean isSizeDirty = false;
    boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private int newColumnPos;
    private static final String PSEUDO_CLASS_LAST_VISIBLE = "last-visible";

    public TableColumnHeader(TableView tableView, TableColumn tableColumn) {
        this.column = tableColumn;
        this.table = tableView;
        this.getStyleClass().setAll((String[])new String[]{"column-header"});
        if (this.getTableColumn() != null) {
            this.idProperty().bind(this.column.idProperty());
            this.styleProperty().bind(this.column.styleProperty());
        }
        this.setFocusTraversable(false);
        this.updateColumnIndex();
        this.initUI();
        tableView.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        if (this.getTableColumn() != null && this.getTableView() != null) {
            this.setSortPos(!this.getTableColumn().isSortable() ? -1 : this.getTableView().getSortOrder().indexOf(this.getTableColumn()));
            this.getTableView().getSortOrder().addListener(this.weakSortOrderListener);
        }
        if (this.getTableColumn() != null) {
            this.getTableColumn().visibleProperty().addListener(this.weakVisibleListener);
            this.getTableColumn().widthProperty().addListener(this.weakWidthListener);
        }
        this.sceneProperty().addListener(this.sceneListener);
    }

    protected TableView getTableView() {
        return this.table;
    }

    private double getSize() {
        return this.size == null ? 20.0 : this.size.doubleValue();
    }

    private DoubleProperty sizeProperty() {
        if (this.size == null) {
            this.size = new StyleableDoubleProperty(20.0){

                @Override
                public void set(double d) {
                    super.set(d <= 0.0 ? 20.0 : d);
                }

                @Override
                public Object getBean() {
                    return TableColumnHeader.this;
                }

                @Override
                public String getName() {
                    return "size";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SIZE;
                }
            };
        }
        return this.size;
    }

    NestedTableColumnHeader getNestedColumnHeader() {
        return this.nestedColumnHeader;
    }

    void setNestedColumnHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.nestedColumnHeader = nestedTableColumnHeader;
    }

    public TableColumn getTableColumn() {
        return this.column;
    }

    TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        this.tableHeaderRow = tableHeaderRow;
    }

    NestedTableColumnHeader getParentHeader() {
        return this.parentHeader;
    }

    void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.parentHeader = nestedTableColumnHeader;
    }

    void dispose() {
        if (this.table != null) {
            this.table.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
            this.table.getSortOrder().removeListener(this.weakSortOrderListener);
        }
        if (this.getTableColumn() != null) {
            this.getTableColumn().visibleProperty().removeListener(this.weakVisibleListener);
            this.getTableColumn().widthProperty().removeListener(this.weakWidthListener);
            this.getTableColumn().sortTypeProperty().removeListener(this.weakSortTypeListener);
        }
        this.sceneProperty().removeListener(this.sceneListener);
        this.label.textProperty().unbind();
        this.label.graphicProperty().unbind();
        this.idProperty().unbind();
        this.styleProperty().unbind();
    }

    private boolean isSortingEnabled() {
        return !PlatformUtil.isEmbedded();
    }

    private boolean isColumnReorderingEnabled() {
        return !PlatformUtil.isEmbedded() && this.getTableView().getVisibleLeafColumns().size() > 1;
    }

    private void initUI() {
        if (this.column == null) {
            return;
        }
        this.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                TableColumnHeader.this.getTableView().requestFocus();
                if (mouseEvent.isPrimaryButtonDown() && TableColumnHeader.this.isColumnReorderingEnabled()) {
                    TableColumnHeader.this.columnReorderingStarted(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown() && TableColumnHeader.this.isColumnReorderingEnabled()) {
                    TableColumnHeader.this.columnReordering(mouseEvent);
                }
                mouseEvent.consume();
            }
        });
        this.setOnContextMenuRequested((EventHandler<? super ContextMenuEvent>)new EventHandler<ContextMenuEvent>(){

            @Override
            public void handle(ContextMenuEvent contextMenuEvent) {
                ContextMenu contextMenu = TableColumnHeader.this.getTableColumn().getContextMenu();
                if (contextMenu != null) {
                    contextMenu.show(TableColumnHeader.this, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                    contextMenuEvent.consume();
                }
            }
        });
        this.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (MouseEvent.impl_getPopupTrigger(mouseEvent)) {
                    return;
                }
                ContextMenu contextMenu = TableColumnHeader.this.getTableColumn().getContextMenu();
                if (contextMenu != null && contextMenu.isShowing()) {
                    return;
                }
                if (TableColumnHeader.this.getTableHeaderRow().isReordering() && TableColumnHeader.this.isColumnReorderingEnabled()) {
                    TableColumnHeader.this.columnReorderingComplete(mouseEvent);
                } else {
                    TableColumnHeader.this.sortColumn(TableColumnHeader.this.getTableColumn(), mouseEvent.isShiftDown());
                }
                mouseEvent.consume();
            }
        });
        this.label = new Label();
        this.label.setAlignment(Pos.CENTER);
        this.label.textProperty().bind(this.column.textProperty());
        this.label.graphicProperty().bind(this.column.graphicProperty());
        if (this.isSortingEnabled()) {
            this.arrow = new StackPane();
            this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.arrow.setVisible(true);
            this.arrow.setRotate(this.column.getSortType() == TableColumn.SortType.ASCENDING ? 180.0 : 0.0);
            this.column.sortTypeProperty().addListener(this.weakSortTypeListener);
            this.updateSortGrid();
        }
    }

    private void setSortPos(int n) {
        this.sortPos = n;
        this.updateSortGrid();
    }

    private void updateSortGrid() {
        if (this instanceof NestedTableColumnHeader) {
            return;
        }
        this.getChildren().clear();
        this.getChildren().add(this.label);
        if (!this.isSortingEnabled()) {
            return;
        }
        boolean bl = this.isSortColumn = this.sortPos != -1;
        if (!this.isSortColumn) {
            return;
        }
        int n = this.getTableView().getSortOrder().size();
        boolean bl2 = this.sortPos <= 3 && n > 1;
        Node node = null;
        if (this.getTableColumn().getSortNode() != null) {
            node = this.getTableColumn().getSortNode();
            this.getChildren().add(node);
        } else {
            GridPane gridPane = new GridPane();
            node = gridPane;
            gridPane.setPadding(new Insets(0.0, 3.0, 0.0, 0.0));
            this.getChildren().add(gridPane);
            this.arrow.setVisible(this.isSortColumn);
            if (this.sortPos > 2) {
                if (this.sortOrderLabel == null) {
                    this.sortOrderLabel = new Label();
                    this.sortOrderLabel.getStyleClass().add("sort-order");
                }
                this.sortOrderLabel.setText("" + (this.sortPos + 1));
                this.sortOrderLabel.setVisible(n > 1);
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.NEVER);
                gridPane.add(this.sortOrderLabel, 2, 1);
            } else if (bl2) {
                if (this.sortOrderDots == null) {
                    this.sortOrderDots = new HBox(1.0);
                }
                int n2 = this.column.getSortType() == TableColumn.SortType.ASCENDING ? 1 : 2;
                int n3 = this.column.getSortType() == TableColumn.SortType.ASCENDING ? 2 : 1;
                gridPane.add(this.arrow, 1, n2);
                GridPane.setHalignment(this.arrow, HPos.CENTER);
                gridPane.add(this.sortOrderDots, 1, n3);
                this.updateSortOrderDots(this.sortPos);
            } else {
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.ALWAYS);
            }
        }
        this.sortArrow = node;
        if (this.sortArrow != null) {
            this.sortArrow.setVisible(this.isSortColumn);
        }
        this.requestLayout();
    }

    private void updateSortOrderDots(int n) {
        double d = this.arrow.prefWidth(-1.0);
        if (d == 0.0) {
            this.arrow.impl_processCSS(true);
            d = this.arrow.prefWidth(-1.0);
        }
        this.sortOrderDots.getChildren().clear();
        double d2 = d / 3.0;
        double d3 = d2 * 0.618033987;
        for (int i = 0; i <= n; ++i) {
            Rectangle rectangle = new Rectangle(d2, d3, Color.BLACK);
            this.sortOrderDots.getChildren().add(rectangle);
        }
        this.sortOrderDots.setPadding(new Insets(1.0, 0.0, 1.0, 0.0));
        this.sortOrderDots.setAlignment(Pos.TOP_CENTER);
        this.sortOrderDots.setMaxHeight(d3 + 2.0);
        this.sortOrderDots.setMaxWidth(d);
    }

    private void moveColumn(TableColumn tableColumn, int n) {
        if (tableColumn == null || n < 0) {
            return;
        }
        ObservableList observableList = tableColumn.getParentColumn() == null ? this.getTableView().getColumns() : tableColumn.getParentColumn().getColumns();
        int n2 = observableList.indexOf(tableColumn);
        if (n == n2) {
            return;
        }
        if (n >= observableList.size()) {
            n = observableList.size() - 1;
        }
        ArrayList arrayList = new ArrayList(observableList);
        arrayList.remove(tableColumn);
        arrayList.add(n, tableColumn);
        observableList.setAll(arrayList);
    }

    private void updateColumnIndex() {
        TableView tableView = this.getTableView();
        TableColumn tableColumn = this.getTableColumn();
        this.columnIndex = tableView == null || tableColumn == null ? -1 : tableView.getVisibleLeafIndex(tableColumn);
        boolean bl = this.isLastVisibleColumn;
        boolean bl2 = this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableView().getVisibleLeafColumns().size() - 1;
        if (bl != this.isLastVisibleColumn) {
            this.impl_pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE);
        }
    }

    private void sortColumn(TableColumn tableColumn, boolean bl) {
        if (!this.isSortingEnabled()) {
            return;
        }
        if (tableColumn == null || tableColumn.getColumns().size() != 0 || tableColumn.getComparator() == null || !tableColumn.isSortable()) {
            return;
        }
        if (bl) {
            if (!this.isSortColumn) {
                tableColumn.setSortType(TableColumn.SortType.ASCENDING);
                this.getTableView().getSortOrder().add(tableColumn);
            } else if (tableColumn.getSortType() == TableColumn.SortType.ASCENDING) {
                tableColumn.setSortType(TableColumn.SortType.DESCENDING);
            } else {
                int n = this.getTableView().getSortOrder().indexOf(tableColumn);
                if (n != -1) {
                    this.getTableView().getSortOrder().remove(n);
                }
            }
        } else if (this.isSortColumn && this.getTableView().getSortOrder().size() == 1) {
            if (tableColumn.getSortType() == TableColumn.SortType.ASCENDING) {
                tableColumn.setSortType(TableColumn.SortType.DESCENDING);
            } else {
                this.getTableView().getSortOrder().remove(tableColumn);
            }
        } else if (this.isSortColumn) {
            switch (tableColumn.getSortType()) {
                case ASCENDING: {
                    tableColumn.setSortType(TableColumn.SortType.DESCENDING);
                    break;
                }
                case DESCENDING: {
                    tableColumn.setSortType(TableColumn.SortType.ASCENDING);
                }
            }
            ArrayList arrayList = new ArrayList(this.getTableView().getSortOrder());
            arrayList.remove(tableColumn);
            arrayList.add(0, tableColumn);
            this.getTableView().getSortOrder().setAll(tableColumn);
        } else {
            tableColumn.setSortType(TableColumn.SortType.ASCENDING);
            this.getTableView().getSortOrder().setAll(tableColumn);
        }
    }

    protected void resizeToFit(TableColumn tableColumn, int n) {
        Node node;
        ObservableList observableList = this.getTableView().getItems();
        if (observableList == null || observableList.isEmpty()) {
            return;
        }
        Callback callback = tableColumn.getCellFactory();
        if (callback == null) {
            return;
        }
        TableCell tableCell = callback.call(tableColumn);
        if (tableCell == null) {
            return;
        }
        tableCell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double d = 10.0;
        Node node2 = node = tableCell.getSkin() == null ? null : tableCell.getSkin().getNode();
        if (node instanceof Region) {
            Region region = (Region)node;
            d = region.getInsets().getLeft() + region.getInsets().getRight();
        }
        int n2 = n == -1 ? observableList.size() : Math.min(observableList.size(), n);
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            tableCell.updateTableColumn(tableColumn);
            tableCell.updateTableView(this.getTableView());
            tableCell.updateIndex(i);
            if ((tableCell.getText() == null || tableCell.getText().isEmpty()) && tableCell.getGraphic() == null) continue;
            this.getChildren().add(tableCell);
            tableCell.impl_processCSS(false);
            d2 = Math.max(d2, tableCell.prefWidth(-1.0));
            this.getChildren().remove(tableCell);
        }
        tableColumn.impl_setWidth(d2 + d);
    }

    @Override
    protected void layoutChildren() {
        if (this.isSizeDirty) {
            this.resize(this.getTableColumn().getWidth(), this.getHeight());
            this.isSizeDirty = false;
        }
        double d = 0.0;
        double d2 = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d3 = this.getHeight() - this.getInsets().getTop() + this.getInsets().getBottom();
        double d4 = d2;
        if (this.arrow != null) {
            this.arrow.setMaxSize(this.arrow.prefWidth(-1.0), this.arrow.prefHeight(-1.0));
        }
        if (this.sortArrow != null && this.sortArrow.isVisible()) {
            d = this.sortArrow.prefWidth(-1.0);
            this.sortArrow.resize(d, this.sortArrow.prefHeight(-1.0));
            this.positionInArea(this.sortArrow, d4 -= d, this.getInsets().getTop(), d, d3, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.label != null) {
            double d5 = d2 - d;
            this.label.resizeRelocate(this.getInsets().getLeft(), 0.0, d5, this.getHeight());
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        if (this.getNestedColumnHeader() != null) {
            double d2 = this.getNestedColumnHeader().prefWidth(d);
            if (this.column != null) {
                this.column.impl_setWidth(d2);
            }
            return d2;
        }
        if (this.column != null && this.column.isVisible()) {
            return this.column.getWidth();
        }
        return 0.0;
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.label == null ? 0.0 : this.label.minHeight(d);
    }

    @Override
    protected double computePrefHeight(double d) {
        if (this.getTableColumn() == null) {
            return 0.0;
        }
        return Math.max(this.getSize(), this.label.prefHeight(-1.0));
    }

    private void columnReorderingStarted(MouseEvent mouseEvent) {
        this.dragOffset = mouseEvent.getX();
        this.getTableHeaderRow().setReorderingColumn(this.column);
        this.getTableHeaderRow().setReorderingRegion(this);
    }

    private void columnReordering(MouseEvent mouseEvent) {
        this.getTableHeaderRow().setReordering(true);
        TableColumnHeader tableColumnHeader = null;
        double d = this.getParentHeader().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX();
        double d2 = this.table.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX() - this.dragOffset;
        this.getTableHeaderRow().setDragHeaderX(d2);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this.newColumnPos = 0;
        for (TableColumnHeader tableColumnHeader2 : this.getParentHeader().getColumnHeaders()) {
            double d6 = tableColumnHeader2.prefWidth(-1.0);
            d5 += d6;
            d3 = tableColumnHeader2.getBoundsInParent().getMinX();
            d4 = d3 + d6;
            if (d >= d3 && d < d4) {
                tableColumnHeader = tableColumnHeader2;
                break;
            }
            ++this.newColumnPos;
        }
        if (tableColumnHeader == null) {
            this.newColumnPos = d > d5 ? this.getParentHeader().getColumns().size() - 1 : 0;
            return;
        }
        double d7 = d3 + (d4 - d3) / 2.0;
        boolean bl = d <= d7;
        int n = this.getIndex();
        this.newColumnPos += this.newColumnPos > n && bl ? -1 : (this.newColumnPos < n && !bl ? 1 : 0);
        double d8 = this.getTableHeaderRow().sceneToLocal(tableColumnHeader.localToScene(tableColumnHeader.getBoundsInLocal())).getMinX();
        if ((d8 += bl ? 0.0 : tableColumnHeader.getWidth()) >= -0.5 && d8 <= this.table.getWidth()) {
            this.getTableHeaderRow().getColumnReorderLine().setTranslateX(d8);
            this.getTableHeaderRow().getColumnReorderLine().setVisible(true);
        }
        this.getTableHeaderRow().setReordering(true);
    }

    private int getIndex() {
        ObservableList observableList = this.column.getParentColumn() == null ? this.getTableView().getColumns() : this.column.getParentColumn().getColumns();
        return observableList.indexOf(this.column);
    }

    protected void columnReorderingComplete(MouseEvent mouseEvent) {
        this.moveColumn(this.getTableColumn(), this.newColumnPos);
        this.getTableHeaderRow().getColumnReorderLine().setTranslateX(0.0);
        this.getTableHeaderRow().getColumnReorderLine().setLayoutX(0.0);
        this.newColumnPos = 0;
        this.getTableHeaderRow().setReordering(false);
        this.getTableHeaderRow().getColumnReorderLine().setVisible(false);
        this.getTableHeaderRow().setReorderingColumn(null);
        this.getTableHeaderRow().setReorderingRegion(null);
        this.dragOffset = 0.0;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TableColumnHeader.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TableColumnHeader, Number> SIZE = new StyleableProperty<TableColumnHeader, Number>("-fx-size", (StyleConverter)SizeConverter.getInstance(), (Number)20.0){

            @Override
            public boolean isSettable(TableColumnHeader tableColumnHeader) {
                return tableColumnHeader.size == null || !tableColumnHeader.size.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TableColumnHeader tableColumnHeader) {
                return tableColumnHeader.sizeProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(StackPane.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

