/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.builder.JavaFXFontBuilder;
import com.sun.javafx.fxml.builder.JavaFXImageBuilder;
import com.sun.javafx.fxml.builder.JavaFXSceneBuilder;
import com.sun.javafx.fxml.builder.URLBuilder;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilder;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.util.Builder;
import javafx.util.BuilderFactory;

public final class JavaFXBuilderFactory
implements BuilderFactory {
    private final JavaFXBuilder NO_BUILDER = new JavaFXBuilder();
    private final Map<Class<?>, JavaFXBuilder> builders = new HashMap();
    private final ClassLoader classLoader;
    private final boolean alwaysUseBuilders;

    public JavaFXBuilderFactory() {
        this(FXMLLoader.getDefaultClassLoader(), false);
    }

    public JavaFXBuilderFactory(boolean bl) {
        this(FXMLLoader.getDefaultClassLoader(), bl);
    }

    public JavaFXBuilderFactory(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public JavaFXBuilderFactory(ClassLoader classLoader, boolean bl) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        this.alwaysUseBuilders = bl;
    }

    @Override
    public Builder<?> getBuilder(Class<?> clazz) {
        Builder<Scene> builder;
        if (clazz == Scene.class) {
            builder = new JavaFXSceneBuilder();
        } else if (clazz == Font.class) {
            builder = new JavaFXFontBuilder();
        } else if (clazz == Image.class) {
            builder = new JavaFXImageBuilder();
        } else if (clazz == URL.class) {
            builder = new URLBuilder(this.classLoader);
        } else {
            Builder<Object> builder2 = null;
            JavaFXBuilder javaFXBuilder = this.builders.get(clazz);
            if (javaFXBuilder != this.NO_BUILDER) {
                if (javaFXBuilder == null) {
                    boolean bl;
                    try {
                        clazz.getConstructor(new Class[0]);
                        if (this.alwaysUseBuilders) {
                            throw new Exception();
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl || clazz == WebView.class) {
                        try {
                            javaFXBuilder = this.createTypeBuilder(clazz);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    this.builders.put(clazz, javaFXBuilder == null ? this.NO_BUILDER : javaFXBuilder);
                }
                if (javaFXBuilder != null) {
                    builder2 = javaFXBuilder.createBuilder();
                }
            }
            builder = builder2;
        }
        return builder;
    }

    JavaFXBuilder createTypeBuilder(Class<?> clazz) throws ClassNotFoundException {
        JavaFXBuilder javaFXBuilder = null;
        Class<?> clazz2 = this.classLoader.loadClass(clazz.getName() + "Builder");
        try {
            javaFXBuilder = new JavaFXBuilder(clazz2);
        }
        catch (Exception exception) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.WARNING, "Failed to instantiate JavaFXBuilder for " + clazz2, exception);
        }
        if (!this.alwaysUseBuilders) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.FINER, "class {0} requires a builder.", clazz);
        }
        return javaFXBuilder;
    }
}

