/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetAddressImpl;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

class Inet4AddressImpl
implements InetAddressImpl {
    private InetAddress anyLocalAddress;
    private InetAddress loopbackAddress;

    Inet4AddressImpl() {
    }

    @Override
    public native String getLocalHostName() throws UnknownHostException;

    @Override
    public native InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    @Override
    public native String getHostByAddr(byte[] var1) throws UnknownHostException;

    private native boolean isReachable0(byte[] var1, int var2, byte[] var3, int var4) throws IOException;

    @Override
    public synchronized InetAddress anyLocalAddress() {
        if (this.anyLocalAddress == null) {
            this.anyLocalAddress = new Inet4Address();
            this.anyLocalAddress.hostName = "0.0.0.0";
        }
        return this.anyLocalAddress;
    }

    @Override
    public synchronized InetAddress loopbackAddress() {
        if (this.loopbackAddress == null) {
            byte[] byArray = new byte[]{127, 0, 0, 1};
            this.loopbackAddress = new Inet4Address("localhost", byArray);
        }
        return this.loopbackAddress;
    }

    @Override
    public boolean isReachable(InetAddress inetAddress, int n, NetworkInterface networkInterface, int n2) throws IOException {
        byte[] byArray = null;
        if (networkInterface != null) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            InetAddress inetAddress2 = null;
            while (!(inetAddress2 instanceof Inet4Address) && enumeration.hasMoreElements()) {
                inetAddress2 = enumeration.nextElement();
            }
            if (inetAddress2 instanceof Inet4Address) {
                byArray = inetAddress2.getAddress();
            }
        }
        return this.isReachable0(inetAddress.getAddress(), n, byArray, n2);
    }
}

