-- NA_YoRHa_Function
-- Author: Cons
-- DateCreated: 3/13/2018 9:27:43 AM
--------------------------------------------------------------
-- INCLUDES
--------------------------------------------------------------
include("Civ6Common.lua")

--------------------------------------------------------------
-- UTILITY
--------------------------------------------------------------
function Cons_HasCivilizationTrait(civilizationType, traitType)
	for row in GameInfo.CivilizationTraits() do
		if (row.CivilizationType == civilizationType and row.TraitType == traitType) then return true end
	end
	return false
end

function Cons_HasLeaderTrait(leaderType, traitType)
	for row in GameInfo.LeaderTraits() do
		if (row.LeaderType == leaderType and row.TraitType == traitType) then return true end
	end
	return false
end

print("YoRHa Started")
--------------------------------------------------------------
-- 2B FUNCTIONS
--------------------------------------------------------------
local trait2B = "TRAIT_LEADER_CONS_2B"

function Cons_2BProductionUnitKilled(KilleePlayerID, KilleeUnitID, KillerPlayerID)
	local killeePlayer = Players[KilleePlayerID]
	local killeePlayerConfig = PlayerConfigurations[KilleePlayerID]
	local killeeUnit:table = killeePlayer:GetUnits():FindID(KilleeUnitID)
	local killerPlayer = Players[KillerPlayerID]
	local killerPlayerConfig = nil
	local killerLeaderType = nil
	if (killerPlayer:IsMajor() == true) then
		killerPlayerConfig = PlayerConfigurations[KillerPlayerID]
		killerLeaderType = killerPlayerConfig:GetLeaderTypeName()
	end
	if Cons_HasLeaderTrait(killerLeaderType, trait2B) then
		--print("killeePlayer" .. KilleePlayerID)
		--print("killeeUnit" .. KilleeUnitID)
		--print("Killee Unit Strength" .. GameInfo.Units[killeeUnit:GetType()].Combat)
		if killeeUnit ~= nil then
			local killerPlayerCities:table = killerPlayer:GetCities();
			local killeeUnitCombat = GameInfo.Units[killeeUnit:GetType()].Combat
			local killeeUnitRangedCombat = GameInfo.Units[killeeUnit:GetType()].RangedCombat
			if killeeUnitCombat > 0 or killeeUnitRangedCombat > 0 then
				local HighestkilleeUnitCombat = math.max(killeeUnitCombat, killeeUnitRangedCombat)
				for _, killerPlayerCity in killerPlayerCities:Members() do
					if (killerPlayerCity ~= nil) then
						killerPlayerCity:GetBuildQueue():AddProgress(HighestkilleeUnitCombat * 0.2);
					end
				end
			end
		end
	end
end

Events.UnitKilledInCombat.Add(Cons_2BProductionUnitKilled)

--------------------------------------------------------------
-- AI FUNCTIONS
--------------------------------------------------------------
local traitYoRHa = "TRAIT_CIVILIZATION_CONS_NA_YORHA"
local AIYoRHaBonus = 1

function Cons_AIYoRHaIncreasePopAuto(playerID)
	local player = Players[playerID]
	local playerConfig = PlayerConfigurations[playerID]
	local civilizationType = playerConfig:GetCivilizationTypeName()
	if Cons_HasCivilizationTrait(civilizationType, traitYoRHa) then
		local currentTurn = Game.GetCurrentGameTurn()	
		local gameSpeed = GameConfiguration.GetGameSpeedType();
		local speedCostMultiplier = GameInfo.GameSpeeds[gameSpeed].CostMultiplier;
		--print("Current Turn : " .. currentTurn)
		--print("Current Era : " .. player:GetEras():GetEra())
		if (not player:IsHuman()) then
			if currentTurn > 1 then
				if math.floor(currentTurn % (15 * (speedCostMultiplier / 100))) == 0 then
					local playerCities:table = player:GetCities();
					for _, playerCity in playerCities:Members() do
						if (playerCity ~= nil) then
							if (player:GetEras():GetEra() < 4) and (playerCity:GetPopulation() < 15) then
								playerCity:ChangePopulation(1)
							elseif (player:GetEras():GetEra() >= 4) and (playerCity:GetPopulation() < 21) then
								playerCity:ChangePopulation(1)
							end
						end
					end
				end
			end
		end
	end
end

if AIYoRHaBonus == 1 then
	GameEvents.PlayerTurnStarted.Add(Cons_AIYoRHaIncreasePopAuto)
end