PrefabFiles = {
	"wenyu",
	"woodensword",
	"woodensword_activated",
	"bagualight",
	"kansnow",
	"zhenelec",
	"zhenelecball",
	"duipoison",
	"duipoisoncloud",
	"xunwind",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wenyu.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wenyu.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wenyu.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wenyu.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/wenyu_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wenyu_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wenyu.tex" ),
    Asset( "ATLAS", "bigportraits/wenyu.xml" ),
	
	Asset( "IMAGE", "images/map_icons/wenyu.tex" ),
	Asset( "ATLAS", "images/map_icons/wenyu.xml" ),

}

local require = GLOBAL.require

GLOBAL.STRINGS.TABS.TAOISM = "Taoism"

GLOBAL.STRINGS.NAMES.WOODENSWORD = "Wooden Sword"
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED = "Wooden Sword"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED = "Activate the wooden sword!"

GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_QIAN = "Magic of Sky"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_QIAN = "Sharpen the sword."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_KUN = "Magic of Earth"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_KUN = "Recover the sanity."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_XUN = "Magic of Wind"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_XUN = "Increase moving speed."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_ZHEN = "Magic of Thunder"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_ZHEN = "Extra electric damage."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_LI = "Magic of Flame"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_LI = "Ignite target."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_KAN = "Magic of Ice"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_KAN = "Freeze target."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_GEN = "Magic of Mountain"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_GEN = "Multiple attack."
GLOBAL.STRINGS.NAMES.WOODENSWORD_ACTIVATED_DUI = "Magic of Swamp"
GLOBAL.STRINGS.RECIPE_DESC.WOODENSWORD_ACTIVATED_DUI = "Poison attack."

GLOBAL.STRINGS.NAMES.DUIPOISONCLOUD = "Poison Cloud"
GLOBAL.STRINGS.NAMES.XUNWIND = "Tornado"

GLOBAL.STRINGS.CHARACTER_TITLES.wenyu = "The Unskilled Taoist"
GLOBAL.STRINGS.CHARACTER_NAMES.wenyu = "Wenyu"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.wenyu = "*Has a wooden sword\n*Is less afraid of monsters and their meats\n*Follows Taoistic disciplines"
GLOBAL.STRINGS.CHARACTER_QUOTES.wenyu = "\"I need to practice and practice everyday.\""

GLOBAL.STRINGS.CHARACTERS.WENYU = require "speech_wenyu"

table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "wenyu")

AddMinimapAtlas("images/map_icons/wenyu.xml")
AddModCharacter("wenyu")

GLOBAL.STRINGS.ACTIONS.ABSORB = {
	GENERIC = "Absorb",
	FIRE = "Absorb Fire",
}
GLOBAL.ACTIONS.ABSORB = (function(v)
	local function findabsorber(act, default, cb)
		local doer = act.doer
		local target = act.target
		if doer.components.inventory then
			local item = doer.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS)
			if item and item.components.absorber and item.components.absorber:CanAbsorb(target) then
				return cb(item.components.absorber, default)
			end
		end
		return default
	end
	v.id = "ABSORB"
	v.str = GLOBAL.STRINGS.ACTIONS.ABSORB
	v.strfn = function(act)
		return findabsorber(act, v.str, function(absorber, default)
			return absorber.absorbstr or default
		end)
	end
	v.fn = function(act)
		return findabsorber(act, false, function(absorber, default)
			absorber:DoAbsorb(act.doer, act.target)
			return true
		end)
	end
	return v
end)(GLOBAL.Action(0, false, false, 2))

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(GLOBAL.ACTIONS.ABSORB, "absorb"))
AddStategraphState("wilson", GLOBAL.State({
        name = "absorb",
        tags = {"doing", "busy", "canrotate"},
        onenter = function(inst)
            inst.AnimState:PlayAnimation("atk")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
        end,
        timeline = 
        {
            GLOBAL.TimeEvent(8*GLOBAL.FRAMES, function(inst) inst:PerformBufferedAction() end),
        },
        events = {
            GLOBAL.EventHandler("animover", function(inst)
                inst.sg:GoToState("idle") 
            end ),
        },
    }))
