local Absorber = Class(function(self, inst)
	self.inst = inst
	self.absorbstr = nil
	self.canabsorb = nil
	self.onabsorb = nil
end)

function Absorber:CollectEquippedActions(doer, target, actions, right)
	if not right and self:CanAbsorb(target) then
		table.insert(actions, ACTIONS.ABSORB)
	end
end

function Absorber:DoAbsorb(doer, target)
	if self.onabsorb then
		self.onabsorb(doer, target)
	end
end

function Absorber:CanAbsorb(target)
	return self.canabsorb and self.canabsorb(target)
end

return Absorber
