local ATTACK =
{
	DEFAULT = 40.5,
	
	qian = 68,
	kun = 52.5,
	zhen = 52.5,
}

local DAPERNESS =
{
	DEFAULT = 0,
	
	kun = TUNING.DAPPERNESS_LARGE,
	dui = TUNING.DAPPERNESS_TINY,
}

local LIGHT =
{
	DEFAULT = nil,
	
	qian = {order=7, r=255, g=255, b=255},
	zhen = {order=5, r=60, g=255, b=255},
	li = {order=1, r=255, g=0, b=0},
	dui = {order=3, r=143, g=25, b=164},
}

local SPEED = 
{
	DEFAULT = 1,
	xun = 1.3,
}

if IsDLCEnabled and IsDLCEnabled(CAPY_DLC) then
	SPEED = 
	{
		DEFAULT = 0,
		xun = 0.3,
	}
end

local Bagua = Class(function(self, inst)
	self.inst = inst
	self.enabled = {}
	self.effects = {}
	
	self:ResetCurrent()
	
	self.onupdatefn = nil
	self.onturnonlightfn = nil
	self.onturnofflightfn = nil
	
	inst:ListenForEvent("daytime", function() self:OnDay() end, GetWorld())
end)

function Bagua:OnSave()
    return 
	{
		enabled = self.enabled,
        effects = self.effects,
	}
end

function Bagua:OnLoad(data)
	if data then
		if data.enabled then
			self.enabled = data.enabled
		end
		if data.effects then
			self.effects = data.effects
		end
	end
	self:UpdateEffect()
end

function Bagua:OnDay()
	local hasEffect = false
	for k,v in pairs(self.effects) do
		if v then
			self.effects[k] = self.effects[k] - 1
		end
		if v == 1 then
			self.effects[k] = nil
		else
			hasEffect = true
		end
	end
	if not hasEffect then
		self:SetRandomDailyEffect()
	end
	self:UpdateEffect()
end

local function dump(tb)
--	print("{")
--	for k,v in pairs(tb) do
--		print(tostring(k).."="..tostring(v))
--	end
--	print(")")
end

function Bagua:OnEquip(owner)
	dump(self.enabled)
	dump(self.effects)
	
	if self.onturnonlightfn then
		self.onturnonlightfn(self.inst, self.current_light)
	end
end

function Bagua:OnUnequip(owner)
	if self.onturnofflightfn then
		self.onturnofflightfn(self.inst)
	end
end

function Bagua:OnDrop()
	if self.onturnofflightfn then
		self.onturnofflightfn(self.inst)
	end
end

function Bagua:ResetCurrent()
	self.current_daperness = DAPERNESS.DEFAULT
	self.current_light = LIGHT.DEFAULT
	self.current_status = nil
	self.current_speedmult = SPEED.DEFAULT
	self.current_attack = ATTACK.DEFAULT
end

function Bagua:GetAllEffects()
	return self.effects
end

function Bagua:UpdateEffect()
	local effectCount = 0
	
	self:ResetCurrent()
	
	for k,v in pairs(self:GetAllEffects()) do
		if DAPERNESS[k] and self.current_daperness < DAPERNESS[k] then
			self.current_daperness = DAPERNESS[k]
		end
		if LIGHT[k] and (not self.current_light or self.current_light.order < LIGHT[k].order) then
			self.current_light = LIGHT[k]
		end
		if ATTACK[k] and self.current_attack < ATTACK[k] then
			self.current_attack = ATTACK[k]
		end
		if SPEED[k] and self.current_speedmult < SPEED[k] then
			self.current_speedmult = SPEED[k]
		end
		effectCount = effectCount + 1
		self.current_status = k
	end
	
	if effectCount > 1 then
		self.current_status = "MIXED"
	end

	if self.onupdatefn then
		self.onupdatefn(self.inst)
	end
end

function Bagua:SetRandomDailyEffect()
	local size = 0
	local effectcount = 1
	for k,v in pairs(self.enabled) do
		size = size + 1
	end
	if size == 0 then
		return
	end
	if size ~= 8 then
		size = size + 1
	else
		effectcount = 2
	end
	while effectcount > 0 do
		local i = size
		for k,v in pairs(self.enabled) do
			if math.random() < 1 / i and not self.effects[k] then
				self.effects[k] = 1
				break
			end
			i = i - 1
		end
		effectcount = effectcount - 1
	end
end

function Bagua:ActivateEffect(name)
	self.enabled[name] = true
	if self.effects[name] then
		self.effects[name] = self.effects[name] + 1
	else
		self.effects[name] = 1
	end
	self:UpdateEffect()
end

function Bagua:SetOnUpdateFn(func)
	self.onupdatefn = func
end

function Bagua:SetOnTurnOnLight(func)
	self.onturnonlightfn = func
end

function Bagua:SetOnTurnOffLight(func)
	self.onturnofflightfn = func
end

function Bagua:HasEffect(name)
	return self.effects[name]
end

function Bagua:GetDaperness()
	return self.current_daperness
end

function Bagua:GetStatus()
	return self.current_status
end

function Bagua:GetAttack()
	return self.current_attack
end

function Bagua:GetSpeedMult()
	return self.current_speedmult
end

function Bagua:GetLight()
	return self.current_light
end

return Bagua