local DuiPoison = Class(function(self, inst)
	self.inst = inst
	self.poisonpersec = 3
	self.target = nil
	
	self.inst:StartUpdatingComponent(self)
end)

function DuiPoison:OnSave()
    return 
	{
		pps = self.poisonpersec,
		target = self.target and self.target.GUID,
	},
	{
		self.target and self.target.GUID
	}
end

function DuiPoison:OnLoad(data)
	if data then
		self.poisonpersec = data.pps or self.poisonpersec
	end
end

function DuiPoison:LoadPostPass(newents, data)
	if data then
		self.target = data.target and newents[data.target] and newents[data.target].entity
	end
end

function DuiPoison:OnUpdate(dt)
	if self.target and self.target.components.health then
		local pos = self.target:GetPosition()
		pos.y = pos.y + self.target.Physics:GetHeight()
		self.inst.Transform:SetPosition(pos:Get())
		
		local health = self.target.components.health
		if health:IsDead() then
			self.inst:Remove()
		else
			health:DoDelta(-dt * self.poisonpersec, 0, "duipoison")
		end
	else
		self.inst:Remove()
	end
end

return DuiPoison
