local LimitedLife = Class(function(self, inst)
	self.inst = inst
	self.life = 10
	self.inst:StartUpdatingComponent(self)
end)

function LimitedLife:OnSave()
    return {life = self.life}
end

function LimitedLife:OnLoad(data)
	if data then
		self.life = data.life or self.life
	end
end

function LimitedLife:OnUpdate(dt)
	self.life = self.life - dt
	if self.life <= 0 then
		self.inst:Remove()
	end
end

return LimitedLife