local texture = "fx/frostbreath.tex"
local shader = "shaders/particle.ksh"
local colour_envelope_name = "duipoisoncolourenvelope"
local scale_envelope_name = "duipoisonscaleenvelope"

local assets =
{
	Asset( "IMAGE", texture ),
	Asset( "SHADER", shader ),
}

local max_scale = .7

local function IntColour( r, g, b, a )
	return { r / 255.0, g / 255.0, b / 255.0, a / 255.0 }
end

local init = false
local function InitEnvelope()
	if EnvelopeManager and not init then
		init = true
		EnvelopeManager:AddColourEnvelope(
			colour_envelope_name,
			{	{ 0,	IntColour( 143, 25, 164, 200 ) },
				{ 1,	IntColour( 143, 25, 164, 200 ) },
			} )

		EnvelopeManager:AddVector2Envelope(
			scale_envelope_name,
			{
				{ 0,	{ max_scale, max_scale } },
				{ 1,	{ max_scale * 0.5, max_scale * 0.5 } },
			} )
	end
end

local max_lifetime = 2
--local ground_height = 0.1

local function fn(Sim)
	local inst = CreateEntity()
	inst:AddTag("FX")
	local trans = inst.entity:AddTransform()
	local emitter = inst.entity:AddParticleEmitter()

	InitEnvelope()

	emitter:SetRenderResources( texture, shader )
	emitter:SetMaxNumParticles( 64 )
	emitter:SetMaxLifetime( max_lifetime )
	emitter:SetColourEnvelope( colour_envelope_name )
	emitter:SetScaleEnvelope( scale_envelope_name );
	emitter:SetBlendMode( BLENDMODE.Additive )
	emitter:EnableBloomPass( true )
	emitter:SetUVFrameSize( 1.0, 1.0 )

    inst.persists = false
    
	-----------------------------------------------------
	local tick_time = TheSim:GetTickTime()

	local desired_particles_per_second = 3
	local particles_per_tick = desired_particles_per_second * tick_time

	local emitter = inst.ParticleEmitter

	local num_particles_to_emit = 1

	local emit_fn = function()
		local vx, vy, vz = 0.01 * UnitRand(), 0.015 + 0.005 * UnitRand(), 0.01 * UnitRand()
		local lifetime = max_lifetime * ( 0.9 + UnitRand() * 0.1 )
		local px, py, pz

		px, py, pz = math.random() * 1.4 - 0.7, math.random() * 2 - 1, 0

		local u_offset = 0
		local v_offset = 0

		emitter:AddParticleUV(
			lifetime,			-- lifetime
			px, py, pz,			-- position
			vx, vy, vz,			-- velocity
			u_offset, v_offset	-- uv offset
		)
	end
	
	local updateFunc = function()
		while num_particles_to_emit > 1 do
			emit_fn( emitter )
			num_particles_to_emit = num_particles_to_emit - 1
		end

		num_particles_to_emit = num_particles_to_emit + particles_per_tick
	end

	EmitterManager:AddEmitter( inst, nil, updateFunc )
    
    return inst
end

return Prefab( "common/fx/duipoison", fn, assets) 
 
