
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
	Asset( "ANIM", "anim/shadow_hands.zip" ),
	Asset( "SOUND", "sound/sfx.fsb" ),
	Asset( "SOUND", "sound/wilson.fsb" ),
	Asset( "ANIM", "anim/beard.zip" ),

	Asset( "ANIM", "anim/wenyu.zip" ),
	
	Asset("IMAGE", "images/hud/taiji.tex"),
	Asset("ATLAS", "images/hud/taiji.xml"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_qian.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_qian.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_kun.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_kun.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_gen.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_gen.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_dui.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_dui.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_xun.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_xun.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_zhen.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_zhen.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_li.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_li.tex"),
    Asset("ATLAS", "images/inventoryimages/woodensword_activated_kan.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated_kan.tex"),
}

local prefabs = {
	"woodensword",
}

local start_inv = {
	"woodensword",
}

local function isInnocent(victim)
	return (victim:HasTag("animal") or victim:HasTag("bird") or victim:HasTag("insect")) and
		not (victim:HasTag("killer") or victim:HasTag("rocky") or victim:HasTag("tallbird"))
end

local function initRecipesCommon(inst, tab)
	local wsa = Recipe("woodensword_activated", 
		{
			Ingredient("woodensword", 1, "images/inventoryimages/woodensword.xml"),
			Ingredient("papyrus", 1),
			Ingredient("nitre", 2)
		},
		tab,
		TECH.NONE
		)
	wsa.atlas = "images/inventoryimages/woodensword_activated.xml"
	wsa.image = "woodensword_activated.tex"
	wsa.sortkey = 50
	
	local recipe = nil

	recipe = Recipe("woodensword_activated_kun", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("nightmarefuel", 1),
		},
		tab,
		TECH.MAGIC_THREE
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_kun.xml"
	recipe.sortkey = 101
	
	recipe = Recipe("woodensword_activated_li", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("redgem", 1),
		},
		tab,
		TECH.NONE
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_li.xml"
	recipe.sortkey = 104
	
	recipe = Recipe("woodensword_activated_kan", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("bluegem", 1),
		},
		tab,
		TECH.NONE
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_kan.xml"
	recipe.sortkey = 105
	
	recipe = Recipe("woodensword_activated_gen", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("purplegem", 1),
		},
		tab,
		TECH.MAGIC_THREE
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_gen.xml"
	recipe.sortkey = 106
end

local function initRecipesOld(inst, tab)
	local recipe = nil
	
	recipe = Recipe("woodensword_activated_qian", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("thulecite", 1),
		},
		tab,
		TECH.MAGIC_THREE
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_qian.xml"
	recipe.sortkey = 100

	recipe = Recipe("woodensword_activated_zhen", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("wormlight", 1),
		},
		tab,
		TECH.MAGIC_TWO
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_zhen.xml"
	recipe.sortkey = 102
	
	recipe = Recipe("woodensword_activated_xun", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("greengem", 1),
		},
		tab,
		TECH.MAGIC_TWO
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_xun.xml"
	recipe.sortkey = 103
	
	recipe = Recipe("woodensword_activated_dui", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("tentaclespots", 2),
		},
		tab,
		TECH.MAGIC_TWO
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_dui.xml"
	recipe.sortkey = 107
end

local function initRecipesSW(inst, tab)
	local recipe = nil
	
	recipe = Recipe("woodensword_activated_qian", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("obsidian", 6),
		},
		tab,
		TECH.MAGIC_THREE,
		RECIPE_GAME_TYPE.SHIPWRECKED
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_qian.xml"
	recipe.sortkey = 100

	recipe = Recipe("woodensword_activated_zhen", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("jellyfish", 3),
		},
		tab,
		TECH.MAGIC_TWO,
		RECIPE_GAME_TYPE.SHIPWRECKED
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_zhen.xml"
	recipe.sortkey = 102
	
	recipe = Recipe("woodensword_activated_xun", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("palmleaf", 8),
		},
		tab,
		TECH.MAGIC_THREE,
		RECIPE_GAME_TYPE.SHIPWRECKED
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_xun.xml"
	recipe.sortkey = 103
	
	recipe = Recipe("woodensword_activated_dui", 
		{
			Ingredient("woodensword_activated", 1, "images/inventoryimages/woodensword_activated.xml"),
			Ingredient("venomgland", 4),
		},
		tab,
		TECH.MAGIC_TWO,
		RECIPE_GAME_TYPE.SHIPWRECKED
		)
	recipe.product = "woodensword_activated"
	recipe.atlas = "images/inventoryimages/woodensword_activated_dui.xml"
	recipe.sortkey = 107
end

local function initRecipes(inst)
	local tab = {str="TAOISM", sort=999, icon_atlas="images/hud/taiji.xml", icon="taiji.tex"}
	inst.components.builder:AddRecipeTab(tab)
	
	initRecipesCommon(inst, tab)
	initRecipesOld(inst, tab)
	if IsDLCEnabled and IsDLCEnabled(CAPY_DLC) then
		initRecipesSW(inst, tab)
	end
end

local forbiddenfoods = (function(data)
	local result = {}
	for k,v in pairs(data) do
		result[v] = true
	end
	return result
end)({
	-- old and giant fish
	"fish", "eel", "fish_cooked", "eel_cooked",
	-- sw fish
	"tropical_fish",
	"fish_raw", "fish_med", "fish_med_cooked", "swordfish", "shark_fin",
	"fish_raw_small",
	-- old and giant cooked fish
	"fishsticks", "fishtacos", "unagi",
	-- sw cooked fish
	"californiaroll", "seafoodgumbo", "ceviche", "surfnturf",
	-- bird
	"drumstick", "drumstick_cooked", "turkeydinner",
})

function WenyuCanEatFn(inst, food)
	return not forbiddenfoods[food.prefab]
end

local fn = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wilson"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "wenyu.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(125)
	inst.components.sanity:SetMax(225)
	
	-- Is less afraid of monsters
	inst.components.sanity.neg_aura_mult = 0.5
	
	-- Start items
	-- Since the item can be used, no need to guarantee it.
	-- inst.components.inventory:GuaranteeItems(start_inv)
	
	-- Is less afraid of monster meats
	inst:ListenForEvent("oneat", function(inst, data)
		local food = data.food
		if (food.prefab == "monstermeat" or food.prefab == "cookedmonstermeat" or food.prefab == "monstermeat_dried") and
				inst.components.sanity.current > 0 then
			inst.components.sanity:DoDelta(-0.5 * food.components.edible:GetSanity(inst))
		end
	end)
	
	-- Doesn't eat fish
	inst.components.eater.foodprefs = {"MEAT", "VEGGIE", "INSECT", "SEEDS"}
	inst.components.eater:SetCanEatTestFn(WenyuCanEatFn)
	
	-- Doesn't kill animals
	inst:ListenForEvent("killed", function(inst, data)
		local victim = data.victim
		if isInnocent(victim) then
			inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_TAOISTICDISCIPLINES", "KILL"))
			inst.components.sanity:DoDelta(-15)
		end
	end)
	inst:ListenForEvent("onattackother", function(inst, data)
		local target = data.target
		if isInnocent(target) then
			inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_TAOISTICDISCIPLINES", "ATTACK"))
			inst.components.sanity:DoDelta(-5)
		end
	end)
	
	-- Recipes
	local savedbagua = nil
	initRecipes(inst)
	inst:ListenForEvent("makerecipe", function(inst, data)
		local recipe = data.recipe
		if recipe.name:sub(1, 22) ~= "woodensword_activated_" then
			return
		end
		local inventory = inst.components.inventory
		for k = 1,inventory.maxslots do
			local v = inventory.itemslots[k]
			if v and v.prefab == "woodensword_activated" then
				savedbagua = v.components.bagua:OnSave()
				break
			end
		end
	end)
	inst:ListenForEvent("builditem", function(inst, data)
		local item = data.item
		local recipe = data.recipe
		if recipe.name:sub(1, 22) ~= "woodensword_activated_" then
			return
		end
		if savedbagua then item.components.bagua:OnLoad(savedbagua) end
		savedbagua = nil
		item.components.bagua:ActivateEffect(recipe.name:sub(23))
	end)
end

return MakePlayerCharacter("wenyu", prefabs, assets, fn, start_inv)
