local assets =
{ 
    Asset("ANIM", "anim/woodensword.zip"),
    Asset("ANIM", "anim/swap_woodensword.zip"), 

    Asset("ATLAS", "images/inventoryimages/woodensword.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword.tex"),
}

local prefabs =
{
}

local function OnEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_woodensword", "woodensword")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function fn(colour)

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
    inst:AddTag("sharp")
    
    anim:SetBank("woodensword")
    anim:SetBuild("woodensword")
    anim:PlayAnimation("idle")
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "woodensword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/woodensword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
    inst:AddComponent("inspectable")

    return inst
end

return  Prefab("common/inventory/woodensword", fn, assets, prefabs)