local assets =
{ 
    Asset("ANIM", "anim/woodensword.zip"),
    Asset("ANIM", "anim/swap_woodensword.zip"),
    Asset("ANIM", "anim/swap_woodensword_qian.zip"),
    Asset("ANIM", "anim/swap_woodensword_kun.zip"),
    Asset("ANIM", "anim/swap_woodensword_xun.zip"),

    Asset("ATLAS", "images/inventoryimages/woodensword_activated.xml"),
    Asset("IMAGE", "images/inventoryimages/woodensword_activated.tex"),
}

local prefabs =
{
	"bagualight",
	"kansnow",
	"zhenelec",
	"zhenelecball",
	"duipoison",
	"duipoisoncloud",
	"xunwind",
}

local FX =
{
	li = {name="torchfire", xoff=-8, yoff=-200},
	kan = {name="kansnow", xoff=-8, yoff=-120},
	zhen = {name="zhenelec", xoff=-8, yoff=-120},
	dui = {name="duipoison", xoff=-8, yoff=-120},
}

local FX_ANIM =
{
	qian = {atlas="swap_woodensword_qian", name="woodensword_qian", order=8},
	kun = {atlas="swap_woodensword_kun", name="woodensword_kun", order=7},
	xun = {atlas="swap_woodensword_xun", name="woodensword_xun", order=6},
}

local function OnHideEffects(inst)
	if inst.owner then
		inst.owner.AnimState:OverrideSymbol("swap_object", "swap_woodensword", "woodensword")
	end
	
	if inst.baguaLight then
		inst.baguaLight:Remove()
		inst.baguaLight = nil
	end
	
	for k,v in pairs(inst.baguaEffects) do
		v:Remove()
		inst.baguaEffects[k] = nil
	end
end

local function OnEquip(inst, owner)
	inst.owner = owner
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	OnHideEffects(inst)
	inst.components.bagua:OnEquip(owner)
end

local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
	inst.components.bagua:OnUnequip(owner)
	inst.owner = nil
end

local function OnDrop(inst)
	inst.components.bagua:OnDrop()
	inst.owner = nil
end

local function OnAttack(inst, attacker, target)
	local bagua = inst.components.bagua
	
	if bagua:HasEffect("li") and target.components.burnable then
		if math.random() < target.components.burnable.flammability then
			target.components.burnable:Ignite()
		end
	end
	
	if bagua:HasEffect("kan") and target.components.freezable then
        target.components.freezable:AddColdness(1)
        target.components.freezable:SpawnShatterFX()
	end
	
	if bagua:HasEffect("gen") and not inst.ingenattack then
		inst.ingenattack = true
		local pos = target:GetPosition()
		local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 3, {"monster"}, {"character", "dead"})
		for k,v in pairs(ents) do
			if v ~= target and v.components.combat then
				local damage = attacker.components.combat:CalcDamage(v, inst)
				v.components.combat:GetAttacked(attacker, damage, inst)
				OnAttack(inst, attacker, v)
			end
		end
		inst.ingenattack = false
	end
	
	if bagua:HasEffect("zhen") then
		local fx = SpawnPrefab("zhenelecball")
		local pos = target:GetPosition()
		local h = target.Physics:GetHeight()
		pos.y = pos.y + h
		fx.Transform:SetPosition(pos:Get())
		fx.maxradius = math.max(target.Physics:GetRadius(), h) * 1.3
	end
	
	if bagua:HasEffect("dui") then
		local fx = SpawnPrefab("duipoisoncloud")
		fx.components.duipoison.target = target
	end
	
	if bagua:HasEffect("xun") and not inst.ingenattack then
		local fx = SpawnPrefab("xunwind")
		local pos = attacker:GetPosition()
		local facing = math.rad(attacker.Transform:GetRotation())
		local distance = 0.5
		local ticktime = 0.05
		fx:DoPeriodicTask(ticktime, function()
			distance = distance + ticktime * 2
			fx.Transform:SetPosition(pos.x + distance * math.cos(facing), pos.y + 0, pos.z - distance * math.sin(facing))
		end)
	end
end

local function OnShowEffects(inst, lightmeta)
	if not inst.owner then
		return
	end
	
	if lightmeta then
		if not inst.baguaLight then
			inst.baguaLight = SpawnPrefab("bagualight")
			inst.baguaLight.entity:AddFollower():FollowSymbol(inst.owner.GUID, "swap_object", 0, -100, 1)
		end
		local light = inst.baguaLight.Light
		light:Enable(true)
		light:SetColour(lightmeta.r/255, lightmeta.g/255, lightmeta.b/255)
	elseif inst.baguaLight then
		inst.baguaLight:Remove()
		inst.baguaLight = nil
	end
	
	local order = 0
	
	for k,v in pairs(inst.components.bagua:GetAllEffects()) do
		if FX[k] then
			local fx = SpawnPrefab(FX[k].name)
			if fx.Light then fx.Light:Enable(false) end
			local follower = fx.entity:AddFollower()
			follower:FollowSymbol(inst.owner.GUID, "swap_object", FX[k].xoff, FX[k].yoff, 1)
			inst.baguaEffects[k] = fx
		end
		if FX_ANIM[k] and FX_ANIM[k].order > order then
			order = FX_ANIM[k].order
			inst.owner.AnimState:OverrideSymbol("swap_object", FX_ANIM[k].atlas, FX_ANIM[k].name)
		end
	end
end

local function OnBaguaUpdate(inst)
	inst.components.equippable.walkspeedmult = inst.components.bagua:GetSpeedMult()
	
	inst.components.weapon:SetDamage(inst.components.bagua:GetAttack())
	
	OnHideEffects(inst)
	OnShowEffects(inst, inst.components.bagua:GetLight())
	
	if IsDLCEnabled and (IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC)) then
		if inst.components.bagua:HasEffect("zhen") then
			inst.components.weapon:SetElectric()
			inst.components.weapon:SetDamage(inst.components.bagua:GetAttack() / 1.5)
		else
			-- RemoveElectric
			inst.components.weapon.stimuli = nil
		end
	end
end

local function fn(colour)

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
    inst:AddTag("sharp")
    
    anim:SetBank("woodensword")
    anim:SetBuild("woodensword")
    anim:PlayAnimation("idle")
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40.5)
	inst.components.weapon:SetOnAttack(OnAttack)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "woodensword_activated"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/woodensword_activated.xml"
    
    inst:AddComponent("equippable")
	inst.components.inventoryitem:SetOnDroppedFn( OnDrop )
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	local dappercomp = nil

	if IsDLCEnabled and (IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC)) then
		dappercomp = inst.components.equippable
	else
		inst:AddComponent("dapperness")
		dappercomp = inst.components.dapperness
	end
	
	dappercomp.dapperfn = function(inst, owner)
		return inst.components.bagua:GetDaperness()
	end
	
    inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = function(inst, viewer)
		return inst.components.bagua:GetStatus()
	end
	
	inst:AddComponent("bagua")
	inst.components.bagua:SetOnUpdateFn(OnBaguaUpdate)
	inst.components.bagua:SetOnTurnOnLight(OnShowEffects)
	inst.components.bagua:SetOnTurnOffLight(OnHideEffects)
	inst.baguaEffects = {}
	inst.baguaLight = nil
	
	inst:AddComponent("absorber")
	inst.components.absorber.absorbstr = "FIRE"
	inst.components.absorber.canabsorb = function(target)
		return inst.components.bagua:HasEffect("li") and target.components.burnable and target.components.burnable:IsBurning()
	end
	inst.components.absorber.onabsorb = function(doer, target)
		if target.components.burnable then
			target.components.burnable:Extinguish()
		end
	end

    return inst
end

return Prefab("common/inventory/woodensword_activated", fn, assets, prefabs)