local assets =
{
    Asset("ANIM", "anim/xunwind.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	
    anim:SetBank("xunwind")
    anim:SetBuild("xunwind")
    anim:PlayAnimation("idle", true)
	
	inst:AddTag("fx")
	
	inst:AddComponent("limitedlife")
	inst.components.limitedlife.life = 2
	
	inst:DoPeriodicTask(0.5, function()
		local pos = inst:GetPosition()
		local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 1, {"monster"}, {"character", "dead"})
		for k,v in pairs(ents) do
			if v.components.combat then
				v.components.combat:GetAttacked(inst, 8, nil)
			end
		end
	end)
	
    return inst
end

return Prefab( "common/fx/xunwind", fn, assets) 