local texture = resolvefilepath("images/fx/zhen.tex")
local shader = "shaders/particle.ksh"
local colour_envelope_name = "zhenelecballcolourenvelope"
local scale_envelope_name = "zhenelecballscaleenvelope"

local assets =
{
	Asset( "IMAGE", texture ),
	Asset( "SHADER", shader ),
}

local max_scale = 1.3

local function IntColour( r, g, b, a )
	return { r / 255.0, g / 255.0, b / 255.0, a / 255.0 }
end

local init = false
local function InitEnvelope()
	if EnvelopeManager and not init then
		init = true
		EnvelopeManager:AddColourEnvelope(
			colour_envelope_name,
			{	{ 0,	IntColour( 255, 255, 255, 255 ) },
				{ 1,	IntColour( 255, 255, 255, 255 ) },
			} )

		EnvelopeManager:AddVector2Envelope(
			scale_envelope_name,
			{
				{ 0,	{ max_scale, max_scale } },
				{ 1,	{ max_scale, max_scale } },
			} )
	end
end

local max_lifetime = 0.1
--local ground_height = 0.1

function sphere_emitter(radius)
	local z = 2.0 * math.random() - 1.0
	local t = 2.0 * PI * math.random()
	local w = math.sqrt( 1.0 - z * z )
	local x = w * math.cos( t )
	local y = w * math.sin( t )

	return radius * x, radius * y, radius * z
end

local function fn(Sim)
	local inst = CreateEntity()
	inst:AddTag("FX")
	local trans = inst.entity:AddTransform()
	local emitter = inst.entity:AddParticleEmitter()

	InitEnvelope()

	emitter:SetRenderResources( texture, shader )
	emitter:SetMaxNumParticles( 64 )
	emitter:SetMaxLifetime( max_lifetime )
	emitter:SetColourEnvelope( colour_envelope_name )
	emitter:SetScaleEnvelope( scale_envelope_name );
	emitter:SetBlendMode( BLENDMODE.Additive )
	emitter:EnableBloomPass( true )
	emitter:SetUVFrameSize( 1.0 / 4.0, 1.0 / 4.0 )

    inst.persists = false
	
	inst.minradius = 0.5
    inst.maxradius = 3
	
	local life_max = 2
	local life = life_max
	
	local tick_time = TheSim:GetTickTime()

	local desired_particles_per_second = 64
	local particles_per_tick = desired_particles_per_second * tick_time

	local emitter = inst.ParticleEmitter

	local num_particles_to_emit = 1

	local emit_fn = function()
		local vx, vy, vz = 0, 0, 0
		local lifetime = max_lifetime * ( 0.9 + UnitRand() * 0.1 )
		local px, py, pz

		px, py, pz = sphere_emitter(inst.minradius + (inst.maxradius - inst.minradius) * (life_max - life) / life_max)

		local u_offset = math.random( 0, 3 ) * 0.25
		local v_offset = math.random( 0, 3 ) * 0.25

		emitter:AddParticleUV(
			lifetime,			-- lifetime
			px, py, pz,			-- position
			vx, vy, vz,			-- velocity
			u_offset, v_offset	-- uv offset
		)
	end
	
    inst.entity:AddSoundEmitter()
	
    local sound = true
	local updateFunc = function()
        if sound then inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/spark") sound = false end
		
		while num_particles_to_emit > 1 do
			emit_fn( emitter )
			num_particles_to_emit = num_particles_to_emit - 1
		end

		num_particles_to_emit = num_particles_to_emit + particles_per_tick * (5 * math.random() - 1.5)
		
		life = life - tick_time
		if life < 0 then
			inst:Remove()
		end
	end

	EmitterManager:AddEmitter( inst, nil, updateFunc )
    
    return inst
end

return Prefab( "common/fx/zhenelecball", fn, assets) 
 
