/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.AppStateService;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.CodeUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/appInfo"})
public class AppInfoController {
    private static final Logger logger = LoggerFactory.getLogger(AppInfoController.class);
    @Resource
    private AppInfoService appInfoService;
    @Resource
    private AppStateService appStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DashboardService dashBoardService;
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private HostGroupService hostInfoService;
    @Resource
    private DashboardService dashboardService;
    @Autowired
    private TokenUtils tokenUtils;

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("token is invalidate");
            return "error\uff1atoken is invalidate";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.get((Object)"hostname") || StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"hostname").toString())) {
            return "";
        }
        params.put("hostname", agentJsonObject.get((Object)"hostname").toString());
        try {
            List appInfoList = this.appInfoService.selectAllByParams(params);
            return JSONUtil.toJsonStr((Object)appInfoList);
        }
        catch (Exception e) {
            logger.error("agent\u83b7\u53d6\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("agent\u83b7\u53d6\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
            return "";
        }
    }

    @RequestMapping(value={"list"})
    public String AppInfoList(AppInfo appInfo, Model model) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)appInfo.getHostname())) {
                hostname = CodeUtil.unescape((String)appInfo.getHostname());
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(CodeUtil.escape((String)hostname));
            }
            PageInfo pageInfo = this.appInfoService.selectByParams(params, appInfo.getPage().intValue(), appInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/appInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("appInfo", (Object)appInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
        }
        return "app/list";
    }

    @RequestMapping(value={"save"})
    public String saveAppInfo(AppInfo AppInfo2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)AppInfo2.getId())) {
                this.appInfoService.save(AppInfo2);
            } else {
                this.appInfoService.updateById(AppInfo2);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u8fdb\u7a0b\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(AppInfo2.getHostname(), "\u4fdd\u5b58\u8fdb\u7a0b\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "redirect:/appInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u8fdb\u7a0b\uff1a";
        String id = request.getParameter("id");
        AppInfo appInfo = new AppInfo();
        try {
            List systemInfoList = this.systemInfoService.selectAllByParams(new HashMap());
            model.addAttribute("systemInfoList", (Object)systemInfoList);
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("appInfo", (Object)appInfo);
                return "app/add";
            }
            appInfo = this.appInfoService.selectById(id);
            model.addAttribute("appInfo", (Object)appInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(appInfo.getAppPid(), errorMsg + e.toString(), "1");
        }
        return "app/add";
    }

    @RequestMapping(value={"view"})
    public String viewChart(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u8fdb\u7a0b\u7edf\u8ba1\u56fe\u9519\u8bef\uff1a";
        String id = request.getParameter("id");
        String date = request.getParameter("date");
        String am = request.getParameter("am");
        AppInfo appInfo = new AppInfo();
        try {
            appInfo = this.appInfoService.selectById(id);
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isEmpty((CharSequence)date)) {
                date = DateUtil.getCurrentDate();
                am = this.dashboardService.getDefaultAm();
            }
            this.dashboardService.setDateParam(am, date, params);
            model.addAttribute("am", (Object)am);
            model.addAttribute("datenow", (Object)date);
            model.addAttribute("dateList", (Object)this.dashboardService.getDateList());
            model.addAttribute("amList", (Object)this.dashboardService.getAmList());
            params.put("appInfoId", appInfo.getId());
            model.addAttribute("appInfo", (Object)appInfo);
            List appStateList = this.appStateService.selectAllByParams(params);
            model.addAttribute("appStateList", (Object)JSONUtil.parseArray((Object)appStateList));
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(appInfo.getHostname() + ":" + appInfo.getAppPid(), errorMsg + e.toString(), "1");
        }
        return "app/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef\uff1a";
        AppInfo appInfo = new AppInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                appInfo = this.appInfoService.selectById(request.getParameter("id"));
                this.logInfoService.save("\u5220\u9664\u8fdb\u7a0b\uff1a" + appInfo.getHostname(), "\u5220\u9664\u8fdb\u7a0b\uff1a" + appInfo.getHostname() + "\uff1a" + appInfo.getAppPid(), "1");
                this.appInfoService.deleteById(request.getParameter("id").split(","));
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(appInfo.getHostname() + ":" + appInfo.getAppPid(), errorMsg + e.toString(), "1");
        }
        return "redirect:/appInfo/list";
    }
}

