/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.dto.ChartInfo;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.DbTableService;
import com.wgcloud.service.DeskStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.HeathMonitorService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.CodeUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dash"})
public class DashboardCotroller {
    private static final Logger logger = LoggerFactory.getLogger(DashboardCotroller.class);
    @Resource
    DbTableService dbTableService;
    @Resource
    DbInfoService dbInfoService;
    @Resource
    SystemInfoService systemInfoService;
    @Resource
    AppInfoService appInfoService;
    @Resource
    DockerInfoService dockerInfoService;
    @Resource
    LogInfoService logInfoService;
    @Autowired
    HeathMonitorService heathMonitorService;
    @Autowired
    HostGroupService hostInfoService;
    @Autowired
    CpuStateService cpuStateService;
    @Autowired
    MemStateService memStateService;
    @Autowired
    SysLoadStateService sysLoadStateService;
    @Autowired
    NetIoStateService netIoStateService;
    @Autowired
    DeskStateService deskStateService;
    @Autowired
    CommonConfig commonConfig;

    private void testThread() {
        Runnable runnable = () -> logger.info("DashboardCotroller----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @RequestMapping(value={"main"})
    public String mainList(Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            int totalSystemInfoSize = this.systemInfoService.countByParams(params);
            model.addAttribute("totalSystemInfoSize", (Object)totalSystemInfoSize);
            int totalSizeApp = this.appInfoService.countByParams(params);
            model.addAttribute("totalSizeApp", (Object)totalSizeApp);
            this.setPieChart(model, totalSystemInfoSize);
            params.clear();
            int dockerSize = this.dockerInfoService.countByParams(params);
            model.addAttribute("dockerSize", (Object)dockerSize);
            params.clear();
            int logSize = this.logInfoService.countByParams(params);
            model.addAttribute("logSize", (Object)logSize);
            params.clear();
            int dbTableSize = this.dbTableService.countByParams(params);
            model.addAttribute("dbTableSize", (Object)dbTableSize);
            Long dbTableSum = this.dbTableService.sumByParams(params);
            model.addAttribute("dbTableSum", (Object)(dbTableSum == null ? 0L : dbTableSum));
            PageInfo pageInfoDbTableList = this.dbTableService.selectByParams(params, 1, 10);
            model.addAttribute("dbTableList", (Object)JSONUtil.parseArray((Object)pageInfoDbTableList.getList()));
            int dbInfoSize = this.dbInfoService.countByParams(params);
            model.addAttribute("dbInfoSize", (Object)dbInfoSize);
            int heathSize = this.heathMonitorService.countByParams(params);
            model.addAttribute("heathSize", (Object)heathSize);
            params.put("heathStatus", "200");
            int heath200Size = this.heathMonitorService.countByParams(params);
            model.addAttribute("heath200Size", (Object)heath200Size);
            model.addAttribute("heatherrSize", (Object)(heathSize - heath200Size));
        }
        catch (Exception e) {
            logger.error("\u4e3b\u9762\u677f\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            this.logInfoService.save("dash/main", "\u4e3b\u9762\u677f\u4fe1\u606f\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        if (request.getParameter(StaticKeys.DASH_VIEW_ACCOUNT) != null) {
            return "dashView/index";
        }
        return "index";
    }

    private void setPieChart(Model model, int totalSystemInfoSize) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<ChartInfo> chartInfoList = new ArrayList<ChartInfo>();
        params.put("memPer", 90);
        int memPerSize_90 = this.systemInfoService.countByParams(params);
        double a = 0.0;
        if (totalSystemInfoSize != 0) {
            a = (double)memPerSize_90 / (double)totalSystemInfoSize;
        }
        ChartInfo memPerSize_90_chart = new ChartInfo();
        memPerSize_90_chart.setItem("\u5185\u5b58>90%");
        memPerSize_90_chart.setCount(Integer.valueOf(memPerSize_90));
        memPerSize_90_chart.setPercent(Double.valueOf(FormatUtil.formatDouble((Double)a, (int)2)));
        chartInfoList.add(memPerSize_90_chart);
        params.clear();
        params.put("memPer", 50);
        params.put("memPerLe", 90);
        int memPerSize_50_90 = this.systemInfoService.countByParams(params);
        double b = 0.0;
        if (totalSystemInfoSize != 0) {
            b = (double)memPerSize_50_90 / (double)totalSystemInfoSize;
        }
        ChartInfo memPerSize_50_90_chart = new ChartInfo();
        memPerSize_50_90_chart.setItem("\u5185\u5b58>50%\u4e14<90%");
        memPerSize_50_90_chart.setCount(Integer.valueOf(memPerSize_50_90));
        memPerSize_50_90_chart.setPercent(Double.valueOf(FormatUtil.formatDouble((Double)b, (int)2)));
        chartInfoList.add(memPerSize_50_90_chart);
        params.clear();
        params.put("cpuPer", 90);
        int cpuPerSize_90 = this.systemInfoService.countByParams(params);
        double c = 0.0;
        if (totalSystemInfoSize != 0) {
            c = (double)cpuPerSize_90 / (double)totalSystemInfoSize;
        }
        ChartInfo cpuPerSize_90_chart = new ChartInfo();
        cpuPerSize_90_chart.setItem("CPU>90%");
        cpuPerSize_90_chart.setCount(Integer.valueOf(cpuPerSize_90));
        cpuPerSize_90_chart.setPercent(Double.valueOf(FormatUtil.formatDouble((Double)c, (int)2)));
        chartInfoList.add(cpuPerSize_90_chart);
        params.clear();
        params.put("memPerLe", 50);
        params.put("cpuPerLe", 50);
        int perSize_50_50 = this.systemInfoService.countByParams(params);
        double e = 0.0;
        if (totalSystemInfoSize != 0) {
            e = (double)perSize_50_50 / (double)totalSystemInfoSize;
        }
        ChartInfo perSize_50_50_chart = new ChartInfo();
        perSize_50_50_chart.setItem("CPU\u548c\u5185\u5b58<50%");
        perSize_50_50_chart.setCount(Integer.valueOf(perSize_50_50));
        perSize_50_50_chart.setPercent(Double.valueOf(FormatUtil.formatDouble((Double)e, (int)2)));
        chartInfoList.add(perSize_50_50_chart);
        params.clear();
        params.put("state", "2");
        int hostDownSize = this.systemInfoService.countByParams(params);
        double ee = 0.0;
        if (hostDownSize != 0) {
            ee = (double)hostDownSize / (double)totalSystemInfoSize;
        }
        ChartInfo hostDownSize_chart = new ChartInfo();
        hostDownSize_chart.setItem("\u4e0b\u7ebf\u4e3b\u673a\u6570\u91cf");
        hostDownSize_chart.setCount(Integer.valueOf(hostDownSize));
        hostDownSize_chart.setPercent(Double.valueOf(FormatUtil.formatDouble((Double)ee, (int)2)));
        chartInfoList.add(hostDownSize_chart);
        model.addAttribute("chartInfoList", (Object)JSONUtil.parseArray(chartInfoList));
        params.clear();
    }

    @RequestMapping(value={"hostDrawList"})
    public String hostDrawList(SystemInfo systemInfo, Model model, HttpServletRequest request) {
        String liceFlage = request.getParameter("liceFlage");
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getHostname())) {
                hostname = CodeUtil.unescape((String)systemInfo.getHostname());
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(CodeUtil.escape((String)hostname));
            }
            LicenseUtil.checkHostList((SystemInfo)systemInfo, (Model)model);
            if (!StringUtils.isEmpty((CharSequence)liceFlage)) {
                LicenseUtil.checkHostDraw((Model)model);
            }
            PageInfo pageInfo = this.systemInfoService.selectByParams(params, systemInfo.getPage().intValue(), systemInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/systemInfo/systemInfoList?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("systemInfo", (Object)systemInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e3b\u673a\u5217\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u4e3b\u673a\u5217\u8868\u9519\u8bef", e.toString(), "1");
        }
        return "hostDraw/list";
    }

    @RequestMapping(value={"hostDraw"})
    public String hostDraw(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        boolean liceFlage = LicenseUtil.checkHostDraw((Model)model);
        if (!liceFlage) {
            return "redirect:/dash/hostDrawList?liceFlage=" + liceFlage;
        }
        try {
            PageInfo pageInfoNetIo;
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            String hostname = systemInfo.getHostname();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", hostname);
            model.addAttribute("systemInfo", (Object)systemInfo);
            int totalAppSize = this.appInfoService.countByParams(params);
            model.addAttribute("totalAppSize", (Object)totalAppSize);
            int totalDockerSize = this.dockerInfoService.countByParams(params);
            model.addAttribute("totalDockerSize", (Object)totalDockerSize);
            params.put("state", StaticKeys.DOWN_STATE);
            int downAppSize = this.appInfoService.countByParams(params);
            model.addAttribute("downAppSize", (Object)downAppSize);
            int downDockerSize = this.dockerInfoService.countByParams(params);
            model.addAttribute("downDockerSize", (Object)downDockerSize);
            Double maxCpuState = this.cpuStateService.selectMaxByHostname(hostname);
            model.addAttribute("maxCpuState", (Object)maxCpuState);
            Double maxMemState = this.memStateService.selectMaxByHostname(hostname);
            model.addAttribute("maxMemState", (Object)maxMemState);
            model.addAttribute("historyDataOut", (Object)this.commonConfig.getHistoryDataOut());
            params.clear();
            params.put("hostname", hostname);
            PageInfo pageInfoLoad = this.sysLoadStateService.selectByParams(params, 1, 1);
            if (!CollectionUtil.isEmpty((Collection)pageInfoLoad.getList())) {
                model.addAttribute("sysLoadState", pageInfoLoad.getList().get(0));
            }
            if (!CollectionUtil.isEmpty((Collection)(pageInfoNetIo = this.netIoStateService.selectByParams(params, 1, 1)).getList())) {
                model.addAttribute("netIoState", pageInfoNetIo.getList().get(0));
            }
            params.clear();
            params.put("hostname", "\u4e3b\u673a\u4e0b\u7ebf\uff1a" + hostname);
            int hostDownSize = this.logInfoService.countByParams(params);
            model.addAttribute("hostDownSize", (Object)hostDownSize);
            params.clear();
            params.put("hostname", hostname);
            List appInfoList = this.appInfoService.selectAllByParams(params);
            model.addAttribute("appInfoList", (Object)appInfoList);
            List dockerInfoList = this.dockerInfoService.selectAllByParams(params);
            model.addAttribute("dockerInfoList", (Object)dockerInfoList);
            List deskStateList = this.deskStateService.selectAllByParams(params);
            model.addAttribute("deskStateList", (Object)deskStateList);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u673a\u753b\u50cf\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("dash/hostDraw", "\u4e3b\u673a\u753b\u50cf\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "hostDraw/view";
    }
}

