/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.dto.MessageDto;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.DbTableService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.jdbc.ConnectionUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/dbInfo"})
public class DbInfoController {
    private static final Logger logger = LoggerFactory.getLogger(DbInfoController.class);
    @Resource
    private DbInfoService dbInfoService;
    @Resource
    private DbTableService dbTableService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private ConnectionUtil connectionUtil;

    @ResponseBody
    @RequestMapping(value={"validate"})
    public String valdateDbInfo(DbInfo DbInfo2, Model model, HttpServletRequest request) {
        MessageDto messageDto = new MessageDto();
        try {
            JdbcTemplate JdbcTemplate2 = this.connectionUtil.getJdbcTemplate(DbInfo2);
            if (JdbcTemplate2 == null) {
                messageDto.setCode("1");
                messageDto.setMsg("\u8fde\u63a5\u6570\u636e\u5e93\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002\u8bf7\u5728\u7cfb\u7edf\u4fe1\u606f\u91cc\u67e5\u770b\u65e5\u5fd7");
            } else {
                messageDto.setCode("0");
                messageDto.setMsg("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u6d4b\u8bd5\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
        }
        return JSONUtil.toJsonStr((Object)messageDto);
    }

    @RequestMapping(value={"list"})
    public String DbInfoList(DbInfo DbInfo2, Model model, HttpServletRequest request) {
        String liceFlage = request.getParameter("liceFlage");
        HashMap params = new HashMap();
        try {
            if (!StringUtils.isEmpty((CharSequence)liceFlage)) {
                LicenseUtil.checkDbInfoList((Model)model);
            }
            PageInfo pageInfo = this.dbInfoService.selectByParams(params, DbInfo2.getPage().intValue(), DbInfo2.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)"/dbInfo/list?1=1");
            model.addAttribute("page", (Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
        }
        return "mysql/dblist";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0\u6570\u636e\u6e90\uff1a";
        String id = request.getParameter("id");
        DbInfo dbInfo = new DbInfo();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("dbInfo", (Object)dbInfo);
                HashMap params = new HashMap();
                int dbSize = this.dbInfoService.countByParams(params);
                if (dbSize >= 3 && !StaticKeys.LICENSE_STATE.equals("1")) {
                    return "redirect:/dbInfo/list?liceFlage=1";
                }
                return "mysql/init";
            }
            dbInfo = this.dbInfoService.selectById(id);
            model.addAttribute("dbInfo", (Object)dbInfo);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(dbInfo.getDbName(), errorMsg + e.toString(), "1");
        }
        return "mysql/init";
    }

    @RequestMapping(value={"save"})
    public String saveDbInfo(DbInfo DbInfo2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)DbInfo2.getId())) {
                this.dbInfoService.save(DbInfo2);
            } else {
                this.dbInfoService.updateById(DbInfo2);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u6e90\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u6570\u636e\u6e90\u9519\u8bef", e.toString(), "1");
        }
        return "redirect:/dbInfo/list?msg=save";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef\uff1a";
        DbInfo DbInfo2 = new DbInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                DbInfo2 = this.dbInfoService.selectById(request.getParameter("id"));
                this.logInfoService.save("\u5220\u9664\u6570\u636e\u6e90\uff1a" + DbInfo2.getAliasName(), "\u5220\u9664\u6570\u636e\u6e90\uff1a" + DbInfo2.getIp() + "\uff1a" + DbInfo2.getPort() + "\uff0c\u6570\u636e\u5e93\u522b\u540d" + DbInfo2.getAliasName(), "1");
                this.dbInfoService.deleteById(request.getParameter("id").split(","));
                this.dbTableService.deleteByDbInfoId(DbInfo2.getId());
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "1");
        }
        return "redirect:/dbInfo/list?msg=del";
    }
}

