/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.DockerStateService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.CodeUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.TokenUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/dockerInfo"})
public class DockerInfoController {
    private static final Logger logger = LoggerFactory.getLogger(DockerInfoController.class);
    @Resource
    private DockerInfoService dockerInfoService;
    @Resource
    private DockerStateService dockerStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DashboardService dashBoardService;
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private HostGroupService hostInfoService;
    @Resource
    private DashboardService dashboardService;
    @Autowired
    private TokenUtils tokenUtils;

    @ResponseBody
    @RequestMapping(value={"agentList"})
    public String agentList(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("token is invalidate");
            return "error\uff1atoken is invalidate";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == agentJsonObject.get((Object)"hostname") || StringUtils.isEmpty((CharSequence)agentJsonObject.get((Object)"hostname").toString())) {
            return "";
        }
        params.put("hostname", agentJsonObject.get((Object)"hostname").toString());
        try {
            List DockerInfoList = this.dockerInfoService.selectAllByParams(params);
            return JSONUtil.toJsonStr((Object)DockerInfoList);
        }
        catch (Exception e) {
            logger.error("agent\u83b7\u53d6docker\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("agent\u83b7\u53d6docker\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
            return "";
        }
    }

    @RequestMapping(value={"list"})
    public String DockerInfoList(DockerInfo DockerInfo2, Model model) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)DockerInfo2.getHostname())) {
                hostname = CodeUtil.unescape((String)DockerInfo2.getHostname());
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(CodeUtil.escape((String)hostname));
            }
            PageInfo pageInfo = this.dockerInfoService.selectByParams(params, DockerInfo2.getPage().intValue(), DockerInfo2.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/dockerInfo/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("DockerInfo", (Object)DockerInfo2);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2docker\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2docker\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
        }
        return "docker/list";
    }

    @RequestMapping(value={"save"})
    public String saveDockerInfo(DockerInfo DockerInfo2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)DockerInfo2.getId())) {
                this.dockerInfoService.save(DockerInfo2);
            } else {
                this.dockerInfoService.updateById(DockerInfo2);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58docker\u4fe1\u606f\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(DockerInfo2.getHostname(), "\u4fdd\u5b58docker\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "redirect:/dockerInfo/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u6dfb\u52a0docker\u4fe1\u606f\uff1a";
        String id = request.getParameter("id");
        DockerInfo DockerInfo2 = new DockerInfo();
        try {
            List systemInfoList = this.systemInfoService.selectAllByParams(new HashMap());
            model.addAttribute("systemInfoList", (Object)systemInfoList);
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("dockerInfo", (Object)DockerInfo2);
                return "docker/add";
            }
            DockerInfo2 = this.dockerInfoService.selectById(id);
            model.addAttribute("dockerInfo", (Object)DockerInfo2);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(DockerInfo2.getDockerId(), errorMsg + e.toString(), "1");
        }
        return "docker/add";
    }

    @RequestMapping(value={"view"})
    public String viewChart(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770bdocker\u4fe1\u606f\u7edf\u8ba1\u56fe\u9519\u8bef\uff1a";
        String id = request.getParameter("id");
        String date = request.getParameter("date");
        String am = request.getParameter("am");
        DockerInfo DockerInfo2 = new DockerInfo();
        try {
            DockerInfo2 = this.dockerInfoService.selectById(id);
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isEmpty((CharSequence)date)) {
                date = DateUtil.getCurrentDate();
                am = this.dashboardService.getDefaultAm();
            }
            this.dashboardService.setDateParam(am, date, params);
            model.addAttribute("datenow", (Object)date);
            model.addAttribute("am", (Object)am);
            model.addAttribute("dateList", (Object)this.dashboardService.getDateList());
            model.addAttribute("amList", (Object)this.dashboardService.getAmList());
            params.put("dockerInfoId", DockerInfo2.getId());
            model.addAttribute("dockerInfo", (Object)DockerInfo2);
            List DockerStateList = this.dockerStateService.selectAllByParams(params);
            model.addAttribute("dockerStateList", (Object)JSONUtil.parseArray((Object)DockerStateList));
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(DockerInfo2.getHostname() + ":" + DockerInfo2.getDockerId(), errorMsg + e.toString(), "1");
        }
        return "docker/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664docker\u4fe1\u606f\u9519\u8bef\uff1a";
        DockerInfo DockerInfo2 = new DockerInfo();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                DockerInfo2 = this.dockerInfoService.selectById(request.getParameter("id"));
                this.logInfoService.save("\u5220\u9664docker\u4fe1\u606f\uff1a" + DockerInfo2.getHostname(), "\u5220\u9664docker\u4fe1\u606f\uff1a" + DockerInfo2.getHostname() + "\uff1a" + DockerInfo2.getDockerId(), "1");
                this.dockerInfoService.deleteById(request.getParameter("id").split(","));
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(DockerInfo2.getHostname() + ":" + DockerInfo2.getDockerId(), errorMsg + e.toString(), "1");
        }
        return "redirect:/dockerInfo/list";
    }
}

