/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.dto.NetIoStateDto;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.DeskStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.CodeUtil;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/systemInfo"})
public class SystemInfoController {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfoController.class);
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    DashboardService dashboardService;
    @Resource
    CpuStateService cpuStateService;
    @Resource
    DeskStateService deskStateService;
    @Resource
    MemStateService memStateService;
    @Resource
    NetIoStateService netIoStateService;
    @Resource
    SysLoadStateService sysLoadStateService;

    private void testThread() {
        Runnable runnable = () -> logger.info("SystemInfoController----------testThread");
        ThreadPoolUtil.executor.execute(runnable);
    }

    @ResponseBody
    @RequestMapping(value={"save"})
    public String saveSystemInfo(SystemInfo SystemInfo2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)SystemInfo2.getId())) {
                this.systemInfoService.save(SystemInfo2);
            } else {
                SystemInfo ho = this.systemInfoService.selectById(SystemInfo2.getId());
                ho.setRemark(SystemInfo2.getRemark());
                this.systemInfoService.updateById(ho);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e3b\u673a\u4fe1\u606f\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(SystemInfo2.getGroupName(), "\u4fdd\u5b58\u4e3b\u673a\u4fe1\u606f\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"systemInfoList"})
    public String systemInfoList(SystemInfo systemInfo, Model model, HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getHostname())) {
                hostname = CodeUtil.unescape((String)systemInfo.getHostname());
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(CodeUtil.escape((String)hostname));
            }
            if (!StringUtils.isEmpty((CharSequence)systemInfo.getOrderBy())) {
                params.put("orderBy", systemInfo.getOrderBy());
                params.put("orderType", systemInfo.getOrderType());
                url.append("&orderBy=").append(systemInfo.getOrderBy());
                url.append("&orderType=").append(systemInfo.getOrderType());
            }
            LicenseUtil.checkHostList((SystemInfo)systemInfo, (Model)model);
            PageInfo pageInfo = this.systemInfoService.selectByParams(params, systemInfo.getPage().intValue(), systemInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/systemInfo/systemInfoList?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("systemInfo", (Object)systemInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e3b\u673a\u5217\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u4e3b\u673a\u5217\u8868\u9519\u8bef", e.toString(), "1");
        }
        if (request.getParameter(StaticKeys.DASH_VIEW_ACCOUNT) != null) {
            return "dashView/list";
        }
        return "host/list";
    }

    @RequestMapping(value={"detail"})
    public String hostDetail(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        String hostname = "";
        try {
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            hostname = systemInfo.getHostname();
            model.addAttribute("systemInfo", (Object)systemInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", systemInfo.getHostname());
            List deskStateList = this.deskStateService.selectAllByParams(params);
            model.addAttribute("deskStateList", (Object)deskStateList);
        }
        catch (Exception e) {
            logger.error("\u4e3b\u673a\u8be6\u7ec6\u4fe1\u606f\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(hostname, "\u67e5\u770b\u4e3b\u673a\u8be6\u7ec6\u4fe1\u606f\u9519\u8bef", e.toString());
        }
        if (request.getParameter(StaticKeys.DASH_VIEW_ACCOUNT) != null) {
            return "dashView/view";
        }
        return "host/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u4e3b\u673a\u4fe1\u606f\u9519\u8bef\uff1a";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                String[] ids;
                for (String id : ids = request.getParameter("id").split(",")) {
                    SystemInfo sys = this.systemInfoService.selectById(id);
                    this.logInfoService.save("\u5220\u9664\u4e3b\u673a\uff1a" + sys.getHostname(), sys.getHostname(), "0");
                }
                this.systemInfoService.deleteById(ids);
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "1");
        }
        return "redirect:/systemInfo/systemInfoList";
    }

    @RequestMapping(value={"chart"})
    public String hostChart(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        String date = request.getParameter("date");
        String am = request.getParameter("am");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "error/500";
        }
        String hostname = "";
        try {
            SystemInfo systemInfo = this.systemInfoService.selectById(id);
            hostname = systemInfo.getHostname();
            model.addAttribute("systemInfo", (Object)systemInfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostname", systemInfo.getHostname());
            if (StringUtils.isEmpty((CharSequence)date)) {
                date = DateUtil.getCurrentDate();
                am = this.dashboardService.getDefaultAm();
            }
            this.dashboardService.setDateParam(am, date, params);
            model.addAttribute("datenow", (Object)date);
            model.addAttribute("am", (Object)am);
            model.addAttribute("dateList", (Object)this.dashboardService.getDateList());
            model.addAttribute("amList", (Object)this.dashboardService.getAmList());
            List cpuStateList = this.cpuStateService.selectAllByParams(params);
            model.addAttribute("cpuStateList", (Object)JSONUtil.parseArray((Object)cpuStateList));
            model.addAttribute("cpuStateMaxVal", (Object)this.findCpuMaxVal(cpuStateList));
            List memStateList = this.memStateService.selectAllByParams(params);
            model.addAttribute("memStateList", (Object)JSONUtil.parseArray((Object)memStateList));
            List ysLoadSstateList = this.sysLoadStateService.selectAllByParams(params);
            model.addAttribute("ysLoadSstateList", (Object)JSONUtil.parseArray((Object)ysLoadSstateList));
            model.addAttribute("ysLoadSstateMaxVal", (Object)this.findLoadMaxVal(ysLoadSstateList));
            List netIoStateList = this.netIoStateService.selectAllByParams(params);
            List netIoStateDtoList = this.toNetIoStateDto(netIoStateList);
            model.addAttribute("netIoStateList", (Object)JSONUtil.parseArray((Object)netIoStateDtoList));
            model.addAttribute("netIoStateBytMaxVal", (Object)this.findNetIoStateBytMaxVal(netIoStateDtoList));
            model.addAttribute("netIoStatePckMaxVal", (Object)this.findNetIoStatePckMaxVal(netIoStateDtoList));
        }
        catch (Exception e) {
            logger.error("\u4e3b\u673a\u56fe\u5f62\u62a5\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(hostname, "\u4e3b\u673a\u56fe\u5f62\u62a5\u8868\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        if (request.getParameter(StaticKeys.DASH_VIEW_ACCOUNT) != null) {
            return "dashView/viewChart";
        }
        return "host/viewChart";
    }

    private double findCpuMaxVal(List<CpuState> cpuStateList) {
        double maxval = 0.0;
        if (!CollectionUtil.isEmpty(cpuStateList)) {
            for (CpuState cpuState : cpuStateList) {
                if (null != cpuState.getIdle() && cpuState.getIdle() > maxval) {
                    maxval = cpuState.getIdle();
                }
                if (null != cpuState.getSys() && cpuState.getSys() > maxval) {
                    maxval = cpuState.getSys();
                }
                if (null == cpuState.getIowait() || !(cpuState.getIowait() > maxval)) continue;
                maxval = cpuState.getIowait();
            }
        }
        if (maxval == 0.0) {
            maxval = 100.0;
        }
        return Math.ceil(maxval);
    }

    private double findLoadMaxVal(List<SysLoadState> ysLoadSstateList) {
        double maxval = 0.0;
        if (!CollectionUtil.isEmpty(ysLoadSstateList)) {
            for (SysLoadState sysLoadState : ysLoadSstateList) {
                if (null != sysLoadState.getOneLoad() && sysLoadState.getOneLoad() > maxval) {
                    maxval = sysLoadState.getOneLoad();
                }
                if (null != sysLoadState.getFiveLoad() && sysLoadState.getFiveLoad() > maxval) {
                    maxval = sysLoadState.getFiveLoad();
                }
                if (null == sysLoadState.getFifteenLoad() || !(sysLoadState.getFifteenLoad() > maxval)) continue;
                maxval = sysLoadState.getFifteenLoad();
            }
        }
        if (maxval == 0.0) {
            maxval = 1.0;
        }
        return Math.ceil(maxval);
    }

    private List<NetIoStateDto> toNetIoStateDto(List<NetIoState> netIoStateList) {
        ArrayList<NetIoStateDto> dtoList = new ArrayList<NetIoStateDto>();
        for (NetIoState netIoState : netIoStateList) {
            NetIoStateDto dto = new NetIoStateDto();
            dto.setCreateTime(netIoState.getCreateTime());
            dto.setDateStr(netIoState.getDateStr());
            dto.setHostname(netIoState.getHostname());
            dto.setRxbyt(Double.valueOf(netIoState.getRxbyt()));
            dto.setRxpck(Double.valueOf(netIoState.getRxpck()));
            dto.setTxbyt(Double.valueOf(netIoState.getTxbyt()));
            dto.setTxpck(Double.valueOf(netIoState.getTxpck()));
            dtoList.add(dto);
        }
        return dtoList;
    }

    private double findNetIoStateBytMaxVal(List<NetIoStateDto> netIoStateList) {
        double maxval = 0.0;
        if (!CollectionUtil.isEmpty(netIoStateList)) {
            for (NetIoStateDto netIoState : netIoStateList) {
                if (null != netIoState.getRxbyt() && netIoState.getRxbyt() > maxval) {
                    maxval = netIoState.getRxbyt();
                }
                if (null == netIoState.getTxbyt() || !(netIoState.getTxbyt() > maxval)) continue;
                maxval = netIoState.getTxbyt();
            }
        }
        if (maxval == 0.0) {
            maxval = 1.0;
        }
        return Math.ceil(maxval);
    }

    private double findNetIoStatePckMaxVal(List<NetIoStateDto> netIoStateList) {
        double maxval = 0.0;
        if (!CollectionUtil.isEmpty(netIoStateList)) {
            for (NetIoStateDto netIoState : netIoStateList) {
                if (null != netIoState.getRxpck() && netIoState.getRxpck() > maxval) {
                    maxval = netIoState.getRxpck();
                }
                if (null == netIoState.getTxpck() || !(netIoState.getTxpck() > maxval)) continue;
                maxval = netIoState.getTxpck();
            }
        }
        if (maxval == 0.0) {
            maxval = 1.0;
        }
        return Math.ceil(maxval);
    }
}

