/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.filter;

import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AccountInfo;
import com.wgcloud.util.staticvar.StaticKeys;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@WebFilter(filterName="authRestFilter", urlPatterns={"/*"})
public class AuthRestFilter
implements Filter {
    static Logger log = LoggerFactory.getLogger(AuthRestFilter.class);
    @Autowired
    CommonConfig commonConfig;
    String[] static_resource = new String[]{"/agent/minTask", "/agentGo/minTask", "login/toLogin", "login/login", "appInfo/agentList", "dockerInfo/agentList", "license/get", "/code/get", ".css", ".js", ".jpg", ".png", ".ico", ".gif", "font", ".eot", ".woff", ".svg", ".ttf", ".woff2", ".scss"};
    String[] dash_views = new String[]{"/dash/main", "/systemInfo/systemInfoList", "/systemInfo/detail", "/systemInfo/chart"};

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        AccountInfo accountInfo = (AccountInfo)session.getAttribute(StaticKeys.LOGIN_KEY);
        String uri = request.getRequestURL().toString();
        log.info("uri----" + request.getRequestURL());
        this.menuActive(session, uri);
        for (String ss : this.static_resource) {
            if (uri.indexOf(ss) == -1) continue;
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (accountInfo == null) {
            for (String ss : this.dash_views) {
                if (uri.indexOf(ss) == -1 || !"true".equals(this.commonConfig.getDashView()) || request.getParameter(StaticKeys.DASH_VIEW_ACCOUNT) == null) continue;
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        if (accountInfo == null) {
            response.sendRedirect("/wgcloud/login/toLogin");
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void menuActive(HttpSession session, String uri) {
        if (uri.indexOf("/log/") > -1) {
            session.setAttribute("menuActive", (Object)"21");
            return;
        }
        if (uri.indexOf("/dash/main") > -1) {
            session.setAttribute("menuActive", (Object)"01");
            return;
        }
        if (uri.indexOf("/systemInfo/systemInfoList") > -1 || uri.indexOf("/systemInfo/detail") > -1 || uri.indexOf("/systemInfo/chart") > -1) {
            session.setAttribute("menuActive", (Object)"12");
            return;
        }
        if (uri.indexOf("/appInfo") > -1) {
            session.setAttribute("menuActive", (Object)"13");
            return;
        }
        if (uri.indexOf("/dockerInfo") > -1) {
            session.setAttribute("menuActive", (Object)"14");
            return;
        }
        if (uri.indexOf("/mailset") > -1) {
            session.setAttribute("menuActive", (Object)"31");
            return;
        }
        if (uri.indexOf("/dbInfo") > -1) {
            session.setAttribute("menuActive", (Object)"41");
            return;
        }
        if (uri.indexOf("/dbTable") > -1) {
            session.setAttribute("menuActive", (Object)"42");
            return;
        }
        if (uri.indexOf("/heathMonitor") > -1) {
            session.setAttribute("menuActive", (Object)"51");
            return;
        }
        if (uri.indexOf("/dash/hostDraw") > -1) {
            session.setAttribute("menuActive", (Object)"61");
            return;
        }
        session.setAttribute("menuActive", (Object)"11");
    }
}

