/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.mapper.AppInfoMapper;
import com.wgcloud.mapper.AppStateMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppInfoService {
    @Autowired
    private AppInfoMapper appInfoMapper;
    @Autowired
    private AppStateMapper appStateMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.appInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(AppInfo AppInfo2) throws Exception {
        AppInfo2.setId(UUIDUtil.getUUID());
        AppInfo2.setCreateTime((Date)DateUtil.getNowTime());
        if (!StringUtils.isEmpty((CharSequence)AppInfo2.getAppPid())) {
            AppInfo2.setAppPid(AppInfo2.getAppPid().trim());
        }
        this.appInfoMapper.save(AppInfo2);
    }

    public int deleteByHostName(Map<String, Object> map) throws Exception {
        return this.appInfoMapper.deleteByHostName(map);
    }

    @Transactional
    public void saveRecord(List<AppInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (AppInfo as : recordList) {
            as.setId(UUIDUtil.getUUID());
        }
        this.appInfoMapper.insertList(recordList);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.appInfoMapper.countByParams(params);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        for (String AppInfoId : id) {
            this.appStateMapper.deleteByAppInfoId(AppInfoId);
        }
        return this.appInfoMapper.deleteById(id);
    }

    @Transactional
    public void updateRecord(List<AppInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        this.appInfoMapper.updateList(recordList);
    }

    public void updateById(AppInfo AppInfo2) throws Exception {
        this.appInfoMapper.updateById(AppInfo2);
    }

    public AppInfo selectById(String id) throws Exception {
        return this.appInfoMapper.selectById(id);
    }

    public List<AppInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.appInfoMapper.selectAllByParams(params);
    }
}

