/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.AppState;
import com.wgcloud.mapper.AppStateMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppStateService {
    @Autowired
    private AppStateMapper appStateMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.appStateMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(AppState AppState2) throws Exception {
        AppState2.setId(UUIDUtil.getUUID());
        AppState2.setCreateTime((Date)DateUtil.getNowTime());
        AppState2.setDateStr(DateUtil.getDateTimeString((Date)AppState2.getCreateTime()));
        this.appStateMapper.save(AppState2);
    }

    public void saveRecord(List<AppState> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (AppState as : recordList) {
            as.setId(UUIDUtil.getUUID());
            as.setDateStr(DateUtil.getDateTimeString((Date)as.getCreateTime()));
        }
        this.appStateMapper.insertList(recordList);
    }

    public int deleteByAppInfoId(String appInfoId) throws Exception {
        return this.appStateMapper.deleteByAppInfoId(appInfoId);
    }

    public int deleteById(String[] id) throws Exception {
        return this.appStateMapper.deleteById(id);
    }

    public AppState selectById(String id) throws Exception {
        return this.appStateMapper.selectById(id);
    }

    public List<AppState> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.appStateMapper.selectAllByParams(params);
    }
}

