/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.DbTable;
import com.wgcloud.mapper.DbTableMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DbTableService {
    @Autowired
    private DbTableMapper dbTableMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.dbTableMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(DbTable DbTable2) throws Exception {
        DbTable2.setId(UUIDUtil.getUUID());
        DbTable2.setCreateTime((Date)DateUtil.getNowTime());
        this.dbTableMapper.save(DbTable2);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.dbTableMapper.countByParams(params);
    }

    public Long sumByParams(Map<String, Object> params) throws Exception {
        return this.dbTableMapper.sumByParams(params);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.dbTableMapper.deleteById(id);
    }

    @Transactional
    public int deleteByDbInfoId(String dbInfoId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)dbInfoId)) {
            return 0;
        }
        return this.dbTableMapper.deleteByDbInfoId(dbInfoId);
    }

    public void updateById(DbTable DbTable2) throws Exception {
        this.dbTableMapper.updateById(DbTable2);
    }

    @Transactional
    public void updateRecord(List<DbTable> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        this.dbTableMapper.updateList(recordList);
    }

    public DbTable selectById(String id) throws Exception {
        return this.dbTableMapper.selectById(id);
    }

    public List<DbTable> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.dbTableMapper.selectAllByParams(params);
    }
}

