/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.task;

import cn.hutool.core.collection.CollectionUtil;
import com.wgcloud.config.CommonConfig;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DbTable;
import com.wgcloud.entity.DbTableCount;
import com.wgcloud.entity.DeskState;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.entity.HeathState;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.entity.MailSet;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.mapper.AppInfoMapper;
import com.wgcloud.mapper.AppStateMapper;
import com.wgcloud.mapper.CpuStateMapper;
import com.wgcloud.mapper.DeskStateMapper;
import com.wgcloud.mapper.DockerInfoMapper;
import com.wgcloud.mapper.DockerStateMapper;
import com.wgcloud.mapper.HeathStateMapper;
import com.wgcloud.mapper.IntrusionInfoMapper;
import com.wgcloud.mapper.LogInfoMapper;
import com.wgcloud.mapper.MailSetMapper;
import com.wgcloud.mapper.MemStateMapper;
import com.wgcloud.mapper.NetIoStateMapper;
import com.wgcloud.mapper.SysLoadStateMapper;
import com.wgcloud.mapper.SystemInfoMapper;
import com.wgcloud.mapper.TcpStateMapper;
import com.wgcloud.service.AppInfoService;
import com.wgcloud.service.AppStateService;
import com.wgcloud.service.CpuStateService;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.DbTableCountService;
import com.wgcloud.service.DbTableService;
import com.wgcloud.service.DeskStateService;
import com.wgcloud.service.DockerInfoService;
import com.wgcloud.service.DockerStateService;
import com.wgcloud.service.HeathMonitorService;
import com.wgcloud.service.HeathStateService;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.IntrusionInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.MailSetService;
import com.wgcloud.service.MemStateService;
import com.wgcloud.service.NetIoStateService;
import com.wgcloud.service.SysLoadStateService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.service.TcpStateService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.RestUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.jdbc.ConnectionUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.msg.WarnMailUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.BatchData;
import com.wgcloud.util.staticvar.StaticKeys;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @Autowired
    SystemInfoService systemInfoService;
    @Autowired
    DeskStateService deskStateService;
    @Autowired
    LogInfoService logInfoService;
    @Autowired
    AppInfoService appInfoService;
    @Autowired
    DockerInfoService dockerInfoService;
    @Autowired
    CpuStateService cpuStateService;
    @Autowired
    MemStateService memStateService;
    @Autowired
    NetIoStateService netIoStateService;
    @Autowired
    SysLoadStateService sysLoadStateService;
    @Autowired
    TcpStateService tcpStateService;
    @Autowired
    AppStateService appStateService;
    @Autowired
    HeathStateService heathStateService;
    @Autowired
    DockerStateService dockerStateService;
    @Autowired
    MailSetService mailSetService;
    @Autowired
    IntrusionInfoService intrusionInfoService;
    @Autowired
    HostGroupService hostInfoService;
    @Autowired
    DbInfoService dbInfoService;
    @Autowired
    DbTableService dbTableService;
    @Autowired
    DbTableCountService dbTableCountService;
    @Autowired
    HeathMonitorService heathMonitorService;
    @Autowired
    private RestUtil restUtil;
    @Autowired
    ConnectionUtil connectionUtil;
    @Autowired
    CommonConfig commonConfig;
    @Autowired
    SystemInfoMapper systemInfoMapper;
    @Autowired
    CpuStateMapper cpuStateMapper;
    @Autowired
    DeskStateMapper deskStateMapper;
    @Autowired
    MemStateMapper memStateMapper;
    @Autowired
    NetIoStateMapper netIoStateMapper;
    @Autowired
    SysLoadStateMapper sysLoadStateMapper;
    @Autowired
    TcpStateMapper tcpStateMapper;
    @Autowired
    AppInfoMapper appInfoMapper;
    @Autowired
    AppStateMapper appStateMapper;
    @Autowired
    HeathStateMapper heathStateMapper;
    @Autowired
    DockerInfoMapper dockerInfoMapper;
    @Autowired
    DockerStateMapper dockerStateMapper;
    @Autowired
    MailSetMapper mailSetMapper;
    @Autowired
    IntrusionInfoMapper intrusionInfoMapper;
    @Autowired
    LogInfoMapper logInfoMapper;

    @Scheduled(initialDelay=10000L, fixedRate=180000L)
    public void initTask() {
        try {
            HashMap params = new HashMap();
            List list = this.mailSetService.selectAllByParams(params);
            StaticKeys.mailSet = list.size() > 0 ? (MailSet)list.get(0) : null;
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u64cd\u4f5c\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=60000L, fixedRate=86400000L)
    public void validateLicense() {
        try {
            HashMap params = new HashMap();
            int list = this.systemInfoService.countByParams(params);
            StaticKeys.LICENSE_STATE = LicenseUtil.validateLicense((int)list);
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4blicense\u4efb\u52a1\u9519\u8bef", (Throwable)e);
        }
    }

    @Scheduled(initialDelay=300000L, fixedRate=900000L)
    public void hostDownCheckTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u68c0\u6d4b\u4e3b\u673a/\u8fdb\u7a0b\u662f\u5426\u4e0b\u7ebf\u4efb\u52a1");
            return;
        }
        this.checkHostDown();
        this.checkAppDown();
        this.checkDockerDown();
    }

    @Scheduled(initialDelay=90000L, fixedRateString="${base.heathTimes}000")
    public void heathMonitorTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u68c0\u6d4b\u670d\u52a1\u63a5\u53e3\u4efb\u52a1");
            return;
        }
        this.logger.info("heathMonitorTask------------" + DateUtil.getDateTimeString((Date)new Date()));
        HashMap params = new HashMap();
        ArrayList<HeathMonitor> heathMonitors = new ArrayList<HeathMonitor>();
        ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>();
        Timestamp date = DateUtil.getNowTime();
        try {
            List heathMonitorAllList = this.heathMonitorService.selectAllByParams(params);
            if (heathMonitorAllList.size() > 0) {
                for (HeathMonitor h : heathMonitorAllList) {
                    int status = 500;
                    Map statusMap = this.restUtil.get(h.getHeathUrl());
                    status = (Integer)statusMap.get("heathStatus");
                    h.setCreateTime((Date)date);
                    h.setHeathStatus(status + "");
                    h.setResTimes((Integer)statusMap.get("resTimes"));
                    heathMonitors.add(h);
                    HeathState heathState = new HeathState();
                    heathState.setResTimes(h.getResTimes());
                    heathState.setHeathId(h.getId());
                    heathState.setCreateTime((Date)DateUtil.getNowTime());
                    BatchData.HEATH_STATE_LIST.add(heathState);
                    if (!"200".equals(h.getHeathStatus())) {
                        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(h.getId())))) continue;
                        LogInfo logInfo = new LogInfo();
                        logInfo.setHostname("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u5f02\u5e38\uff1a" + h.getAppName());
                        logInfo.setInfoContent("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u5f02\u5e38\uff1a" + h.getAppName() + "\uff0c" + h.getHeathUrl() + "\uff0c\u8fd4\u56de\u72b6\u6001" + h.getHeathStatus());
                        logInfo.setState("1");
                        logInfoList.add(logInfo);
                        Runnable runnable = () -> WarnMailUtil.sendHeathInfo((HeathMonitor)h, (boolean)true);
                        ThreadPoolUtil.executor.execute(runnable);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(h.getId())))) continue;
                    Runnable runnable = () -> WarnMailUtil.sendHeathInfo((HeathMonitor)h, (boolean)false);
                    ThreadPoolUtil.executor.execute(runnable);
                }
                this.heathMonitorService.updateRecord(heathMonitors);
                if (logInfoList.size() > 0) {
                    this.logInfoService.saveRecord(logInfoList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u9519\u8bef", e.toString(), "1");
        }
    }

    @Scheduled(initialDelay=120000L, fixedRateString="${base.dbTableTimes}000")
    public void tableCountTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<DbTable> dbTablesUpdate = new ArrayList<DbTable>();
        ArrayList<DbTableCount> dbTableCounts = new ArrayList<DbTableCount>();
        Timestamp date = DateUtil.getNowTime();
        Long tableCount = 0L;
        try {
            List dbInfos = this.dbInfoService.selectAllByParams(params);
            for (DbInfo dbInfo : dbInfos) {
                params.put("dbInfoId", dbInfo.getId());
                List dbTables = this.dbTableService.selectAllByParams(params);
                for (DbTable dbTable : dbTables) {
                    if (StringUtils.isEmpty((CharSequence)dbTable.getWhereVal())) continue;
                    tableCount = this.connectionUtil.queryTableCount(dbInfo, dbTable.getWhereVal());
                    DbTableCount dbTableCount = new DbTableCount();
                    dbTableCount.setCreateTime((Date)date);
                    dbTableCount.setDbTableId(dbTable.getId());
                    dbTableCount.setTableCount(tableCount);
                    dbTableCounts.add(dbTableCount);
                    dbTable.setCreateTime((Date)date);
                    dbTable.setTableCount(tableCount);
                    dbTablesUpdate.add(dbTable);
                }
            }
            if (dbTableCounts.size() > 0) {
                this.dbTableCountService.saveRecord(dbTableCounts);
                this.dbTableService.updateRecord(dbTablesUpdate);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u6570\u636e\u8868\u76d1\u63a7\u4efb\u52a1\u9519\u8bef", e.toString(), "1");
        }
    }

    @Scheduled(initialDelay=29000L, fixedRate=29000L)
    public synchronized void commitTask() {
        this.logger.info("\u6279\u91cf\u63d0\u4ea4\u76d1\u63a7\u6570\u636e\u4efb\u52a1\u5f00\u59cb----------" + DateUtil.getCurrentDateTime());
        try {
            if (BatchData.APP_STATE_LIST.size() > 0) {
                ArrayList APP_STATE_LIST = new ArrayList();
                APP_STATE_LIST.addAll(BatchData.APP_STATE_LIST);
                BatchData.APP_STATE_LIST.clear();
                this.appStateService.saveRecord(APP_STATE_LIST);
            }
            if (BatchData.HEATH_STATE_LIST.size() > 0) {
                ArrayList HEATH_STATE_LIST = new ArrayList();
                HEATH_STATE_LIST.addAll(BatchData.HEATH_STATE_LIST);
                BatchData.HEATH_STATE_LIST.clear();
                this.heathStateService.saveRecord(HEATH_STATE_LIST);
            }
            if (BatchData.DOCKER_STATE_LIST.size() > 0) {
                ArrayList DOCKER_STATE_LIST = new ArrayList();
                DOCKER_STATE_LIST.addAll(BatchData.DOCKER_STATE_LIST);
                BatchData.DOCKER_STATE_LIST.clear();
                this.dockerStateService.saveRecord(DOCKER_STATE_LIST);
            }
            if (BatchData.CPU_STATE_LIST.size() > 0) {
                ArrayList CPU_STATE_LIST = new ArrayList();
                CPU_STATE_LIST.addAll(BatchData.CPU_STATE_LIST);
                BatchData.CPU_STATE_LIST.clear();
                this.cpuStateService.saveRecord(CPU_STATE_LIST);
            }
            if (BatchData.MEM_STATE_LIST.size() > 0) {
                ArrayList MEM_STATE_LIST = new ArrayList();
                MEM_STATE_LIST.addAll(BatchData.MEM_STATE_LIST);
                BatchData.MEM_STATE_LIST.clear();
                this.memStateService.saveRecord(MEM_STATE_LIST);
            }
            if (BatchData.NETIO_STATE_LIST.size() > 0) {
                ArrayList NETIO_STATE_LIST = new ArrayList();
                NETIO_STATE_LIST.addAll(BatchData.NETIO_STATE_LIST);
                BatchData.NETIO_STATE_LIST.clear();
                this.netIoStateService.saveRecord(NETIO_STATE_LIST);
            }
            if (BatchData.SYSLOAD_STATE_LIST.size() > 0) {
                ArrayList SYSLOAD_STATE_LIST = new ArrayList();
                SYSLOAD_STATE_LIST.addAll(BatchData.SYSLOAD_STATE_LIST);
                BatchData.SYSLOAD_STATE_LIST.clear();
                this.sysLoadStateService.saveRecord(SYSLOAD_STATE_LIST);
            }
            if (BatchData.LOG_INFO_LIST.size() > 0) {
                ArrayList LOG_INFO_LIST = new ArrayList();
                LOG_INFO_LIST.addAll(BatchData.LOG_INFO_LIST);
                BatchData.LOG_INFO_LIST.clear();
                this.logInfoService.saveRecord(LOG_INFO_LIST);
            }
            if (BatchData.DESK_STATE_LIST.size() > 0) {
                this.batchCommitDeskState();
            }
            if (BatchData.SYSTEM_INFO_LIST.size() > 0) {
                this.batchCommitSystemInfo();
            }
            if (BatchData.APP_INFO_LIST.size() > 0) {
                this.batchCommitAppInfo();
            }
            if (BatchData.DOCKER_INFO_LIST.size() > 0) {
                this.batchCommitDockerInfo();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u63d0\u4ea4\u76d1\u63a7\u6570\u636e\u9519\u8bef----------", (Throwable)e);
            this.logInfoService.save("commitTask", "\u6279\u91cf\u63d0\u4ea4\u76d1\u63a7\u6570\u636e\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        this.logger.info("\u6279\u91cf\u63d0\u4ea4\u76d1\u63a7\u6570\u636e\u4efb\u52a1\u7ed3\u675f----------" + DateUtil.getCurrentDateTime());
    }

    private void batchCommitDeskState() throws Exception {
        HashMap<String, String> paramsDel = new HashMap<String, String>();
        ArrayList DESK_STATE_LIST = new ArrayList();
        DESK_STATE_LIST.addAll(BatchData.DESK_STATE_LIST);
        BatchData.DESK_STATE_LIST.clear();
        ArrayList<String> hostnameList = new ArrayList<String>();
        for (DeskState deskState : DESK_STATE_LIST) {
            if (hostnameList.contains(deskState.getHostname())) continue;
            hostnameList.add(deskState.getHostname());
        }
        for (String hostname : hostnameList) {
            paramsDel.put("hostname", hostname);
            this.deskStateService.deleteByAccHname(paramsDel);
        }
        this.deskStateService.saveRecord(DESK_STATE_LIST);
    }

    private void batchCommitDockerInfo() throws Exception {
        HashMap paramsDel = new HashMap();
        ArrayList DOCKER_INFO_LIST = new ArrayList();
        DOCKER_INFO_LIST.addAll(BatchData.DOCKER_INFO_LIST);
        BatchData.DOCKER_INFO_LIST.clear();
        ArrayList<DockerInfo> updateList = new ArrayList<DockerInfo>();
        ArrayList<DockerInfo> insertList = new ArrayList<DockerInfo>();
        List savedList = this.dockerInfoService.selectAllByParams(paramsDel);
        for (DockerInfo systemInfo : DOCKER_INFO_LIST) {
            boolean issaved = false;
            for (DockerInfo systemInfoS : savedList) {
                if (!systemInfoS.getHostname().equals(systemInfo.getHostname()) || !systemInfoS.getId().equals(systemInfo.getId())) continue;
                systemInfo.setId(systemInfoS.getId());
                updateList.add(systemInfo);
                issaved = true;
                break;
            }
            if (issaved) continue;
            insertList.add(systemInfo);
        }
        this.dockerInfoService.updateRecord(updateList);
        this.dockerInfoService.saveRecord(insertList);
    }

    private void batchCommitAppInfo() throws Exception {
        HashMap paramsDel = new HashMap();
        ArrayList APP_INFO_LIST = new ArrayList();
        APP_INFO_LIST.addAll(BatchData.APP_INFO_LIST);
        BatchData.APP_INFO_LIST.clear();
        ArrayList<AppInfo> updateList = new ArrayList<AppInfo>();
        ArrayList<AppInfo> insertList = new ArrayList<AppInfo>();
        List savedList = this.appInfoService.selectAllByParams(paramsDel);
        for (AppInfo systemInfo : APP_INFO_LIST) {
            boolean issaved = false;
            for (AppInfo systemInfoS : savedList) {
                if (!systemInfoS.getHostname().equals(systemInfo.getHostname()) || !systemInfoS.getId().equals(systemInfo.getId())) continue;
                systemInfo.setId(systemInfoS.getId());
                updateList.add(systemInfo);
                issaved = true;
                break;
            }
            if (issaved) continue;
            insertList.add(systemInfo);
        }
        this.appInfoService.updateRecord(updateList);
        this.appInfoService.saveRecord(insertList);
    }

    private void batchCommitSystemInfo() throws Exception {
        HashMap paramsDel = new HashMap();
        ArrayList SYSTEM_INFO_LIST = new ArrayList();
        SYSTEM_INFO_LIST.addAll(BatchData.SYSTEM_INFO_LIST);
        BatchData.SYSTEM_INFO_LIST.clear();
        ArrayList<SystemInfo> updateList = new ArrayList<SystemInfo>();
        ArrayList<SystemInfo> insertList = new ArrayList<SystemInfo>();
        List savedList = this.systemInfoService.selectAllByParams(paramsDel);
        for (SystemInfo systemInfo : SYSTEM_INFO_LIST) {
            boolean issaved = false;
            for (SystemInfo systemInfoS : savedList) {
                if (!systemInfoS.getHostname().equals(systemInfo.getHostname())) continue;
                systemInfo.setId(systemInfoS.getId());
                updateList.add(systemInfo);
                issaved = true;
                break;
            }
            if (issaved) continue;
            insertList.add(systemInfo);
        }
        this.systemInfoService.updateRecord(updateList);
        this.systemInfoService.saveRecord(insertList);
    }

    @Scheduled(cron="0 10 8 * * ?")
    public void clearHisdataTask() {
        if (!"master".equals(this.commonConfig.getNodeType())) {
            this.logger.info("slave\u8282\u70b9\u4e0d\u6267\u884c\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u4efb\u52a1");
            return;
        }
        this.logger.info("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u4efb\u52a1\u5f00\u59cb----------" + DateUtil.getCurrentDateTime());
        WarnPools.clearOldData();
        String nowTime = DateUtil.getCurrentDateTime();
        String thrityDayBefore = DateUtil.getDateBefore((String)nowTime, (int)this.commonConfig.getHistoryDataOut());
        HashMap<String, String> paramsDel = new HashMap<String, String>();
        try {
            paramsDel.put("endTime", thrityDayBefore);
            if (paramsDel.get("endTime") != null && !"".equals(paramsDel.get("endTime"))) {
                this.cpuStateMapper.deleteByAccountAndDate(paramsDel);
                this.deskStateMapper.deleteByAccountAndDate(paramsDel);
                this.memStateMapper.deleteByAccountAndDate(paramsDel);
                this.netIoStateMapper.deleteByAccountAndDate(paramsDel);
                this.sysLoadStateMapper.deleteByAccountAndDate(paramsDel);
                this.tcpStateMapper.deleteByAccountAndDate(paramsDel);
                this.appInfoMapper.deleteByDate(paramsDel);
                this.appStateMapper.deleteByDate(paramsDel);
                this.heathStateMapper.deleteByDate(paramsDel);
                this.dockerInfoMapper.deleteByDate(paramsDel);
                this.dockerStateMapper.deleteByDate(paramsDel);
                this.systemInfoMapper.deleteByAccountAndDate(paramsDel);
                this.intrusionInfoMapper.deleteByAccountAndDate(paramsDel);
                this.logInfoMapper.deleteByDate(paramsDel);
                this.dbTableCountService.deleteByDate(paramsDel);
                this.logInfoService.save("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u5b8c\u6210", "\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u5b8c\u6210\uff1a", "1");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u4efb\u52a1\u51fa\u9519\uff1a", (Throwable)e);
            this.logInfoService.save("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u9519\u8bef", "\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        this.logger.info("\u5b9a\u65f6\u6e05\u7a7a\u5386\u53f2\u6570\u636e\u4efb\u52a1\u7ed3\u675f----------" + DateUtil.getCurrentDateTime());
    }

    private void checkHostDown() {
        Timestamp date = DateUtil.getNowTime();
        try {
            HashMap params = new HashMap();
            List list = this.systemInfoService.selectAllByParams(params);
            if (!CollectionUtil.isEmpty((Collection)list)) {
                ArrayList<SystemInfo> updateList = new ArrayList<SystemInfo>();
                ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>();
                for (SystemInfo systemInfo : list) {
                    Date createTime = systemInfo.getCreateTime();
                    long diff = ((Date)date).getTime() - createTime.getTime();
                    if (diff > 660000L) {
                        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(systemInfo.getId())))) continue;
                        systemInfo.setState(StaticKeys.DOWN_STATE);
                        LogInfo logInfo = new LogInfo();
                        logInfo.setHostname("\u4e3b\u673a\u4e0b\u7ebf\uff1a" + systemInfo.getHostname());
                        logInfo.setInfoContent("\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u72b6\u6001\uff0c\u53ef\u80fd\u5df2\u4e0b\u7ebf\uff1a" + systemInfo.getHostname());
                        logInfo.setState("1");
                        logInfoList.add(logInfo);
                        updateList.add(systemInfo);
                        Runnable runnable = () -> WarnMailUtil.sendHostDown((SystemInfo)systemInfo, (boolean)true);
                        ThreadPoolUtil.executor.execute(runnable);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(systemInfo.getId())))) continue;
                    Runnable runnable = () -> WarnMailUtil.sendHostDown((SystemInfo)systemInfo, (boolean)false);
                    ThreadPoolUtil.executor.execute(runnable);
                }
                if (updateList.size() > 0) {
                    this.systemInfoService.updateRecord(updateList);
                }
                if (logInfoList.size() > 0) {
                    this.logInfoService.saveRecord(logInfoList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u4e3b\u673a\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u68c0\u6d4b\u4e3b\u673a\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", "\u68c0\u6d4b\u4e3b\u673a\u662f\u5426\u4e0b\u7ebf\u9519\u8bef\uff1a" + e.toString(), "1");
        }
    }

    private void checkAppDown() {
        Timestamp date = DateUtil.getNowTime();
        try {
            HashMap params = new HashMap();
            List list = this.appInfoService.selectAllByParams(params);
            if (!CollectionUtil.isEmpty((Collection)list)) {
                ArrayList<AppInfo> updateList = new ArrayList<AppInfo>();
                ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>();
                for (AppInfo appInfo : list) {
                    Date createTime = appInfo.getCreateTime();
                    long diff = ((Date)date).getTime() - createTime.getTime();
                    if (diff > 660000L) {
                        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(appInfo.getId())))) continue;
                        appInfo.setState(StaticKeys.DOWN_STATE);
                        LogInfo logInfo = new LogInfo();
                        logInfo.setHostname("\u8fdb\u7a0b\u4e0b\u7ebfIP\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getAppName());
                        logInfo.setInfoContent("\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u72b6\u6001\uff0c\u53ef\u80fd\u5df2\u4e0b\u7ebfIP\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getAppName() + "\uff0c\u8fdb\u7a0bID\uff1a" + appInfo.getAppPid());
                        logInfo.setState("1");
                        logInfoList.add(logInfo);
                        updateList.add(appInfo);
                        Runnable runnable = () -> WarnMailUtil.sendAppDown((AppInfo)appInfo, (boolean)true);
                        ThreadPoolUtil.executor.execute(runnable);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(appInfo.getId())))) continue;
                    Runnable runnable = () -> WarnMailUtil.sendAppDown((AppInfo)appInfo, (boolean)false);
                    ThreadPoolUtil.executor.execute(runnable);
                }
                if (updateList.size() > 0) {
                    this.appInfoService.updateRecord(updateList);
                }
                if (logInfoList.size() > 0) {
                    this.logInfoService.saveRecord(logInfoList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u8fdb\u7a0b\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u68c0\u6d4b\u8fdb\u7a0b\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", "\u68c0\u6d4b\u8fdb\u7a0b\u662f\u5426\u4e0b\u7ebf\u9519\u8bef\uff1a" + e.toString(), "1");
        }
    }

    private void checkDockerDown() {
        Timestamp date = DateUtil.getNowTime();
        try {
            HashMap params = new HashMap();
            List list = this.dockerInfoService.selectAllByParams(params);
            if (!CollectionUtil.isEmpty((Collection)list)) {
                ArrayList<DockerInfo> updateList = new ArrayList<DockerInfo>();
                ArrayList<LogInfo> logInfoList = new ArrayList<LogInfo>();
                for (DockerInfo appInfo : list) {
                    Runnable runnable;
                    LogInfo logInfo;
                    Date createTime = appInfo.getCreateTime();
                    long diff = ((Date)date).getTime() - createTime.getTime();
                    if (diff > 660000L) {
                        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(appInfo.getId())))) continue;
                        appInfo.setState(StaticKeys.DOWN_STATE);
                        logInfo = new LogInfo();
                        logInfo.setHostname("docker\u4e0b\u7ebf\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getDockerName());
                        logInfo.setInfoContent("\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u72b6\u6001\uff0c\u53ef\u80fd\u5df2\u4e0b\u7ebf\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getDockerName() + "\uff0c\u5bb9\u5668ID\uff1a" + appInfo.getDockerId());
                        logInfo.setState("1");
                        logInfoList.add(logInfo);
                        updateList.add(appInfo);
                        runnable = () -> WarnMailUtil.sendDockerDown((DockerInfo)appInfo, (boolean)true);
                        ThreadPoolUtil.executor.execute(runnable);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(appInfo.getId())))) continue;
                    logInfo = new LogInfo();
                    logInfo.setHostname("docker\u6062\u590d\u4e0a\u7ebf\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getDockerName());
                    logInfo.setInfoContent("docker\u6062\u590d\u4e0a\u7ebf\uff1a" + appInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + appInfo.getDockerName() + "\uff0c\u5bb9\u5668ID\uff1a" + appInfo.getDockerId());
                    logInfo.setState("0");
                    logInfoList.add(logInfo);
                    runnable = () -> WarnMailUtil.sendDockerDown((DockerInfo)appInfo, (boolean)false);
                    ThreadPoolUtil.executor.execute(runnable);
                }
                if (updateList.size() > 0) {
                    this.dockerInfoService.updateRecord(updateList);
                }
                if (logInfoList.size() > 0) {
                    this.logInfoService.saveRecord(logInfoList);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4bdocker\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u68c0\u6d4bdocker\u662f\u5426\u4e0b\u7ebf\u9519\u8bef", "\u68c0\u6d4bdocker\u662f\u5426\u4e0b\u7ebf\u9519\u8bef\uff1a" + e.toString(), "1");
        }
    }
}

