/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class CodeUtil {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String escape(String src) {
        if (src == null) {
            return src;
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return src;
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String decodeURIComponent(String src) {
        if (src == null) {
            return src;
        }
        String ret = null;
        try {
            ret = URLDecoder.decode(src, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String dbEncode(String data) {
        if (data == null) {
            return null;
        }
        return CodeUtil.escape((String)CodeUtil.encodeURIComponent((String)data));
    }

    public static String dbDecode(String data) {
        if (data == null) {
            return null;
        }
        return CodeUtil.decodeURIComponent((String)CodeUtil.unescape((String)data));
    }

    public static String encodeURIComponent(String src) {
        if (src == null) {
            return src;
        }
        String ret = null;
        try {
            ret = URLEncoder.encode(src, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String toText(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "''");
        str = str.replaceAll(" ", "&nbsp;");
        str = str.replaceAll("\n", "<br>");
        str = str.replaceAll("\"", "&#034;");
        return str;
    }

    public static String toHtml(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("''", "'");
        str = str.replaceAll("&nbsp;", " ");
        str = str.replaceAll("<br>", "\n");
        str = str.replaceAll("&#034;", "\"");
        return str;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String toUnicode(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CodeUtil.toHex((int)(aChar >> 12 & 0xF)));
                        outBuffer.append(CodeUtil.toHex((int)(aChar >> 8 & 0xF)));
                        outBuffer.append(CodeUtil.toHex((int)(aChar >> 4 & 0xF)));
                        outBuffer.append(CodeUtil.toHex((int)(aChar & 0xF)));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public String fromUnicode(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }
}

