/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Timestamp getNowTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp nowTime = Timestamp.valueOf(dateFormat.format(new Date()));
        return nowTime;
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDateTime((String)"yyyy-MM-dd");
    }

    public static String getCurrentDateTime(String pattern) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(cal.getTime());
    }

    public static Date getDate(String dateStr) throws ParseException {
        return DateUtil.getDate((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDate(String dateStr, String pattern) throws ParseException {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        date = dateFormat.parse(dateStr);
        return date;
    }

    public static String getDateString(Date date) {
        return DateUtil.getString((Date)date, (String)"yyyy-MM-dd");
    }

    public static String getDateTimeString(Date date) {
        return DateUtil.getString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getString(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        return hour;
    }

    public static long secsOf2Day(String day1, String day2) {
        try {
            Date date1 = DateUtil.getDate((String)day1);
            Date date2 = DateUtil.getDate((String)day2);
            long secs = Math.abs(date1.getTime() - date2.getTime()) / 1000L;
            return secs;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String getDateBefore(String datetimes, int day) {
        Calendar now = Calendar.getInstance();
        try {
            now.setTime(DateUtil.getDate((String)datetimes));
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u683c\u5f0f [ " + datetimes + " ]  \u65e0\u6cd5\u88ab\u89e3\u6790\uff1a" + e.toString());
            return null;
        }
        now.set(5, now.get(5) - day);
        return DateUtil.getString((Date)now.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String secondToDate(Long second, String patten) {
        if (second == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(second * 1000L);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(patten);
        String dateString = format.format(date);
        return dateString;
    }
}

