/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.util.DateUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestUtil {
    private Logger logger = LoggerFactory.getLogger(RestUtil.class);
    @Autowired
    private RestTemplate restTemplate;

    public JSONObject post(String url, JSONObject jsonObject) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON_UTF8.toString());
        HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.parse((Object)jsonObject).toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        return JSONUtil.parseObj((String)((String)responseEntity.getBody()));
    }

    public JSONObject post(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", MediaType.APPLICATION_JSON_UTF8.toString());
        HttpEntity httpEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        return JSONUtil.parseObj((String)((String)responseEntity.getBody()));
    }

    public Map<String, Integer> get(String url) {
        HashMap<String, Integer> responseMap = new HashMap<String, Integer>();
        try {
            responseMap.put("resTimes", 20000);
            long startTimes = DateUtil.getNowTime().getTime();
            url = url.indexOf("?") > 0 ? url + "&times=" + startTimes : url + "?times=" + startTimes;
            ResponseEntity responseEntity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            long endTimes = DateUtil.getNowTime().getTime();
            String resTimes = endTimes - startTimes + "";
            responseMap.put("resTimes", Integer.valueOf(resTimes));
            responseMap.put("heathStatus", responseEntity.getStatusCodeValue());
            return responseMap;
        }
        catch (HttpClientErrorException e) {
            this.logger.error("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            responseMap.put("heathStatus", e.getRawStatusCode());
            return responseMap;
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u4efb\u52a1\u9519\u8bef", (Throwable)e);
            responseMap.put("heathStatus", 500);
            return responseMap;
        }
    }
}

