/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.msg;

import com.wgcloud.common.ApplicationContextHelper;
import com.wgcloud.config.MailConfig;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.entity.MailSet;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.ExecUtil;
import com.wgcloud.util.msg.WarnPools;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.Date;
import javax.mail.Authenticator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WarnMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(WarnMailUtil.class);
    public static final String content_suffix = "<p><p><p><a target='_blank' href='http://www.wgstart.com'>WGCLOUD</a>\u656c\u4e0a";
    private static LogInfoService logInfoService = (LogInfoService)ApplicationContextHelper.getBean(LogInfoService.class);
    private static MailConfig mailConfig = (MailConfig)ApplicationContextHelper.getBean(MailConfig.class);

    public static boolean sendWarnInfo(MemState memState) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getMemWarnMail())) {
            return false;
        }
        String key = memState.getHostname();
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
            return false;
        }
        if (memState.getUsePer() != null && memState.getUsePer() >= mailConfig.getMemWarnVal()) {
            try {
                String title = "\u5185\u5b58\u544a\u8b66\uff1a" + memState.getHostname();
                String commContent = "\u670d\u52a1\u5668\uff1a" + memState.getHostname() + ",\u5185\u5b58\u4f7f\u7528\u7387\u4e3a" + Double.valueOf(memState.getUsePer()) + "%\uff0c\u53ef\u80fd\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendCpuWarnInfo(CpuState cpuState) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getCpuWarnMail())) {
            return false;
        }
        String key = cpuState.getHostname();
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
            return false;
        }
        if (cpuState.getSys() != null && cpuState.getSys() >= mailConfig.getCpuWarnVal()) {
            try {
                String title = "CPU\u544a\u8b66\uff1a" + cpuState.getHostname();
                String commContent = "\u670d\u52a1\u5668\uff1a" + cpuState.getHostname() + ",CPU\u4f7f\u7528\u7387\u4e3a" + Double.valueOf(cpuState.getSys()) + "%\uff0c\u53ef\u80fd\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u5185\u5b58\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendHeathInfo(HeathMonitor heathMonitor, boolean isDown) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHeathWarnMail())) {
            return false;
        }
        String key = heathMonitor.getId();
        if (isDown) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
                return false;
            }
            try {
                String title = "\u670d\u52a1\u63a5\u53e3\u68c0\u6d4b\u544a\u8b66\uff1a" + heathMonitor.getAppName();
                String commContent = "\u670d\u52a1\u63a5\u53e3\uff1a" + heathMonitor.getAppName() + "\uff0curl\uff1a" + heathMonitor.getHeathUrl() + "\uff0c\u54cd\u5e94\u72b6\u6001\u7801\u4e3a" + heathMonitor.getHeathStatus() + "\uff0c\u53ef\u80fd\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u670d\u52a1\u5065\u5eb7\u68c0\u6d4b\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u670d\u52a1\u5065\u5eb7\u68c0\u6d4b\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove(key);
            try {
                String title = "\u670d\u52a1\u63a5\u53e3\u6062\u590d\u6b63\u5e38\u901a\u77e5\uff1a" + heathMonitor.getAppName();
                String commContent = "\u670d\u52a1\u63a5\u53e3\uff1a" + heathMonitor.getAppName() + "\uff0curl\uff1a" + heathMonitor.getHeathUrl() + "\uff0c\u54cd\u5e94\u72b6\u6001\u7801\u4e3a" + heathMonitor.getHeathStatus() + "";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u670d\u52a1\u63a5\u53e3\u6062\u590d\u6b63\u5e38\u901a\u77e5\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u670d\u52a1\u63a5\u53e3\u6062\u590d\u6b63\u5e38\u901a\u77e5\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendHostDown(SystemInfo systemInfo, boolean isDown) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getHostDownWarnMail())) {
            return false;
        }
        String key = systemInfo.getId();
        if (isDown) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
                return false;
            }
            try {
                String title = "\u4e3b\u673a\u4e0b\u7ebf\u544a\u8b66\uff1a" + systemInfo.getHostname();
                String commContent = "\u4e3b\u673a\u5df2\u7ecf\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u7ecf\u4e0b\u7ebf\uff1a" + systemInfo.getHostname() + "\uff0c\u5907\u6ce8\uff1a" + systemInfo.getRemark() + "\u3002";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove(key);
            try {
                String title = "\u4e3b\u673a\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + systemInfo.getHostname();
                String commContent = "\u4e3b\u673a\u5df2\u7ecf\u6062\u590d\u4e0a\u7ebf\uff1a" + systemInfo.getHostname() + "\uff0c\u5907\u6ce8\uff1a" + systemInfo.getRemark() + "\u3002";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u4e3b\u673a\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u4e3b\u673a\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendAppDown(AppInfo appInfo, boolean isDown) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getAppDownWarnMail())) {
            return false;
        }
        String key = appInfo.getId();
        if (isDown) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
                return false;
            }
            try {
                String title = "\u8fdb\u7a0b\u4e0b\u7ebf\u544a\u8b66\uff1a" + appInfo.getHostname() + "\uff0c" + appInfo.getAppName();
                String commContent = "\u8fdb\u7a0b\u5df2\u7ecf\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u7ecf\u4e0b\u7ebf\uff1a" + appInfo.getHostname() + "\uff0c" + appInfo.getAppName() + "\u3002";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8fdb\u7a0b\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8fdb\u7a0b\u4e0b\u7ebf\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove(key);
            try {
                String title = "\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + appInfo.getHostname() + "\uff0c" + appInfo.getAppName();
                String commContent = "\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + appInfo.getHostname() + "\uff0c" + appInfo.getAppName();
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u8fdb\u7a0b\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDockerDown(DockerInfo dockerInfo, boolean isDown) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getAppDownWarnMail())) {
            return false;
        }
        String key = dockerInfo.getId();
        if (isDown) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
                return false;
            }
            try {
                String title = "docker\u4e0b\u7ebf\u544a\u8b66\uff1a" + dockerInfo.getHostname() + "\uff0c" + dockerInfo.getDockerName();
                String commContent = "docker\u5df2\u7ecf\u8d85\u8fc710\u5206\u949f\u672a\u4e0a\u62a5\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u7ecf\u4e0b\u7ebf\uff1a" + dockerInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + dockerInfo.getDockerName() + "\uff0c\u5bb9\u5668ID\uff1a" + dockerInfo.getDockerId() + "\u3002";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001docker\u4e0b\u7ebf\u544a\u8b66\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001docker\u4e0b\u7ebf\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove(key);
            try {
                String title = "docker\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + dockerInfo.getHostname() + "\uff0c" + dockerInfo.getDockerName();
                String commContent = "docker\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + dockerInfo.getHostname() + "\uff0c\u540d\u79f0\uff1a" + dockerInfo.getDockerName() + "\uff0c\u5bb9\u5668ID\uff1a" + dockerInfo.getDockerId();
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001docker\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001docker\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static boolean sendDbDown(DbInfo dbInfo, boolean isDown) {
        MailSet mailSet = StaticKeys.mailSet;
        if ("false".equals(mailConfig.getAllWarnMail()) || "false".equals(mailConfig.getDbDownWarnMail())) {
            return false;
        }
        String key = dbInfo.getId();
        if (isDown) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)WarnPools.MEM_WARN_MAP.get(key)))) {
                return false;
            }
            try {
                String title = "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\u544a\u8b66\uff1a" + dbInfo.getIp() + "\uff0c" + dbInfo.getAliasName();
                String commContent = "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff1a" + dbInfo.getIp() + "\uff0c\u7aef\u53e3\uff1a" + dbInfo.getPort() + "\uff0c\u540d\u79f0\uff1a" + dbInfo.getDbName() + "\u3002";
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                WarnPools.MEM_WARN_MAP.put(key, "1");
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\u544a\u8b66\u9519\u8bef", e.toString(), "1");
            }
        } else {
            WarnPools.MEM_WARN_MAP.remove(key);
            try {
                String title = "\u6570\u636e\u6e90\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + dbInfo.getIp() + "\uff0c" + dbInfo.getAliasName();
                String commContent = "\u6570\u636e\u6e90\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\uff1a" + dbInfo.getIp() + "\uff0c\u7aef\u53e3\uff1a" + dbInfo.getPort() + "\uff0c\u540d\u79f0\uff1a" + dbInfo.getDbName();
                if (StaticKeys.mailSet != null) {
                    WarnMailUtil.sendMail((String)mailSet.getToMail(), (String)title, (String)commContent);
                }
                ExecUtil.runScript((String)mailConfig.getWarnScript(), (String)commContent);
                logInfoService.save(title, commContent, "1");
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6570\u636e\u6e90\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u90ae\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                logInfoService.save("\u53d1\u9001\u6570\u636e\u6e90\u6062\u590d\u4e0a\u7ebf\u901a\u77e5\u9519\u8bef", e.toString(), "1");
            }
        }
        return false;
    }

    public static String sendMail(String mails, String mailTitle, String mailContent) {
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(StaticKeys.mailSet.getSmtpHost());
            email.setSmtpPort(Integer.valueOf(StaticKeys.mailSet.getSmtpPort()).intValue());
            if ("1".equals(StaticKeys.mailSet.getSmtpSSL())) {
                email.setSSL(true);
            }
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(StaticKeys.mailSet.getFromMailName(), StaticKeys.mailSet.getFromPwd()));
            email.setFrom(StaticKeys.mailSet.getFromMailName(), "WGCLOUD\u76d1\u63a7\u7cfb\u7edf");
            email.setSubject(mailTitle);
            email.setCharset("UTF-8");
            email.setHtmlMsg(mailContent + "<p><p><p><a target='_blank' href='http://www.wgstart.com'>WGCLOUD</a>\u656c\u4e0a");
            email.addTo(mails.split(";"));
            email.setSentDate(new Date());
            email.send();
            return "success";
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            logInfoService.save("\u53d1\u9001\u90ae\u4ef6\u9519\u8bef", e.toString(), "1");
            return "error";
        }
    }
}

