/*
 * noVNC: HTML5 VNC client
 * Copyright (C) 2019 The noVNC Authors
 * Licensed under MPL 2.0 (see LICENSE.txt)
 *
 * See README.md for usage and integration instructions.
 *
 */

import * as Log from '../util/logging.js';

export default class HextileDecoder {
    constructor() {
        this._tiles = 0;
        this._lastsubencoding = 0;
        this._beginx=-1;
        this._beginy=-1;
        this._lastbgcolor=[0,0,0,0];
        this._lastfgcolor=[255,255,255,255];
    }

    _GetValueFromArray(pix,num)
    {
        let retv=0;
        for (let i=0;i<num;i++)
        {
            retv=256*retv+pix[i];
        }
        return retv;
    }

    decodeRect(rx, ry, rw, rh, sock, display, depth) {
        const HEXTILERAW=0;
        const HEXTILEBACKCOLORONLY=1;
        const HEXTILEBACKCOLORNONEEDCOLOR=2;
        const HEXTILEBACKCOLORWITHFORCOLOR=3;
        const HEXTILEBACKCOLORWITHSUBRECT=4;
        const HEXTILEBACKCOLORWITHSUBCOLOR=5;
        const HEXTILEFORCOLORWITHSUBRECT=6;
        const HEXTILESUBRECT=7;
        const HEXTILESUBCOLOR=8;

        var bpp=depth;      
        var startx=rx;
        var starty=ry;
        var lastbgcolor=[255,255,255,255];
        var lastfgcolor=[0,0,0,255];
        //ڲȡΪ첽ȡݣڱûжݣôλúδݣȴ´ν
        if (this._beginx!=-1) startx=this._beginx;//սʱøֵһѭҪΪʼλֵ
        if (this._beginy!=-1) starty=this._beginy;
        if (this._lastbgcolor!=[0,0,0,0]) lastbgcolor=this._lastbgcolor;
        if (this._lastfgcolor!=[255,255,255,255]) lastfgcolor=this._lastfgcolor;
        var bg;
        var fg;   
        var bgcolor=lastbgcolor;
        var fgcolor=lastfgcolor;
        var i;
        var n;     
        var m;   
        var circletime=new Uint8Array(1);
        var x;
        var y;
        var w;
        var h;
        var sx;
        var sy;
        var sw;
        var sh;
        var subencoding=new Uint8Array(1);
        var nSubrects=new Uint8Array(1);

        //bpp=24/32ʱȱʡ
        //let rscale = 1;//ӳɫŴ
        //let gscale = 1;
        //let bscale = 1;
        var rs = 16;
        var rm = 255
        var gs = 8;
        var gm = 255;
        var bs = 0;
        var bm = 255;
   
        if (bpp==8)
        {
            rs = 0;
            rm = 7;
            gs = 3;
            gm = 7;
            bs = 6;
            bm = 3;
            //rscale=(256/8);
            //gscale=(256/8);
            //bscale=(256/4);
        }
        else if (bpp==16)//16, 16, 1, 1, 63, 31, 31, 0,6,11,0,0
        {
            rs = 0;
            rm = 31
            gs = 5;
            gm = 31;
            bs = 10;
            bm = 31;
            //rscale=(256/32);
            //gscale=(256/32);
            //bscale=(256/32);
        }
        else
            bpp=32;
        var pix=[0,0,0,255];
        var r=0;
        var g=0;
        var b=0;
        var pos=0;
        var begin=0;
        var savebegin=0;
        let m_netbuf;
        let bytes=0;
        let countbegin=bytes;//ʼbytesʼֵ
        let tv=0;
        circletime[0]=0;
        subencoding[0]=0;
        nSubrects[0]=0;
        for (y = starty; y < (ry+rh); y += 16)                                           
        {
            for (x = startx; x < (rx+rw); x += 16)                                        
            {
                w = 16;
                h = 16;
                if ((rx+rw-x) < 16)                                                  
                    w = rx+rw-x;                                                   
                if ((ry+rh-y) < 16)                                                  
                    h = ry+rh-y;     
                                              
                if (sock.rQwait("HEXTILE", 1)) {
                    return false;
                }
                m_netbuf=sock.rQ;
                bytes=sock.rQi;
                countbegin=bytes;
                begin=bytes;
                subencoding[0]=m_netbuf[begin];
                bytes=bytes+1;
                                 
                if (!(subencoding[0] & 0x01))                                           
                {                
                    circletime[0]=subencoding[0]>>2;                                        
                    if (subencoding[0] & 0x02)                                           
                        subencoding[0]=HEXTILEBACKCOLORONLY;                              
                    else                                                              
                        subencoding[0]=HEXTILEBACKCOLORNONEEDCOLOR;                       
                }                                                                    
                else                                                                 
                {                                                                    
                    if (!(subencoding[0] & 0x02))                                        
                    {
                        circletime[0]=subencoding[0]>>4;                                     
                        if ((subencoding[0] & 0x0F)==0x01)                                
                            subencoding[0]=HEXTILESUBRECT;                                 
                        if ((subencoding[0] & 0x0F)==0x05)                                
                            subencoding[0]=HEXTILEBACKCOLORWITHSUBRECT;                    
                        if ((subencoding[0] & 0x0F)==0x09)                                
                            subencoding[0]=HEXTILEFORCOLORWITHSUBRECT;                     
                        if ((subencoding[0] & 0x0F)==0x0D)                                
                            subencoding[0]=HEXTILEBACKCOLORWITHFORCOLOR;                   
                    }                                                                 
                    else                                                              
                    {                                                                 
                        if (!(subencoding[0] & 0x04))                                     
                        {
                            circletime[0]=subencoding[0]>>4;                                  
                            if (subencoding[0] & 0x08)                                     
                                subencoding[0]=HEXTILEBACKCOLORWITHSUBCOLOR;                
                            else                                                        
                                subencoding[0]=HEXTILESUBCOLOR;                             
                        }                                                              
                        else                                                           
                        {
                            circletime[0]=subencoding[0]>>3;                                  
                            subencoding[0]=HEXTILERAW;                                     
                        }                                                              
                    }                                                                 
                }                                                                    
                if (subencoding[0] == HEXTILERAW)                                       
                {
                    begin=bytes;
                    bytes=bytes+(w*h*(bpp/8));
                    if (sock.rQwait("HEXTILE", bytes-countbegin)) {
                        return false;
                    }
                    try{
                        for (n=0;n<=circletime[0];n++){                                                                 
                            if (n!=0)                                                      
                            {                                                              
                                x=x+16;                                                     
                                if (x>=(rx+rw)) {
                                    x=rx;
                                    y=y+16;
                                }                                
                                w=16;
                                h=16;                                                     
                                if ((rx+rw-x)<16) w=rx+rw-x;                                  
                                if ((ry+rh-y)<16) h=ry+rh-y;                                  
                            }                                                              
                            pos=begin;
                            var dealeddata=new Uint8Array(w*h*4);//ȫһ4ֽڵ
                            var dcnt=0;
                            for (var k=y; k<(y+h); k++)
                            {       
                                for (var j=x; j<(x+w); j++)
                                {
                                    if (bpp==8)
                                    {
                                        pix=[m_netbuf[pos]];
                                        pos=pos+1;
                                        tv=this._GetValueFromArray(pix,1);
                                    }
                                    else if (bpp==16)
                                    {
                                        pix=[m_netbuf[pos],m_netbuf[pos+1]];
                                        pos=pos+2;
                                        tv=this._GetValueFromArray(pix,2);
                                    }
                                    else
                                    {
                                        pix=[m_netbuf[pos],m_netbuf[pos+1],m_netbuf[pos+2],m_netbuf[pos+3]];
                                        pos=pos+4;
                                        tv=this._GetValueFromArray(pix,3);
                                    }
                                    r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                                    g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                                    b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                                    dealeddata[dcnt]=r;
                                    dealeddata[dcnt+1]=g;
                                    dealeddata[dcnt+2]=b;
                                    dealeddata[dcnt+3]=255;
                                    dcnt=dcnt+4;
                                }
                            }
                            display.blitImage(x, y, w, h, dealeddata, 0);
                        }   
                    }catch(err){
                        console.log(err);
                    }
                    sock.rQi=bytes;                                                                         
                    this._beginx=x+16;
                    this._beginy=y;
                    this._lastbgcolor=lastbgcolor;
                    this._lastfgcolor=lastfgcolor;
                    continue;                                                         
                }                                                                    
                                                                              
                if (  subencoding[0] == HEXTILEBACKCOLORONLY                            
                    ||subencoding[0] == HEXTILEBACKCOLORNONEEDCOLOR )                   
                {                                                                    
                    if (subencoding[0] == HEXTILEBACKCOLORONLY)                          
                    {                                                                                          
                        begin=bytes;
                        bytes=bytes+bpp/8;
                        if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                            return false;
                        }

                        if (bpp==8)
                        {
                            bgcolor = [m_netbuf[begin]];
                            tv=this._GetValueFromArray(bgcolor,1);
                        }
                        else if (bpp==16)
                        {
                            bgcolor = [m_netbuf[begin],m_netbuf[begin+1]];
                            tv=this._GetValueFromArray(bgcolor,2);
                        }
                        else
                        {
                            bgcolor = [m_netbuf[begin],m_netbuf[begin+1],m_netbuf[begin+2],m_netbuf[begin+3]];
                            tv=this._GetValueFromArray(bgcolor,3);
                        }
                        r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                        g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                        b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                        bgcolor=[r,g,b,255];
                        lastbgcolor=bgcolor;
                    }
                    try{
                        for (n=0;n<=circletime[0];n++){                                                                 
                            if (n!=0)
                            {                                                              
                                x=x+16;                                                     
                                if (x>=(rx+rw)) {
                                    x=rx;
                                    y=y+16;
                                }                                
                                w=16;
                                h=16;                                                      
                                if ((rx+rw-x)<16) w=rx+rw-x;                                  
                                if ((ry+rh-y)<16) h=ry+rh-y;                                  
                            }                                                              
                            display.fillRect(x,y,w,h,bgcolor);
                        } 
                    } catch(err){
                        console.log(err);
                    }                                                                
                    sock.rQi=bytes;                                                                                 
                    this._beginx=x+16;
                    this._beginy=y;
                    this._lastbgcolor=lastbgcolor;
                    this._lastfgcolor=lastfgcolor;
                    continue;                                                         
                }                                                                     
                                                                              
                if (  subencoding[0]==HEXTILEBACKCOLORWITHFORCOLOR                     
                    ||subencoding[0]==HEXTILEBACKCOLORWITHSUBRECT                      
                    ||subencoding[0]==HEXTILEFORCOLORWITHSUBRECT                       
                    ||subencoding[0]==HEXTILESUBRECT)                                  
                {                                                                    
                    if (  subencoding[0]==HEXTILEBACKCOLORWITHFORCOLOR                   
                        ||subencoding[0]==HEXTILEBACKCOLORWITHSUBRECT)                   
                    {                                                                                                     
                        begin=bytes;
                        bytes=bytes+bpp/8;
                        if (sock.rQwait("HEXTILE", bytes-countbegin)) {
                            return false;
                        } 
                        if (bpp==8)
                        {
                            bgcolor = [m_netbuf[begin]];
                            tv=this._GetValueFromArray(bgcolor,1);
                        }
                        else if (bpp==16)
                        {
                            bgcolor = [m_netbuf[begin],m_netbuf[begin+1]];
                            tv=this._GetValueFromArray(bgcolor,2);
                        }
                        else
                        {
                            bgcolor =[m_netbuf[begin],m_netbuf[begin+1],m_netbuf[begin+2],m_netbuf[begin+3]];
                            tv=this._GetValueFromArray(bgcolor,3);
                        }
                        r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                        g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                        b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                        bgcolor=[r,g,b,255];
                        lastbgcolor=bgcolor;
                    }                                                                 
                                                                              
                    if (  subencoding[0]==HEXTILEBACKCOLORWITHFORCOLOR                   
                        ||subencoding[0]==HEXTILEFORCOLORWITHSUBRECT)                    
                    {                                                                                                         
                        begin=bytes;
                        bytes=bytes+bpp/8;
                        if (sock.rQwait("HEXTILE", bytes-countbegin)) {
                            return false;
                        } 
                        if (bpp==8)
                        {
                            fgcolor = [m_netbuf[begin]];
                            tv=this._GetValueFromArray(fgcolor,1);
                        }
                        else if (bpp==16)
                        {
                            fgcolor = [m_netbuf[begin],m_netbuf[begin+1]];
                            tv=this._GetValueFromArray(fgcolor,2);
                        }
                        else
                        {
                            fgcolor = [m_netbuf[begin],m_netbuf[begin+1],m_netbuf[begin+2],m_netbuf[begin+3]];
                            tv=this._GetValueFromArray(fgcolor,3);
                        }
                        r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                        g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                        b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                        fgcolor=[r,g,b,255];
                        lastfgcolor=fgcolor;
                    }                                                                 
                                                                                                                     
                    begin=bytes;
                    bytes=bytes+1;
                    if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                        return false;
                    }
                    nSubrects[0]=m_netbuf[begin];

                    begin=bytes;
                    bytes=bytes+nSubrects[0]*2;
                    if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                        return false;
                    }
                    savebegin=begin;                                                      
                    try{
                        for (n=0;n<=circletime[0];n++)                                       
                        {                                                                 
                            if (n!=0)                                                      
                            {                                                              
                                x=x+16;                                                     
                                if (x>=(rx+rw)) {
                                    x=rx;
                                    y=y+16;
                                }                                
                                w=16;
                                h=16;                                                     
                                if ((rx+rw-x)<16) w=rx+rw-x;                                  
                                if ((ry+rh-y)<16) h=ry+rh-y;                                  
                            }
                            display.fillRect(x,y,w,h,bgcolor);
                            begin=savebegin;
                            for (i = 0; i < nSubrects[0]; i++)                                
                            {                                                              
                                sx = m_netbuf[begin] >> 4;                                             
                                sy = m_netbuf[begin++] & 0x0f;                                         
                                sw = (m_netbuf[begin] >> 4) + 1;                                       
                                sh = (m_netbuf[begin++] & 0x0f) + 1;                                   
                                display.fillRect(x+sx, y+sy, sw, sh, fgcolor);
                            }
                        } 
                    } catch(err){
                        console.log(err);
                    }                                                   
                    sock.rQi=bytes;                                                                                  
                    this._beginx=x+16;
                    this._beginy=y;
                    this._lastbgcolor=lastbgcolor;
                    this._lastfgcolor=lastfgcolor;
                    continue;                                                         
                }                                                                    
                                                                              
                if (  subencoding[0]==HEXTILEBACKCOLORWITHSUBCOLOR                      
                    ||subencoding[0]==HEXTILESUBCOLOR)                                  
                {                                                                    
                    if (subencoding[0]==HEXTILEBACKCOLORWITHSUBCOLOR)                    
                    {                                                                                                   
                        begin=bytes;
                        bytes=bytes+(bpp/8);
                        if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                            return false;
                        } 
                        if (bpp==8)
                        {
                            bgcolor = [m_netbuf[begin]];
                            tv=this._GetValueFromArray(bgcolor,1);
                        }
                        else if (bpp==16)
                        {
                            bgcolor = [m_netbuf[begin],m_netbuf[begin+1]];
                            tv=this._GetValueFromArray(bgcolor,2);
                        }
                        else
                        {
                            bgcolor = [m_netbuf[begin],m_netbuf[begin+1],m_netbuf[begin+2],m_netbuf[begin+3]];
                            tv=this._GetValueFromArray(bgcolor,3);
                        }
                        r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                        g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                        b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                        bgcolor=[r,g,b,255];
                        lastbgcolor=bgcolor;
                    }                                                                 
                                                                                                                  
                    begin=bytes;
                    bytes=bytes+1;
                    if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                        return false;
                    } 
                    nSubrects[0]=m_netbuf[begin];

                    begin=bytes;
                    bytes=bytes+nSubrects[0]*(2+(bpp/8));
                    if (sock.rQwait("HEXTILE",bytes-countbegin)) {
                        return false;
                    }            
                    savebegin=begin; 
                    try{
                        for (n=0;n<=circletime[0];n++)                                       
                        {                                                                 
                            if (n!=0)                                                      
                            {                                                              
                                x=x+16;                                                     
                                if (x>=(rx+rw)) {
                                    x=rx;
                                    y=y+16;
                                }                                
                                w=16;
                                h=16;                                                     
                                if ((rx+rw-x)<16) w=rx+rw-x;                                  
                                if ((ry+rh-y)<16) h=ry+rh-y;                                  
                            }                                             
                            display.fillRect(x,y,w,h,bgcolor);
                            begin=savebegin;
                            pos=begin;
                            for (i = 0; i < nSubrects[0]; i++)                                
                            {                               
                                if (bpp==8)
                                {
                                    fgcolor = [m_netbuf[pos]];
                                    tv=this._GetValueFromArray(fgcolor,1);
                                }
                                else if (bpp==16)
                                {
                                    fgcolor = [m_netbuf[pos],m_netbuf[pos+1]];
                                    tv=this._GetValueFromArray(fgcolor,2);
                                }
                                else
                                {
                                    fgcolor = [m_netbuf[pos],m_netbuf[pos+1],m_netbuf[pos+2],m_netbuf[pos+3]];
                                    tv=this._GetValueFromArray(fgcolor,3);
                                }
                                r = ((tv >> rs) & rm) * 255 / rm;//if (r>128) r=r+rscale-1;if (r>255) r=255;
                                g = ((tv >> gs) & gm) * 255 / gm;//if (g>128) g=g+gscale-1;if (g>255) g=255;
                                b = ((tv >> bs) & bm) * 255 / bm;//if (b>128) b=b+bscale-1;if (b>255) b=255;
                                fgcolor=[r,g,b,255];
                                lastfgcolor=fgcolor;
                                pos=pos+(bpp/8);
                                sx = m_netbuf[pos] >> 4;                                             
                                sy = m_netbuf[pos++] & 0x0f;                                         
                                sw = (m_netbuf[pos] >> 4) + 1;                                       
                                sh = (m_netbuf[pos++] & 0x0f) + 1;                                   
                                display.fillRect(x+sx, y+sy, sw, sh, fgcolor);
                            }
                        }
                    } catch(err){
                        console.log(err);
                    }          
                    sock.rQi=bytes;
                    this._beginx=x+16;
                    this._beginy=y;
                    this._lastbgcolor=lastbgcolor;
                    this._lastfgcolor=lastfgcolor;
                    continue;
                }
                sock.rQi=bytes;
                this._beginx=x+16;
                this._beginy=y;
                this._lastbgcolor=lastbgcolor;
                this._lastfgcolor=lastfgcolor;
            }
            startx=rx;
            this._beginx=rx;
            this._beginy=y+16;
            this._lastbgcolor=lastbgcolor;
            this._lastfgcolor=lastfgcolor;
        }
        this._beginx=-1;//ȫϣ򽫼¼м䴦λδ
        this._beginy=-1;
        this._lastbgcolor=[0,0,0,0];
        this._lastbgcolor=[255,255,255,255];
        return true;
    }
}