/*
 * noVNC: HTML5 VNC client
 * Copyright (C) 2019 The noVNC Authors
 * Licensed under MPL 2.0 (see LICENSE.txt)
 *
 * See README.md for usage and integration instructions.
 */

// Decode from UTF-8
import CP936 from "./CP936.js";
export function decodeUTF8(utf8string, allowLatin1=false) {
    try {
        return decodeURIComponent(escape(utf8string));
    } catch (e) {
        if (e instanceof URIError) {
            if (allowLatin1) {
                // If we allow Latin1 we can ignore any decoding fails
                // and in these cases return the original string
                return utf8string;
                //const a = escape(utf8string).replace(/\%/g, "%25");
                //return decodeURI(decodeURIComponent(a))
              
            }
        } else {
            const a = escape(utf8string).replace(/\%/g, "%25");
            return decodeURIComponent(a);
        }
        throw e;
    }
}

// Encode to UTF-8
export function encodeUTF8(DOMString) {
    return unescape(encodeURIComponent(DOMString));
}
export function setCookie(name, value, time) {
    var strsec = getsec(time);
    var exp = new Date();
    exp.setTime(exp.getTime() + strsec * 1);
    document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
}
export function getCookie(name) {
    var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");

    if (arr = document.cookie.match(reg))

        return (arr[2]);
    else
        return null;
}
export function delCookie(name) {
    var exp = new Date();
    exp.setTime(exp.getTime() - 1);
    var cval = getCookie(name);
    if (cval != null)
        document.cookie = name + "=" + cval + ";expires=" + exp.toGMTString();
}
function getsec(str) {
    var str1 = str.substring(1, str.length) * 1;
    var str2 = str.substring(0, 1);
    if (str2 == "s") {
        return str1 * 1000;
    }
    else if (str2 == "h") {
        return str1 * 60 * 60 * 1000;
    }
    else if (str2 == "d") {
        return str1 * 24 * 60 * 60 * 1000;
    }
}
export function IDecodeURIGb(Source, CP936) // Pe = percent encoding; %xx[,%xx]
{ // shawl.qiu code, return string|void return; Func: fGetUtfHex
    var bStr = false;
    if (Source.constructor == String) Source = [Source], bStr = true;

    //if(CP936==null) fFatalError("����ӳ�������Ϊ��!");

    var iLBound = 0;
    var iUBound = 0;
    iLBound = -1; iUBound = 0x7f;

    Source[0] = Source[0].replace(/\+/g, " ");

    var Len = Source[0].length;

    for (var i = 0; i < Len; i++) {
        var iIndex = Source[0].indexOf("%", i);
        if (iIndex === -1) break;

        var sHex = Source[0].slice(iIndex + 1, iIndex + 3);
        var iCode = parseInt(sHex, 16);

        //document.write("<br/>sHex: "+sHex);
       
        var bakRear=Source[0].slice(iIndex + 3);
        
        if (iCode > -1 && iCode <= 0x7f) // ascii
        {//将解码出来的和后面未处理的重新拼接
           
            Source[0] =
                [
                    Source[0].slice(0, iIndex)
                    , String.fromCharCode(iCode)
                    , bakRear
                ].join("");
        }
        else {
            var sHexRaw = Source[0].slice(iIndex + 3, iIndex + 6);
            //document.write("<br/>sHexRaw: "+sHexRaw);
            if (sHexRaw.charAt(0) != "%")
            {
                Source[0] =
                [
                    Source[0].slice(0, iIndex)
                    , ''
                    , bakRear
                ].join("");
                continue;
            }
            var bakRear6=Source[0].slice(iIndex + 6);
            sHex += sHexRaw.slice(1);
            var sUniHex = fGetUtfHex(sHex, CP936);
            //document.write("<br/>sHex: "+sHex);
            //document.write("<br/>sUniHex: "+sUniHex);
            Source[0] =
                [
                    Source[0].slice(0, iIndex)
                    , String.fromCharCode(parseInt(sUniHex, 16))
                    , bakRear6
                ].join("");
        } // end if(iCode<-1&&iCode<0x7f)
    } // end for(var i=0; i<Len; i++)

    if (bStr) return Source[0];
} // end function IDecodeURIGb(Source)

function fGetUtfHex(sGbHex, CP936) { // shawl.qiu code, return string
    sGbHex = sGbHex.toUpperCase();
    var iIndex = CP936[0].indexOf(sGbHex);
    if (iIndex === -1) return "0x005F";

    var iBegin = iIndex + sGbHex.length + 1;
    return CP936[0].substring(iBegin, iBegin + 6);
} // end function fGetMapTableChar(sHex)
export function GetGB2312(sGbHex, getCP936){
    getCP936=[getCP936];
    //将得到的中文编码准换成unicode编码
    var newsGbHex=(sGbHex.toString(16)).toUpperCase();
    var iIndex = getCP936[0].indexOf(String.fromCharCode(9)+"0x"+newsGbHex);//此处的空格部分为tab键，ascii为09
    if (iIndex === -1) return "0x005F";
    var iBegin = iIndex-6;
    return getCP936[0].substring(iBegin, iBegin + 6);
}

