<!doctype html>

<html lang="en">

<head>

  <meta charset="utf-8">

  <title>jQuery UI Droppable - Prevent propagation</title>

  <link rel="stylesheet" href="jquery-ui.css">

<script src="external/jquery/jquery.js"></script>

  <script src="jquery-ui.js"></script>

  <style>

  #draggable { width: 100px; height: 40px; padding: 0.5em; float: left; margin: 10px 10px 10px 0; }

  #droppable, #droppable2 { width: 230px; height: 120px; padding: 0.5em; float: left; margin: 10px; }

  #droppable-inner, #droppable2-inner { width: 170px; height: 60px; padding: 0.5em; float: left; margin: 10px; }

  </style>

  <script>

  $(function() {

    $( "#draggable" ).draggable();
	
	$( "#tab1,#tab2,#tab3" ).draggable();
 	

    $( "#droppable, #droppable-inner" ).droppable({

      activeClass: "ui-state-hover",

      hoverClass: "ui-state-active",

      drop: function( event, ui ) {

        $( this )

          .addClass( "ui-state-highlight" )

          .find( "> p" )

            .html( "Dropped!" );

        return false;

      }

    });

 

    $( "#droppable2, #droppable2-inner" ).droppable({

      greedy: true,

      activeClass: "ui-state-hover",

      hoverClass: "ui-state-active",

      drop: function( event, ui ) {

        $( this )

          .addClass( "ui-state-highlight" )

          .find( "> p" )

            .html( "Dropped!" );

      }

    });

  });

  </script>

</head>

<body>

 

<div id="draggable" class="ui-widget-content">

  <p>Drag me to my target</p>

</div>

 

<div id="droppable" class="ui-widget-header">

  <p>Outer droppable</p>

  <div id="droppable-inner" class="ui-widget-header">

    <p>Inner droppable (not greedy)</p>

  </div>

</div>

 

<div id="droppable2" class="ui-widget-header">

  <p>Outer droppable</p>

  <div id="droppable2-inner" class="ui-widget-header">

    <p>Inner droppable (greedy)</p>

  </div>

</div>
<div id="mark" style=" position:absolute;width:100%;height:100%;top:0px;left:0px;border:1px solid #333; z-index:9999;display:none; outline:1px solid #333;"></div>

 <input type="button" value="open" id="openbtn">
<div id="dialog" title="Basic dialog">

  <p id="content">This is an animated dialog which is useful for displaying information. The dialog window can be moved, resized and closed with the 'x' icon.</p>

</div>

<script>
	$(function(){
		$("#dialog").dialog({
			autoOpen:false,
			buttons:{
				"Close":function(){
					$("#dialog").dialog("close");
				}
			},
			width:500,
			height:500,
		});
		$("#openbtn").click(function(){
			$.get("/aaa.asp",function(data){
				$( "#tab1,#tab2,#tab3" ).draggable({
					helper:"clone",
					appendTo: "#mark",
					opacity:0.5,
					drag:function(){
						 $("#mark").show();
						 
						},
					stop:function(){
						$("#mark").hide();
					}
					});
				html=data
				});
			$("#content").html(html);
			$("#dialog").dialog("open");
			});
			
			 $("#droppable").droppable({
				 drop:function(event , ui){
					 //alert(ui.draggable.text());
					 $(this).html(ui.draggable.html());
					 }
			});
	});
		

</script>
 

</body>

</html>


 