import sys
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from WMR import *
from myfuction import *


class MainForm(QMainWindow, Ui_MainWindow):
    message_box = []

    def __init__(self, parent=None):
        super(MainForm, self).__init__(parent)
        self.setupUi(self)

        # 设置窗口风格
        QApplication.setStyle(QStyleFactory.create('Fusion'))

        # 连接槽函数
        self.btn_send.clicked.connect(self.Call_send)

    def Call_send(self):

        # 获取联系人与拟发送信息
        contact_person_text = self.textEdit_contact_person_need_to_send.toPlainText()
        message_content_text = self.textEdit_message_need_to_send.toPlainText()

        # 判断是否为空
        if contact_person_text == "":
            msg_box = QMessageBox(QMessageBox.Warning, '警告', '联系人为空')
            msg_box.exec_()
            return

        if message_content_text == "":
            msg_box = QMessageBox(QMessageBox.Warning, '警告', '发送内容为空')
            msg_box.exec_()
            return

        # 判断动作执行条件
        if not self.checkBox_left.isChecked():
            msg_box = QMessageBox(QMessageBox.Warning, '警告', '微信主程序未吸附到左屏幕')
            msg_box.exec_()
            return

        if not self.checkBox_right.isChecked():
            msg_box = QMessageBox(QMessageBox.Warning, '警告', 'WMR程序未吸附到右屏幕')
            msg_box.exec_()
            return

        if not self.checkBox_send_hotkey.isChecked():
            msg_box = QMessageBox(QMessageBox.Warning, '警告', '微信发送快捷键未设置为Ctrl+Enter')
            msg_box.exec_()
            return

        contact_person_list = contact_person_text.splitlines()
        message_content_list = message_content_text.splitlines()
        print(contact_person_list)
        print(message_content_list)
        # 执行发送动作
        for i in contact_person_list:
            return_wechat_window()
            wechat_search(i)
            for j in message_content_list:
                if self.checkBox_add_name.isChecked():
                    wechat_send(i[-2:]+" "+j) # 是否带上名字
                else:
                    wechat_send(j)
            # 显示返回的消息
            self.message_box.append("成功发送消息给{}.".format(i))
        show_message = ""
        for i in self.message_box:
            show_message = show_message + i + "\n"
        self.label_message.setText(show_message)


if __name__ == '__main__':
    app = QApplication(sys.argv)
    mywin = MainForm()
    mywin.show()
    sys.exit(app.exec_())
