import os
import os.path

# UI文件所在路径
dir = './'

# 输出目录下的所有UI文件
def listUiFile():
    list = []
    files = os.listdir(dir)
    for filename in files:
        if os.path.splitext(filename)[1] == '.ui':
            list.append(filename)
    return list

# 把扩展名为.ui的文件修改为.py
def transPyFile(filename):
    return os.path.splitext(filename)[0] + '.py'

def RunMain():
    list = listUiFile()
    for uifile in list:
        pyfile = transPyFile(uifile)
        cmd = 'pyuic5 -o {pyfile} {uifile}'.format(pyfile=pyfile,uifile=uifile)
        os.system(cmd)

if __name__ == "__main__":
    RunMain()