/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.proxies;

import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.blocks.BlockDisenchantmentTable;
import de.impelon.disenchanter.blocks.ItemBlockDisenchantment;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTableAutomatic;
import de.impelon.disenchanter.gui.GUIHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommonProxy {
    public static final Block disenchantmentTable = new BlockDisenchantmentTable();
    public static final Item itemDisenchantment = new ItemBlockDisenchantment();

    public void preInit(FMLPreInitializationEvent ev) {
        Configuration config;
        DisenchanterMain.config = config = new Configuration(ev.getSuggestedConfigurationFile());
        config.load();
        config.get("general", "CheckVersion", true, "Should Disenchanter check for new versions on startup?");
        config.get("disenchanting", "FlatDamage", 10, "How much flat damage should be dealt to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamage", 0.025, "How much of the Item's maximal durability should be dealt as damage to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamageReduceable", 0.2, "How much of the Item's maximal durability should be dealt as reduceable damage to Items when disenchanting?");
        config.get("disenchanting", "MachineDamageMultiplier", 2.5, "By how much should the dammage on the item be multiplied when using an automaic Disenchantment Table?");
        config.get("disenchanting", "EnchantmentLossChance", 0.0, "What should the probability be of additional enchantments being lost from Items when disenchanting?");
        config.save();
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTable.class, (String)"TileDisentchantmentTable");
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTableAutomatic.class, (String)"TileDisentchantmentTableAutomatic");
        GameRegistry.register((IForgeRegistryEntry)disenchantmentTable, (ResourceLocation)new ResourceLocation("disenchanter", disenchantmentTable.func_149739_a().substring(5)));
        GameRegistry.register((IForgeRegistryEntry)itemDisenchantment, (ResourceLocation)new ResourceLocation("disenchanter", disenchantmentTable.func_149739_a().substring(5)));
    }

    public void load(FMLInitializationEvent ev) {
        if (DisenchanterMain.config.get("general", "CheckVersion", true).getBoolean()) {
            MinecraftForge.EVENT_BUS.register((Object)DisenchanterMain.versionChecker);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DisenchanterMain.instance, (IGuiHandler)new GUIHandler());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1), new Object[]{"   ", "YEY", "ETE", Character.valueOf('T'), Blocks.field_150381_bn, Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('Y'), "dyeYellow"}));
        if (DisenchanterMain.config.get("general", "EnableAutomaticRecipe", true).getBoolean()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 1), new Object[]{"IMI", "BCB", "ITI", Character.valueOf('T'), new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, 0), Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('B'), "dyeBlack", Character.valueOf('M'), Items.field_151132_bS}));
        }
    }

    public void postInit(FMLPostInitializationEvent ev) {
    }
}

