/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.tartaros.common.capabilities;

import ladysnake.tartaros.common.capabilities.IIncorporealHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class IncorporealDataHandler {
    @CapabilityInject(value=IIncorporealHandler.class)
    public static final Capability<IIncorporealHandler> CAPABILITY_INCORPOREAL = null;

    public static void register() {
        System.out.println(CAPABILITY_INCORPOREAL);
        CapabilityManager.INSTANCE.register(IIncorporealHandler.class, (Capability.IStorage)new Storage(), DefaultIncorporealHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)new IncorporealDataHandler());
    }

    public static IIncorporealHandler getHandler(Entity entity) {
        if (entity.hasCapability(CAPABILITY_INCORPOREAL, EnumFacing.DOWN)) {
            return (IIncorporealHandler)entity.getCapability(CAPABILITY_INCORPOREAL, EnumFacing.DOWN);
        }
        return null;
    }

    public static class Storage
    implements Capability.IStorage<IIncorporealHandler> {
        public NBTBase writeNBT(Capability<IIncorporealHandler> capability, IIncorporealHandler instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("incorporeal", instance.getIncorporeal());
            return tag;
        }

        public void readNBT(Capability<IIncorporealHandler> capability, IIncorporealHandler instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            instance.setIncorporeal(tag.func_74762_e("incorporeal"));
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        IIncorporealHandler instance = (IIncorporealHandler)CAPABILITY_INCORPOREAL.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY_INCORPOREAL;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_INCORPOREAL.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_INCORPOREAL.getStorage().writeNBT(CAPABILITY_INCORPOREAL, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_INCORPOREAL.getStorage().readNBT(CAPABILITY_INCORPOREAL, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class DefaultIncorporealHandler
    implements IIncorporealHandler {
        private int incorporeal;

        @Override
        public void setIncorporeal(boolean enable, EntityPlayer p) {
            int n = this.incorporeal = enable ? 1 : 0;
            if (!p.func_184812_l_()) {
                p.field_71075_bZ.field_75099_e = !enable;
                p.field_71075_bZ.field_75101_c = enable && p.field_71068_ca > 0;
                p.field_71075_bZ.field_75102_a = enable;
                p.field_71075_bZ.field_75100_b = enable && p.field_71068_ca > 0;
                p.func_184224_h(enable);
            }
        }

        @Override
        public void setIncorporeal(int ghostMode) {
            this.incorporeal = ghostMode == 0 ? 0 : 1;
        }

        @Override
        public boolean isIncorporeal() {
            return this.incorporeal == 1;
        }

        @Override
        public int getIncorporeal() {
            return this.incorporeal;
        }
    }
}

